
/* Generated By:JJTree: Do not edit this line. SimpleNode.java */
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen.ext.parsers.java_1_2;

// New ---------------------------
import org.ejen.util.arl.ArlUtil;

// --------------------------- New
/**
 * Modification of the <code>SimpleNode</code> class generated by
 * <a HREF="http://www.webgain.com/products/java_cc/">JavaCC</a>. 
 * @author F. Wolff
 * @version 1.0
 */
public class SimpleNode implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    // New ---------------------------
 protected Token first, last;
    // --------------------------- New
 public SimpleNode(int i) {
        id = i;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        parser = p;
    }

    public void jjtOpen() {
        // New ---------------------------
        first = parser.getToken(1);
        // --------------------------- New
    }

    public void jjtClose() {
        // New ---------------------------
        last = parser.getToken(0);
        // --------------------------- New
    }

    public void jjtSetParent(Node n) {
        parent = n;
    }

    public Node jjtGetParent() {
        return parent;
    }

    public void jjtAddChild(Node n, int i) {
        if (children == null) {
            children = new Node[i + 1];
        } else if (i >= children.length) {
            Node c[] = new Node[i + 1];

            System.arraycopy(children, 0, c, 0, children.length);
            children = c;
        }
        children[i] = n;
    }

    public Node jjtGetChild(int i) {
        return children[i];
    }

    public int jjtGetNumChildren() {
        return (children == null) ? 0 : children.length;
    }

    /* You can override these two methods in subclasses of SimpleNode to
     customize the way the node appears when the tree is dumped.  If
     your output uses more than one line you should override
     toString(String), otherwise overriding toString() is probably all
     you need to do. */
    public String  toString() {
        return JavaParserTreeConstants.jjtNodeName[id];
    }

    public String  toString(String  prefix) {
        return prefix + toString();
    }

    /* Override this method if you want to customize how the node dumps
     out its children. */
    public void dump(String  prefix) {
        System.out.println(toString(prefix));
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                SimpleNode n = (SimpleNode) children[i];

                if (n != null) {
                    n.dump(prefix + " ");
                }
            }
        }
    }

    // New ---------------------------
 /**
     * Creates a new parent DOM node for this SimpleNode, stops visiting or just visits
     * children nodes of this SimpleNode, depending on the 'nodesMap' parameter.
     * Tokens DOM nodes are also created except if this SimpleNode is marked for removal.
     * <p>
     * <table class="usage"><tr><td class="usage"><pre>
     *
     *  &lt;CompilationUnit id="0"&gt;
     *    ...
     *  &lt;/CompilationUnit&gt;
     * </pre></td></tr></table>
     * <p>
     * Each SimpleNode is converted to a DOM Node using this rule: the Node name
     * is the corresponding name of the production (according to the grammar), and
     * its id attribute is the corresponding integer identifier
     * ({@link JavaParserTreeConstants#JJTCOMPILATIONUNIT}). You may need to run
     * JavaCC with the source to read the JavaParserTreeConstants.java file.
     * <p>
     * See also {@link org.ejen.util.arl.ArlUtil}.
     * <p>
     * @param doc the Document in which the nodes are to be created.
     * @param parent the DOM node to which the new Node must be appended.
     * @param nodesMap an <code>int</code> array specifying, for each SimpleNode
     *        id, if this node must accepted (created), crossed (only children
     *        are visited without a node creation for this SimpleNode) or
     *        removed (no node creation, all children are skipped).
     * @param tokensMap passed to the
     *        {@link org.ejen.ext.parsers.java_1_2.Token#toNode(org.w3c.dom.Document,
     *                                                          org.w3c.dom.Node,
     *                                                          int[],boolean)
     *        Token.toNode(...)} function.
     * @throws org.w3c.dom.DOMException DOM errors...
     */
    public final void toNode(org.w3c.dom.Document  doc,
            org.w3c.dom.Node  parent,
            int nodesMap[],
            int[] tokensMap,
            boolean tokensPos)
        throws org.w3c.dom.DOMException  {
        if (nodesMap[id] == ArlUtil.F_REMOVE) {
            return;
        }
        if (nodesMap[id] == ArlUtil.F_ACCEPT) {
            org.w3c.dom.Element  elt = doc.createElement(JavaParserTreeConstants.jjtNodeName[id]);

            elt.setAttribute("id", String.valueOf(id));
            parent.appendChild(elt);
            parent = elt;
        }
        Token t = new Token();

        t.next = first;
        if (children != null) {
            for (int i = 0; i < children.length; i++) {
                SimpleNode cn = (SimpleNode) (children[i]);

                for (t = t.next; t != null && t != cn.first; t = t.next) {
                    t.toNode(doc, parent, tokensMap, tokensPos);
                }
                cn.toNode(doc, parent, nodesMap, tokensMap, tokensPos);
                t = cn.last;
            }
        }
        while (t != null && t != last) {
            t = t.next;
            if (t != null) {
                t.toNode(doc, parent, tokensMap, tokensPos);
            }
        }
    }
    // --------------------------- New
}
