
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen;

import java.util.Stack ;
import java.util.Hashtable ;

/**
 * Ejen context stack class. Defines a global context (an Hashtable)
 * and a stack of local contexts.
 * @author F. Wolff
 * @version 1.0
 */
public class EjenContextsStack extends Stack  {
    private Hashtable  _globalContext = new Hashtable ();

    /**
     * Looks at the EjenContext at the top of this EjenContextsStack without
     * removing it from the stack.
     * @return the EjenContext at the top of this EjenContextsStack.
     * @throws java.util.EmptyStackException if this EjenContextsStack is empty.
     */
    public EjenContext peekContext() {
        return (EjenContext) peek();
    }

    /**
     * Returns the EjenContext at the specified position in this EjenContextsStack.
     * @param index index of EjenContext to return.
     * @return the EjenContext at the top of this EjenContextsStack.
     * @throws java.lang.ArrayIndexOutOfBoundsException index is out of range
     *         (index < 0 || index >= size()).
     */
    public EjenContext peekContext(int index) {
        return (EjenContext) elementAt(index);
    }

    /**
     * Removes the EjenContext at the top of this EjenContextsStack and returns
     * that EjenContext as the value of this function.
     * @return the EjenContext at the top of this EjenContextsStack.
     * @throws java.util.EmptyStackException if this EjenContextsStack is empty.
     */
    public EjenContext popContext() {
        return (EjenContext) pop();
    }

    /**
     * Pushes an EjenContext onto the top of this EjenContextsStack.
     * @param ctx the EjenContext to be pushed onto this EjenContextsStack.
     * @return the ctx argument.
     */
    public EjenContext pushContext(EjenContext ctx) {
        return (EjenContext) (super.push(ctx));
    }

    /**
     * Returns the value to which the specified name is mapped in the
     * global context of this EjenContextsStack.
     * @param name a name (key) in the global context (which is an Hashtable).
     * @return the value to which the name is mapped in this global context; null
     *         if the name is not mapped to any value in this global context.
     */
    public Object  globalGet(String  name) {
        return _globalContext.get(name);
    }

    /**
     * Maps the specified name to the specified value in the global context of this
     * EjenContextsStack. Neither the name nor the value can be null.
     * @param name a name (key) in the global context.
     * @param value the value.
     * @return the previous value of the specified name in this global context, or
     *         null if it did not have one.
     */
    public Object  globalPut(String  name, Object  value) {
        return _globalContext.put(name, value);
    }
}
