/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.NodeSet;
import org.ejen.util.DOMUtil;
import org.ejen.util.XSLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class MetaDataNodeBuilder {
    public static final String S_DI_NODE_NAME = "database-information";
    public static final String S_DI_DATABASE_PRODUCT_NAME = "database-product-name";
    public static final String S_DI_DATABASE_PRODUCT_VERSION = "database-product-version";
    public static final String S_RS_COLUMN_NODE_NAME = "column";
    public static final String S_RS_CATALOG_NAME = "catalog-name";
    public static final String S_RS_COLUMN_CLASS_NAME = "column-class-name";
    public static final String S_RS_COLUMN_DISPLAY_SIZE = "column-display-size";
    public static final String S_RS_COLUMN_LABEL = "column-label";
    public static final String S_RS_COLUMN_NAME = "column-name";
    public static final String S_RS_COLUMN_TYPE = "column-type";
    public static final String S_RS_COLUMN_TYPE_NAME = "column-type-name";
    public static final String S_RS_PRECISION = "precision";
    public static final String S_RS_SCALE = "scale";
    public static final String S_RS_SCHEMA_NAME = "schema-name";
    public static final String S_RS_TABLE_NAME = "table-name";
    public static final String S_RS_AUTO_INCREMENT = "auto-increment";
    public static final String S_RS_CASE_SENSITIVE = "case-sensitive";
    public static final String S_RS_CURRENCY = "currency";
    public static final String S_RS_DEFINITELY_WRITABLE = "definitely-writable";
    public static final String S_RS_NULLABLE = "nullable";
    public static final String S_RS_READ_ONLY = "read-only";
    public static final String S_RS_SEARCHABLE = "searchable";
    public static final String S_RS_SIGNED = "signed";
    public static final String S_RS_WRITABLE = "writable";
    public static final String S_RS_COLUMN_NO_NULLS = "column-no-nulls";
    public static final String S_RS_COLUMN_NULLABLE = "column-nullable";
    public static final String S_RS_COLUMN_NULLABLE_UNKNOWN = "column-nullable-unknown";
    public static final String S_PK_NODE_NAME = "primary-key";
    public static final String S_PK_TABLE_CAT = "table-cat";
    public static final String S_PK_TABLE_SCHEM = "table-shem";
    public static final String S_PK_TABLE_NAME = "table-name";
    public static final String S_PK_COLUMN_NAME = "column-name";
    public static final String S_PK_KEY_SEQ = "key-seq";
    public static final String S_PK_PK_NAME = "pk-name";
    public static final String S_EIK_EK_NODE_NAME = "exported-key";
    public static final String S_EIK_IK_NODE_NAME = "imported-key";
    public static final String S_EIK_PKTABLE_CAT = "pktable-cat";
    public static final String S_EIK_PKTABLE_SCHEM = "pktable-shem";
    public static final String S_EIK_PKTABLE_NAME = "pktable-name";
    public static final String S_EIK_PKCOLUMN_NAME = "pkcolumn-name";
    public static final String S_EIK_FKTABLE_CAT = "fktable-cat";
    public static final String S_EIK_FKTABLE_SCHEM = "fktable-shem";
    public static final String S_EIK_FKTABLE_NAME = "fktable-name";
    public static final String S_EIK_FKCOLUMN_NAME = "fkcolumn-name";
    public static final String S_EIK_KEY_SEQ = "key-seq";
    public static final String S_EIK_UPDATE_RULE = "update-rule";
    public static final String S_EIK_DELETE_RULE = "delete-rule";
    public static final String S_EIK_FK_NAME = "fk-name";
    public static final String S_EIK_PK_NAME = "pk-name";
    public static final String S_EIK_DEFERRABILITY = "deferrability";
    public static final String S_II_NODE_NAME = "index";
    public static final String S_II_TABLE_CAT = "table-cat";
    public static final String S_II_TABLE_SCHEM = "table-shem";
    public static final String S_II_TABLE_NAME = "table-name";
    public static final String S_II_NON_UNIQUE = "non-unique";
    public static final String S_II_INDEX_QUALIFIER = "index-qualifier";
    public static final String S_II_INDEX_NAME = "index-name";
    public static final String S_II_TYPE = "type";
    public static final String S_II_ORDINAL_POSITION = "ordinal-position";
    public static final String S_II_COLUMN_NAME = "column-name";
    public static final String S_II_ASC_OR_DESC = "asc-or-desc";
    public static final String S_II_CARDINALITY = "cardinality";
    public static final String S_II_PAGES = "pages";
    public static final String S_II_FILTER_CONDITION = "filter-condition";
    public static final String S_EXCEPTION_NODE_NAME = "exception";
    public static final String S_EXCEPTION_CLASS_NAME = "class-name";
    public static final String S_EXCEPTION_CODE = "code";
    public static final String S_NOT_SUPPORTED = "#NOT_SUPPORTED";
    public static final String S_NULL = "#NULL";
    protected static NodeSet _errors = null;
    protected static Connection _activeConn = null;

    protected static Connection getConnection() throws SQLException {
        if (_activeConn == null) {
            throw new SQLException("Not connected");
        }
        return _activeConn;
    }

    public static NodeSet getErrors(ExpressionContext context) {
        return _errors;
    }

    public static Node getDatabaseInformation(ExpressionContext context) {
        Document doc = XSLUtil.getContextDocument(context);
        try {
            DatabaseMetaData dbmd = MetaDataNodeBuilder.getConnection().getMetaData();
            Element elt = doc.createElement(S_DI_NODE_NAME);
            elt.setAttribute(S_DI_DATABASE_PRODUCT_NAME, MetaDataNodeBuilder.noNull(dbmd.getDatabaseProductName()));
            elt.setAttribute(S_DI_DATABASE_PRODUCT_VERSION, MetaDataNodeBuilder.noNull(dbmd.getDatabaseProductVersion()));
            return elt;
        }
        catch (SQLException e) {
            MetaDataNodeBuilder.appendErrorNode(e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return null;
    }

    public static NodeSet getResultSetMetaData(ExpressionContext context, String table) {
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getResultSetMetaData(table, "*", S_RS_COLUMN_NODE_NAME, XSLUtil.getContextDocument(context));
    }

    public static NodeSet getResultSetMetaData(ExpressionContext context, String table, String columns) {
        table = XSLUtil.evaluate(context, table);
        columns = XSLUtil.evaluate(context, columns);
        _errors = null;
        return MetaDataNodeBuilder.getResultSetMetaData(table, columns, S_RS_COLUMN_NODE_NAME, XSLUtil.getContextDocument(context));
    }

    protected static NodeSet getResultSetMetaData(String table, String columns, String eltName, Document doc) {
        Statement stmt = null;
        try {
            stmt = MetaDataNodeBuilder.getConnection().createStatement();
            ResultSetMetaData rsmd = stmt.executeQuery("SELECT " + columns + " FROM " + table).getMetaData();
            String columnNoNulls = String.valueOf(0);
            String columnNullable = String.valueOf(1);
            String columnNullableUnknown = String.valueOf(2);
            int count = rsmd.getColumnCount();
            NodeSet ns = new NodeSet();
            ns.setShouldCacheNodes(true);
            for (int i = 1; i <= count; ++i) {
                Element elt = doc.createElement(eltName);
                try {
                    elt.setAttribute(S_RS_CATALOG_NAME, MetaDataNodeBuilder.noNull(rsmd.getCatalogName(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_CATALOG_NAME, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_COLUMN_CLASS_NAME, MetaDataNodeBuilder.noNull(rsmd.getColumnClassName(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_COLUMN_CLASS_NAME, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_COLUMN_DISPLAY_SIZE, String.valueOf(rsmd.getColumnDisplaySize(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_COLUMN_DISPLAY_SIZE, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_COLUMN_LABEL, MetaDataNodeBuilder.noNull(rsmd.getColumnLabel(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_COLUMN_LABEL, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute("column-name", MetaDataNodeBuilder.noNull(rsmd.getColumnName(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute("column-name", S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_COLUMN_TYPE, String.valueOf(rsmd.getColumnType(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_COLUMN_TYPE, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_COLUMN_TYPE_NAME, MetaDataNodeBuilder.noNull(rsmd.getColumnTypeName(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_COLUMN_TYPE_NAME, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_PRECISION, String.valueOf(rsmd.getPrecision(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_PRECISION, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_SCALE, String.valueOf(rsmd.getScale(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_SCALE, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_SCHEMA_NAME, MetaDataNodeBuilder.noNull(rsmd.getSchemaName(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_SCHEMA_NAME, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute("table-name", MetaDataNodeBuilder.noNull(rsmd.getTableName(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute("table-name", S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_AUTO_INCREMENT, String.valueOf(rsmd.isAutoIncrement(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_AUTO_INCREMENT, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_CASE_SENSITIVE, String.valueOf(rsmd.isCaseSensitive(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_CASE_SENSITIVE, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_CURRENCY, String.valueOf(rsmd.isCurrency(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_CURRENCY, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_DEFINITELY_WRITABLE, String.valueOf(rsmd.isDefinitelyWritable(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_DEFINITELY_WRITABLE, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_NULLABLE, String.valueOf(rsmd.isNullable(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_NULLABLE, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_READ_ONLY, String.valueOf(rsmd.isReadOnly(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_READ_ONLY, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_SEARCHABLE, String.valueOf(rsmd.isSearchable(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_SEARCHABLE, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_SIGNED, String.valueOf(rsmd.isSigned(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_SIGNED, S_NOT_SUPPORTED);
                }
                try {
                    elt.setAttribute(S_RS_WRITABLE, String.valueOf(rsmd.isWritable(i)));
                }
                catch (SQLException e) {
                    elt.setAttribute(S_RS_WRITABLE, S_NOT_SUPPORTED);
                }
                elt.setAttribute(S_RS_COLUMN_NO_NULLS, columnNoNulls);
                elt.setAttribute(S_RS_COLUMN_NULLABLE, columnNullable);
                elt.setAttribute(S_RS_COLUMN_NULLABLE_UNKNOWN, columnNullableUnknown);
                ns.addElement((Node)elt);
            }
            NodeSet nodeSet = ns;
            return nodeSet;
        }
        catch (SQLException e) {
            MetaDataNodeBuilder.appendErrorNode(e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    MetaDataNodeBuilder.appendErrorNode(e);
                }
            }
        }
        return null;
    }

    public static NodeSet getPrimaryKeys(ExpressionContext context, String table) {
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getPrimaryKeys(null, null, table, XSLUtil.getContextDocument(context));
    }

    public static NodeSet getPrimaryKeys(ExpressionContext context, String catalog, String schema, String table) {
        catalog = XSLUtil.evaluate(context, catalog);
        schema = XSLUtil.evaluate(context, schema);
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getPrimaryKeys(catalog, schema, table, XSLUtil.getContextDocument(context));
    }

    protected static NodeSet getPrimaryKeys(String catalog, String schema, String table, Document doc) {
        ResultSet rs = null;
        try {
            rs = MetaDataNodeBuilder.getConnection().getMetaData().getPrimaryKeys(catalog, schema, table);
            NodeSet ns = new NodeSet();
            ns.setShouldCacheNodes(true);
            while (rs.next()) {
                Element elt = doc.createElement(S_PK_NODE_NAME);
                elt.setAttribute("table-cat", MetaDataNodeBuilder.noNull(rs.getString(1)));
                elt.setAttribute("table-shem", MetaDataNodeBuilder.noNull(rs.getString(2)));
                elt.setAttribute("table-name", MetaDataNodeBuilder.noNull(rs.getString(3)));
                elt.setAttribute("column-name", MetaDataNodeBuilder.noNull(rs.getString(4)));
                elt.setAttribute("key-seq", String.valueOf(rs.getShort(5)));
                elt.setAttribute("pk-name", MetaDataNodeBuilder.noNull(rs.getString(6)));
                ns.addElement((Node)elt);
            }
            NodeSet nodeSet = ns;
            return nodeSet;
        }
        catch (SQLException e) {
            MetaDataNodeBuilder.appendErrorNode(e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    MetaDataNodeBuilder.appendErrorNode(e);
                }
            }
        }
        return null;
    }

    public static NodeSet getImportedKeys(ExpressionContext context, String table) {
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getImportedKeys(null, null, table, XSLUtil.getContextDocument(context));
    }

    public static NodeSet getImportedKeys(ExpressionContext context, String catalog, String schema, String table) {
        catalog = XSLUtil.evaluate(context, catalog);
        schema = XSLUtil.evaluate(context, schema);
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getImportedKeys(catalog, schema, table, XSLUtil.getContextDocument(context));
    }

    protected static NodeSet getImportedKeys(String catalog, String schema, String table, Document doc) {
        ResultSet rs = null;
        try {
            rs = MetaDataNodeBuilder.getConnection().getMetaData().getImportedKeys(catalog, schema, table);
            NodeSet ns = new NodeSet();
            ns.setShouldCacheNodes(true);
            MetaDataNodeBuilder.getImportedOrExportedKeys(rs, S_EIK_IK_NODE_NAME, ns, doc);
            NodeSet nodeSet = ns;
            return nodeSet;
        }
        catch (SQLException e) {
            MetaDataNodeBuilder.appendErrorNode(e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    MetaDataNodeBuilder.appendErrorNode(e);
                }
            }
        }
        return null;
    }

    public static NodeSet getExportedKeys(ExpressionContext context, String table) {
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getExportedKeys(null, null, table, XSLUtil.getContextDocument(context));
    }

    public static NodeSet getExportedKeys(ExpressionContext context, String catalog, String schema, String table) {
        catalog = XSLUtil.evaluate(context, catalog);
        schema = XSLUtil.evaluate(context, schema);
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getExportedKeys(catalog, schema, table, XSLUtil.getContextDocument(context));
    }

    protected static NodeSet getExportedKeys(String catalog, String schema, String table, Document doc) {
        ResultSet rs = null;
        try {
            rs = MetaDataNodeBuilder.getConnection().getMetaData().getExportedKeys(catalog, schema, table);
            NodeSet ns = new NodeSet();
            ns.setShouldCacheNodes(true);
            MetaDataNodeBuilder.getImportedOrExportedKeys(rs, S_EIK_EK_NODE_NAME, ns, doc);
            NodeSet nodeSet = ns;
            return nodeSet;
        }
        catch (SQLException e) {
            MetaDataNodeBuilder.appendErrorNode(e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    MetaDataNodeBuilder.appendErrorNode(e);
                }
            }
        }
        return null;
    }

    protected static void getImportedOrExportedKeys(ResultSet rs, String eltName, NodeSet ns, Document doc) throws Exception {
        while (rs.next()) {
            Element elt = doc.createElement(eltName);
            elt.setAttribute(S_EIK_PKTABLE_CAT, MetaDataNodeBuilder.noNull(rs.getString(1)));
            elt.setAttribute(S_EIK_PKTABLE_SCHEM, MetaDataNodeBuilder.noNull(rs.getString(2)));
            elt.setAttribute(S_EIK_PKTABLE_NAME, MetaDataNodeBuilder.noNull(rs.getString(3)));
            elt.setAttribute(S_EIK_PKCOLUMN_NAME, MetaDataNodeBuilder.noNull(rs.getString(4)));
            elt.setAttribute(S_EIK_FKTABLE_CAT, MetaDataNodeBuilder.noNull(rs.getString(5)));
            elt.setAttribute(S_EIK_FKTABLE_SCHEM, MetaDataNodeBuilder.noNull(rs.getString(6)));
            elt.setAttribute(S_EIK_FKTABLE_NAME, MetaDataNodeBuilder.noNull(rs.getString(7)));
            elt.setAttribute(S_EIK_FKCOLUMN_NAME, MetaDataNodeBuilder.noNull(rs.getString(8)));
            elt.setAttribute("key-seq", String.valueOf(rs.getShort(9)));
            elt.setAttribute(S_EIK_UPDATE_RULE, String.valueOf(rs.getShort(10)));
            elt.setAttribute(S_EIK_DELETE_RULE, String.valueOf(rs.getShort(11)));
            elt.setAttribute(S_EIK_FK_NAME, MetaDataNodeBuilder.noNull(rs.getString(12)));
            elt.setAttribute("pk-name", MetaDataNodeBuilder.noNull(rs.getString(13)));
            elt.setAttribute(S_EIK_DEFERRABILITY, String.valueOf(rs.getShort(14)));
            ns.addElement((Node)elt);
        }
    }

    public static NodeSet getIndexInfo(ExpressionContext context, String table) {
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getIndexInfo(null, null, table, XSLUtil.getContextDocument(context));
    }

    public static NodeSet getIndexInfo(ExpressionContext context, String catalog, String schema, String table) {
        catalog = XSLUtil.evaluate(context, catalog);
        schema = XSLUtil.evaluate(context, schema);
        table = XSLUtil.evaluate(context, table);
        _errors = null;
        return MetaDataNodeBuilder.getIndexInfo(catalog, schema, table, XSLUtil.getContextDocument(context));
    }

    protected static NodeSet getIndexInfo(String catalog, String schema, String table, Document doc) {
        ResultSet rs = null;
        try {
            rs = MetaDataNodeBuilder.getConnection().getMetaData().getIndexInfo(catalog, schema, table, false, false);
            NodeSet ns = new NodeSet();
            ns.setShouldCacheNodes(true);
            while (rs.next()) {
                Element elt = doc.createElement(S_II_NODE_NAME);
                elt.setAttribute("table-cat", MetaDataNodeBuilder.noNull(rs.getString(1)));
                elt.setAttribute("table-shem", MetaDataNodeBuilder.noNull(rs.getString(2)));
                elt.setAttribute("table-name", MetaDataNodeBuilder.noNull(rs.getString(3)));
                elt.setAttribute(S_II_NON_UNIQUE, String.valueOf(rs.getBoolean(4)));
                elt.setAttribute(S_II_INDEX_QUALIFIER, MetaDataNodeBuilder.noNull(rs.getString(5)));
                elt.setAttribute(S_II_INDEX_NAME, MetaDataNodeBuilder.noNull(rs.getString(6)));
                elt.setAttribute(S_II_TYPE, String.valueOf(rs.getShort(7)));
                elt.setAttribute(S_II_ORDINAL_POSITION, String.valueOf(rs.getShort(8)));
                elt.setAttribute("column-name", MetaDataNodeBuilder.noNull(rs.getString(9)));
                elt.setAttribute(S_II_ASC_OR_DESC, MetaDataNodeBuilder.noNull(rs.getString(10)));
                elt.setAttribute(S_II_CARDINALITY, MetaDataNodeBuilder.noNull(rs.getString(11)));
                elt.setAttribute(S_II_PAGES, MetaDataNodeBuilder.noNull(rs.getString(12)));
                elt.setAttribute(S_II_FILTER_CONDITION, MetaDataNodeBuilder.noNull(rs.getString(13)));
                ns.addElement((Node)elt);
            }
            NodeSet nodeSet = ns;
            return nodeSet;
        }
        catch (SQLException e) {
            MetaDataNodeBuilder.appendErrorNode(e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    MetaDataNodeBuilder.appendErrorNode(e);
                }
            }
        }
        return null;
    }

    protected static void appendErrorNode(Exception e) {
        if (e == null) {
            return;
        }
        int errCode = 0;
        if (e instanceof SQLException) {
            errCode = ((SQLException)e).getErrorCode();
        }
        Document doc = null;
        if (_errors == null) {
            _errors = new NodeSet();
            _errors.setShouldCacheNodes(true);
            doc = DOMUtil.newDocument();
        } else {
            doc = _errors.getRoot() != null ? _errors.getRoot().getOwnerDocument() : DOMUtil.newDocument();
        }
        try {
            Element elt = doc.createElement(S_EXCEPTION_NODE_NAME);
            elt.setAttribute(S_EXCEPTION_CLASS_NAME, e.getClass().getName());
            elt.setAttribute(S_EXCEPTION_CODE, String.valueOf(errCode));
            elt.appendChild(doc.createTextNode(e.getMessage()));
            _errors.addElement((Node)elt);
        }
        catch (Exception f) {
            throw new WrappedRuntimeException(f);
        }
    }

    protected static String noNull(String s) {
        return s == null ? S_NULL : s;
    }
}

