
/* Generated By:JavaCC: Do not edit this line. Token.java Version 2.1 */
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen.ext.parsers.java_1_2;

// New ---------------------------
import org.ejen.util.arl.ArlUtil;

// --------------------------- New
/**
 * Modification of the <code>Token</code> class generated by
 * <a HREF="http://www.webgain.com/products/java_cc/">JavaCC</a>. 
 * @author F. Wolff
 * @version 1.0
 */
public class Token {

    /**
     * An integer that describes the kind of this token.  This numbering
     * system is determined by JavaCCParser, and a table of these numbers is
     * stored in the file ...Constants.java.
     */
    public int kind;

    /**
     * beginLine and beginColumn describe the position of the first character
     * of this token; endLine and endColumn describe the position of the
     * last character of this token.
     */
    public int beginLine, beginColumn, endLine, endColumn;

    /**
     * The string image of the token.
     */
    public String  image;

    /**
     * A reference to the next regular (non-special) token from the input
     * stream.  If this is the last token from the input stream, or if the
     * token manager has not read tokens beyond this one, this field is
     * set to null.  This is true only if this token is also a regular
     * token.  Otherwise, see below for a description of the contents of
     * this field.
     */
    public Token next;

    /**
     * This field is used to access special tokens that occur prior to this
     * token, but after the immediately preceding regular (non-special) token.
     * If there are no such special tokens, this field is set to null.
     * When there are more than one such special token, this field refers
     * to the last of these special tokens, which in turn refers to the next
     * previous special token through its specialToken field, and so on
     * until the first special token (whose specialToken field is null).
     * The next fields of special tokens refer to other special tokens that
     * immediately follow it (without an intervening regular token).  If there
     * is no such token, this field is null.
     */
    public Token specialToken;

    /**
     * Returns the image.
     */
    public final String  toString() {
        return image;
    }

    /**
     * Returns a new Token object, by default. However, if you want, you
     * can create and return subclass objects based on the value of ofKind.
     * Simply add the cases to the switch for all those special cases.
     * For example, if you have a subclass of Token called IDToken that
     * you want to create if ofKind is ID, simlpy add something like :
     *
     *    case MyParserConstants.ID : return new IDToken();
     *
     * to the following switch statement. Then you can cast matchedToken
     * variable to the appropriate type and use it in your lexical actions.
     */
    public static final Token newToken(int ofKind) {
        switch (ofKind) {
        default:
            return new Token();
        }
    }

    // New ---------------------------
 /**
     * Creates a child DOM node appended to the 'parent' node, depending on the
     * 'tokensMap' parameter. The child node will have the following structure:
     * <p>
     * <table class="usage"><tr><td class="usage"><pre>
     *
     *  &lt;tok ki="72"&gt;&lt;![CDATA[ejen]]&gt;&lt;/tok&gt;
     *
     *  <i>or, if tokensPos is true,</i>
     *
     *  &lt;tok bc="13" bl="22" ec="16" el="22" ki="72"&gt;
     *    &lt;![CDATA[ejen]]&gt;
     *  &lt;/tok&gt;
     * </pre></td></tr></table>
     * <p>
     * meaning that the token "ejen" of kind 72 ({@link JavaParserConstants#IDENTIFIER})
     * begins in the source file at the (22,13) line,column coordinates and ends at
     * the (22,16) coordinates. Token nodes may also have nested special token nodes.
     * <p>
     * See also {@link org.ejen.util.arl.ArlUtil}.
     * <p>
     * @param doc the Document in which the nodes are to be created.
     * @param parent the DOM node to which the new Node must be appended.
     * @param tokensMap an <code>int</code> array specifying, for each Token
     *        kind, if this node must accepted (created), crossed (only the
     *        CDATA section is created without a parent &lt;tok...&gt; node creation)
     *        or removed (no node creation, no CDATA section).
     * @param tokensPos if true, this Token position coordinates will be includes
     *        as attributes.
     * @throws org.w3c.dom.DOMException DOM errors...
     */
    public final void toNode(org.w3c.dom.Document  doc,
            org.w3c.dom.Node  parent,
            int[] tokensMap,
            boolean tokensPos)
        throws org.w3c.dom.DOMException  {
        if (tokensMap[kind] == ArlUtil.F_REMOVE) {
            return;
        }
        if (tokensMap[kind] == ArlUtil.F_ACCEPT) {
            org.w3c.dom.Element  elt = doc.createElement("tok");

            elt.setAttribute("ki", String.valueOf(kind));
            if (tokensPos) {
                elt.setAttribute("bl", String.valueOf(beginLine));
                elt.setAttribute("bc", String.valueOf(beginColumn));
                elt.setAttribute("el", String.valueOf(endLine));
                elt.setAttribute("ec", String.valueOf(endColumn));
            }
            parent.appendChild(elt);
            parent = elt;
        }
        Token st = specialToken;

        if (st != null) {
            while (st.specialToken != null) {
                st = st.specialToken;
            }
            while (st != null) {
                st.toSpecialNode(doc, parent, tokensMap, tokensPos);
                st = st.next;
            }
        }
        parent.appendChild(doc.createCDATASection(image));
    }

    /**
     * Creates a child 'stok' DOM node allways appended to a 'tok' parent node, depending on the
     * 'tokensMap' parameter. The child node will have the following structure:
     * <p>
     * <table class="usage"><tr><td class="usage"><pre>
     *
     *  &lt;stok ki="10"&gt;&lt;![CDATA[&#047;** Javadoc comment *&#047;]]&gt;&lt;/stok&gt;
     *
     *  <i>or, if tokensPos is true,</i>
     *
     *  &lt;stok bc="13" bl="22" ec="16" el="22" ki="10"&gt;
     *    &lt;![CDATA[&#047;** Javadoc comment *&#047;]]&gt;
     *  &lt;/stok&gt;
     * </pre></td></tr></table>
     * <p>
     * meaning that the special token of kind 10 ({@link JavaParserConstants#FORMAL_COMMENT})
     * begins in the source file at the (22,13) line,column coordinates and ends at
     * the (22,16) coordinates and contains the String "&#047;** Javadoc comment *&#047;".
     * <p>
     * See also {@link org.ejen.util.arl.ArlUtil}.
     * <p>
     * @param doc the Document in which the nodes are to be created.
     * @param parent the DOM node to which the new Node must be appended.
     * @param tokensMap an <code>int</code> array specifying, for each Token
     *        kind, if this node must accepted (created), crossed (only the
     *        CDATA section is created without a parent &lt;tok...&gt; node creation)
     *        or removed (no node creation, no CDATA section).
     * @param tokensPos if true, this Token position coordinates will be includes
     *        as attributes.
     * @throws org.w3c.dom.DOMException DOM errors...
     */
    protected final void toSpecialNode(org.w3c.dom.Document  doc,
            org.w3c.dom.Node  parent,
            int[] tokensMap,
            boolean tokensPos)
        throws org.w3c.dom.DOMException  {
        if (tokensMap[kind] == ArlUtil.F_REMOVE) {
            return;
        }
        if (tokensMap[kind] == ArlUtil.F_ACCEPT) {
            org.w3c.dom.Element  elt = doc.createElement("stok");

            elt.setAttribute("ki", String.valueOf(kind));
            if (tokensPos) {
                elt.setAttribute("bl", String.valueOf(beginLine));
                elt.setAttribute("bc", String.valueOf(beginColumn));
                elt.setAttribute("el", String.valueOf(endLine));
                elt.setAttribute("ec", String.valueOf(endColumn));
            }
            parent.appendChild(elt);
            parent = elt;
        }
        parent.appendChild(doc.createCDATASection(image));
    }
    // --------------------------- New
}
