/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.util.arl;

import org.ejen.util.arl.ArlParser;
import org.ejen.util.arl.ArlParserTreeConstants;
import org.ejen.util.arl.Node;
import org.ejen.util.arl.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected ArlParser parser;
    protected Token first;
    protected Token last;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(ArlParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
        this.first = ArlParser.getToken(1);
    }

    @Override
    public void jjtClose() {
        this.last = ArlParser.getToken(0);
    }

    public Token getFirstToken() {
        return this.first;
    }

    public Token getLastToken() {
        return this.last;
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return ArlParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }
}

