/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext.parsers.java_1_2;

import org.ejen.ext.parsers.java_1_2.JavaParser;
import org.ejen.ext.parsers.java_1_2.JavaParserTreeConstants;
import org.ejen.ext.parsers.java_1_2.Node;
import org.ejen.ext.parsers.java_1_2.Token;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    protected Token first;
    protected Token last;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(JavaParser p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
        this.first = JavaParser.getToken(1);
    }

    @Override
    public void jjtClose() {
        this.last = JavaParser.getToken(0);
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public final void toNode(Document doc, org.w3c.dom.Node parent, int[] nodesMap, int[] tokensMap, boolean tokensPos) throws DOMException {
        if (nodesMap[this.id] == 1) {
            return;
        }
        if (nodesMap[this.id] == 0) {
            Element elt = doc.createElement(JavaParserTreeConstants.jjtNodeName[this.id]);
            elt.setAttribute("id", String.valueOf(this.id));
            parent.appendChild(elt);
            parent = elt;
        }
        Token t = new Token();
        t.next = this.first;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode cn = (SimpleNode)this.children[i];
                t = t.next;
                while (t != null && t != cn.first) {
                    t.toNode(doc, parent, tokensMap, tokensPos);
                    t = t.next;
                }
                cn.toNode(doc, parent, nodesMap, tokensMap, tokensPos);
                t = cn.last;
            }
        }
        while (t != null && t != this.last) {
            t = t.next;
            if (t == null) continue;
            t.toNode(doc, parent, tokensMap, tokensPos);
        }
    }
}

