/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext.parsers.java_1_2;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.NodeSet;
import org.ejen.ext.parsers.java_1_2.JavaParser;
import org.ejen.ext.parsers.java_1_2.JavaParserConstants;
import org.ejen.ext.parsers.java_1_2.JavaParserTreeConstants;
import org.ejen.ext.parsers.java_1_2.SimpleNode;
import org.ejen.util.XSLUtil;
import org.ejen.util.arl.ArlUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaSourceToXML
implements JavaParserTreeConstants,
JavaParserConstants {
    private static Hashtable _nodesMapCache = new Hashtable();
    private static Hashtable _tokensMapCache = new Hashtable();
    private static final int[] DEFAULT_NODES_MAP = new int[jjtNodeName.length];
    private static final int[] DEFAULT_TOKENS_MAP = new int[tokenImage.length];

    protected JavaSourceToXML() {
    }

    public static NodeSet process(ExpressionContext context, String fileName) {
        return JavaSourceToXML.process(XSLUtil.getContextDocument(context), XSLUtil.evaluate(context, fileName), null, null, false);
    }

    public static NodeSet process(ExpressionContext context, String fileName, boolean tokensPos) {
        return JavaSourceToXML.process(XSLUtil.getContextDocument(context), XSLUtil.evaluate(context, fileName), null, null, tokensPos);
    }

    public static NodeSet process(ExpressionContext context, String fileName, String nodesArl, String tokensArl) {
        return JavaSourceToXML.process(XSLUtil.getContextDocument(context), XSLUtil.evaluate(context, fileName), XSLUtil.evaluate(context, nodesArl), XSLUtil.evaluate(context, tokensArl), false);
    }

    public static NodeSet process(ExpressionContext context, String fileName, String nodesArl, String tokensArl, boolean tokensPos) {
        return JavaSourceToXML.process(XSLUtil.getContextDocument(context), XSLUtil.evaluate(context, fileName), XSLUtil.evaluate(context, nodesArl), XSLUtil.evaluate(context, tokensArl), tokensPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NodeSet process(Document doc, String fileName, String nodesArl, String tokensArl, boolean tokensPos) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fileName));
            if (JavaParser.token_source == null) {
                new JavaParser(br);
            } else {
                JavaParser.ReInit(br);
            }
            SimpleNode sn = JavaParser.CompilationUnit();
            Element root = doc.createElement("unused");
            sn.toNode(doc, root, JavaSourceToXML.getMap(nodesArl, DEFAULT_NODES_MAP, _nodesMapCache), JavaSourceToXML.getMap(tokensArl, DEFAULT_TOKENS_MAP, _tokensMapCache), tokensPos);
            NodeSet nodeSet = new NodeSet(root.getChildNodes());
            return nodeSet;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {
                }
                finally {
                    br = null;
                }
            }
        }
    }

    protected static int[] getMap(String arl, int[] defaultMap, Hashtable cache) {
        if (arl == null) {
            return defaultMap;
        }
        int[] map = (int[])cache.get(arl);
        if (map == null) {
            map = ArlUtil.process(arl, new int[defaultMap.length]);
            cache.put(arl, map);
        }
        return map;
    }

    public static NodeSet parseJavadoc(ExpressionContext context, String comment) {
        Document doc = XSLUtil.getContextDocument(context);
        try {
            NodeSet ns = new NodeSet();
            StringTokenizer sTok = new StringTokenizer(comment, "\n\r");
            while (sTok.hasMoreTokens()) {
                String line = sTok.nextToken();
                boolean skip = false;
                if (line.startsWith("/**")) {
                    line = line.substring(3);
                    skip = true;
                }
                if (line.endsWith("*/")) {
                    line = line.substring(0, line.length() - 2);
                }
                if (!skip) {
                    int iStar = -1;
                    boolean done = false;
                    block7: for (int i = 0; !done && i < line.length(); ++i) {
                        switch (line.charAt(i)) {
                            case '\t': 
                            case ' ': {
                                continue block7;
                            }
                            case '*': {
                                iStar = i;
                            }
                            default: {
                                done = true;
                            }
                        }
                    }
                    line = iStar != -1 ? line.substring(iStar + 1) : "";
                }
                if (line.length() <= 0) continue;
                Element elt = doc.createElement("doc-line");
                elt.appendChild(doc.createCDATASection(line));
                ns.addElement((Node)elt);
            }
            return ns;
        }
        catch (DOMException e) {
            throw new WrappedRuntimeException((Exception)e);
        }
    }

    static {
        JavaSourceToXML.DEFAULT_NODES_MAP[2] = 1;
        JavaSourceToXML.DEFAULT_NODES_MAP[3] = 2;
        JavaSourceToXML.DEFAULT_NODES_MAP[6] = 2;
        JavaSourceToXML.DEFAULT_NODES_MAP[8] = 2;
        JavaSourceToXML.DEFAULT_NODES_MAP[14] = 1;
        JavaSourceToXML.DEFAULT_NODES_MAP[21] = 2;
        JavaSourceToXML.DEFAULT_NODES_MAP[25] = 1;
        JavaSourceToXML.DEFAULT_NODES_MAP[64] = 1;
        for (int i = 0; i <= 9; ++i) {
            JavaSourceToXML.DEFAULT_TOKENS_MAP[i] = 1;
        }
        JavaSourceToXML.DEFAULT_TOKENS_MAP[11] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[44] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[75] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[76] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[77] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[78] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[81] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[82] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[56] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[35] = 1;
        JavaSourceToXML.DEFAULT_TOKENS_MAP[27] = 1;
        _nodesMapCache.put("default", DEFAULT_NODES_MAP);
        _tokensMapCache.put("default", DEFAULT_TOKENS_MAP);
    }
}

