/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.xalan.extensions.ExpressionContext;
import org.ejen.util.XSLUtil;

public class StringUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    protected StringUtil() {
    }

    public static String dateFormat(ExpressionContext context, String format) {
        return new SimpleDateFormat(XSLUtil.evaluate(context, format)).format(new Date());
    }

    public static boolean equals(ExpressionContext context, String s1, String s2) {
        return XSLUtil.evaluate(context, s1).equals(XSLUtil.evaluate(context, s2));
    }

    public static boolean equalsIgnoreCase(ExpressionContext context, String s1, String s2) {
        return XSLUtil.evaluate(context, s1).equalsIgnoreCase(XSLUtil.evaluate(context, s2));
    }

    public static String toLowerCase(ExpressionContext context, String s) {
        return XSLUtil.evaluate(context, s).toLowerCase();
    }

    public static String toUpperCase(ExpressionContext context, String s) {
        return XSLUtil.evaluate(context, s).toUpperCase();
    }

    public static String toULowerCase(ExpressionContext context, String s) {
        if ((s = XSLUtil.evaluate(context, s)).length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String indent(ExpressionContext context, int newLines, int tabs) {
        int i;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < newLines; ++i) {
            sb.append('\n');
        }
        for (i = 0; i < tabs; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    public static String replace(ExpressionContext context, String s1, String s2, String s3) {
        s2 = StringUtil.unescape(s2);
        s3 = StringUtil.unescape(s3);
        int iS2inS1 = s1.indexOf(s2);
        if (iS2inS1 == -1) {
            return s1;
        }
        StringBuffer sb = new StringBuffer(s1.substring(0, iS2inS1)).append(s3);
        int oldIS2inS1 = iS2inS1;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (true) {
            if ((iS2inS1 = s1.indexOf(s2, iS2inS1 + s2Length)) == -1) {
                if (oldIS2inS1 + s2Length >= s1Length) break;
                sb.append(s1.substring(oldIS2inS1 + s2Length));
                break;
            }
            sb.append(s1.substring(oldIS2inS1 + s2Length, iS2inS1)).append(s3);
            oldIS2inS1 = iS2inS1;
        }
        return sb.toString();
    }

    protected static String unescape(String s) {
        StringBuffer sb;
        block10: {
            int ibs = s.indexOf(92);
            if (ibs == -1) {
                return s;
            }
            sb = new StringBuffer();
            int lastChar = s.length() - 1;
            int from = 0;
            do {
                if (from < ibs) {
                    sb.append(s.substring(from, ibs));
                }
                if (ibs >= lastChar) break block10;
                char c = s.charAt(ibs + 1);
                switch (c) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            } while ((ibs = s.indexOf(92, from = ibs + 2)) != -1);
            if (from < s.length()) {
                sb.append(s.substring(from, s.length()));
            }
        }
        return sb.toString();
    }
}

