/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.WrappedRuntimeException;
import org.ejen.util.DOMUtil;
import org.ejen.util.XSLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaClassToXML {
    public static final String DIM_STR = "[]";

    protected JavaClassToXML() {
    }

    public static Node process(ExpressionContext context, String className) {
        Class<?> clazz;
        className = XSLUtil.evaluate(context, className);
        Document doc = XSLUtil.getContextDocument(context);
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException("Invalid class name", e);
        }
        return JavaClassToXML.process(doc, clazz);
    }

    protected static Node process(Document doc, Class c) {
        try {
            int i;
            Class<?>[] is;
            Element root = doc.createElement("class-definition");
            root.setAttribute("interface", c.isInterface() ? "true" : "false");
            String className = c.getName();
            int iLastDot = className.lastIndexOf(46);
            if (iLastDot != -1) {
                DOMUtil.createCDATANode(doc, root, "package", className.substring(0, iLastDot));
                className = className.substring(iLastDot + 1);
            }
            DOMUtil.createCDATANode(doc, root, "modifiers", Modifier.toString(c.getModifiers()));
            DOMUtil.createCDATANode(doc, root, "name", className);
            Class sc = c.getSuperclass();
            if (sc != null) {
                DOMUtil.createNode(doc, root, "extends").appendChild(JavaClassToXML.process(doc, sc));
            }
            if ((is = c.getInterfaces()).length > 0) {
                Node nis = DOMUtil.createNode(doc, root, "implements");
                for (i = 0; i < is.length; ++i) {
                    nis.appendChild(JavaClassToXML.process(doc, is[i]));
                }
            }
            Field[] fs = c.getDeclaredFields();
            for (i = 0; i < fs.length; ++i) {
                Field f = fs[i];
                int mods = f.getModifiers();
                Node nf = DOMUtil.createNode(doc, root, "field");
                DOMUtil.createCDATANode(doc, nf, "modifiers", Modifier.toString(mods));
                DOMUtil.createCDATANode(doc, nf, "type", f.getType().getName());
                DOMUtil.createCDATANode(doc, nf, "name", f.getName());
                if (!Modifier.isStatic(mods) || !Modifier.isPublic(mods)) continue;
                DOMUtil.createCDATANode(doc, nf, "init", f.get(null).toString());
            }
            Constructor<?>[] cos = c.getConstructors();
            for (int i2 = 0; i2 < cos.length; ++i2) {
                Constructor<?> co = cos[i2];
                Node nco = DOMUtil.createNode(doc, root, "constructor");
                DOMUtil.createCDATANode(doc, nco, "modifiers", Modifier.toString(co.getModifiers()));
                Class<?>[] ps = co.getParameterTypes();
                for (int j = 0; j < ps.length; ++j) {
                    DOMUtil.createCDATANode(doc, nco, "parameter", ps[j].getName());
                }
                Class<?>[] es = co.getExceptionTypes();
                for (int j = 0; j < es.length; ++j) {
                    DOMUtil.createCDATANode(doc, nco, "exception", es[j].getName());
                }
            }
            Method[] ms = c.getDeclaredMethods();
            for (int i3 = 0; i3 < ms.length; ++i3) {
                Method m = ms[i3];
                Node nm = DOMUtil.createNode(doc, root, "method");
                DOMUtil.createCDATANode(doc, nm, "modifiers", Modifier.toString(m.getModifiers()));
                DOMUtil.createCDATANode(doc, nm, "return-type", m.getReturnType().getName());
                DOMUtil.createCDATANode(doc, nm, "name", m.getName());
                Class<?>[] ps = m.getParameterTypes();
                for (int j = 0; j < ps.length; ++j) {
                    DOMUtil.createCDATANode(doc, nm, "parameter", ps[j].getName());
                }
                Class<?>[] es = m.getExceptionTypes();
                for (int j = 0; j < es.length; ++j) {
                    DOMUtil.createCDATANode(doc, nm, "exception", es[j].getName());
                }
            }
            Class<?>[] cs = c.getDeclaredClasses();
            for (int i4 = 0; i4 < cs.length; ++i4) {
                root.appendChild(JavaClassToXML.process(doc, cs[i4]));
            }
            return root;
        }
        catch (WrappedRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static String stripType(ExpressionContext context, String type) {
        int iLastDot = (type = JavaClassToXML.stripTypeDims(context, type)).lastIndexOf(46);
        return iLastDot != -1 ? type.substring(iLastDot + 1) : type;
    }

    public static String stripTypeDims(ExpressionContext context, String type) {
        int b;
        if (!(type = XSLUtil.evaluate(context, type)).startsWith("[")) {
            return type;
        }
        char c = type.charAt(1);
        switch (c) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
            case 'L': {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type signature: " + c);
            }
        }
        int e = type.length() - 1;
        for (b = 2; b < e && type.charAt(b) == c; ++b) {
        }
        return type.substring(b, e);
    }

    public static String dimsOfType(ExpressionContext context, String type) {
        if (!(type = XSLUtil.evaluate(context, type)).startsWith("[")) {
            return "";
        }
        StringBuffer dims = new StringBuffer(DIM_STR);
        char c = type.charAt(1);
        int l = type.length();
        for (int i = 2; i < l && type.charAt(i) == c; ++i) {
            dims.append(DIM_STR);
        }
        return dims.toString();
    }

    public static String packageOfType(ExpressionContext context, String type) {
        int iLastDot = (type = JavaClassToXML.stripTypeDims(context, type)).lastIndexOf(46);
        return iLastDot != -1 ? type.substring(0, iLastDot) : "";
    }
}

