/*
 * Decompiled with CFR 0.152.
 */
package org.ejen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.ejen.EjenChildNode;
import org.ejen.EjenContext;
import org.ejen.EjenException;
import org.ejen.EjenImportNode;
import org.ejen.EjenIncludeNode;
import org.ejen.EjenParamNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class EjenStylesheetNode
extends EjenChildNode {
    private String stylesheet = "";
    protected Vector _childNodes = new Vector();
    protected String _file = null;

    @Override
    public Properties getAttributes() {
        Properties attrs = super.getAttributes();
        if (this._file != null) {
            attrs.setProperty("file", this._file);
        }
        return attrs;
    }

    @Override
    public Vector getChildren() {
        Vector children = super.getChildren();
        children.addAll(this._childNodes);
        return children;
    }

    public void setFile(String file) {
        this.transformInputFile(file);
        this._file = file;
    }

    public EjenParamNode createParam() {
        EjenParamNode p = new EjenParamNode();
        this._childNodes.addElement(p);
        return p;
    }

    public EjenIncludeNode createInclude() {
        EjenIncludeNode i = new EjenIncludeNode();
        this._childNodes.addElement(i);
        return i;
    }

    public EjenImportNode createImport() {
        EjenImportNode i = new EjenImportNode();
        this._childNodes.addElement(i);
        return i;
    }

    @Override
    public void check() {
        super.check();
        if (this._file == null) {
            throw new EjenException(this, "no 'file' attribute");
        }
        Enumeration e = this._childNodes.elements();
        while (e.hasMoreElements()) {
            ((EjenChildNode)e.nextElement()).check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void beforeProcess() {
        super.beforeProcess();
        TransformerFactoryImpl tfi = null;
        try {
            tfi = (TransformerFactoryImpl)this.getFromGlobalContext("TRANSFORMER_FACTORY_IMPL");
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        if (tfi == null) {
            throw new EjenException(this, "no 'TRANSFORMER_FACTORY_IMPL' in global context");
        }
        FileInputStream inputs = null;
        try {
            inputs = new FileInputStream(this.evaluateAVT(this._file));
            TransformerImpl ti2333332 = (TransformerImpl)tfi.newTransformer((Source)new StreamSource(inputs));
            EjenContext newContext = this.cloneContext();
            newContext.put("TRANSFORMER_IMPL", ti2333332);
            newContext.put("STYLESHEET_ROOT", ti2333332.getStylesheet());
            this.pushContext(newContext);
            if (inputs == null) return;
        }
        catch (EjenException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new EjenException(this, null, e2);
                }
            }
            catch (Throwable throwable) {
                if (inputs == null) throw throwable;
                try {
                    try {
                        ((InputStream)inputs).close();
                        inputs = null;
                        throw throwable;
                    }
                    catch (Exception exception) {
                        inputs = null;
                        throw throwable;
                    }
                }
                catch (Throwable throwable2) {
                    inputs = null;
                    throw throwable2;
                }
            }
        }
        try {
            ((InputStream)inputs).close();
            return;
        }
        catch (Exception ti2333332) {
            return;
        }
        finally {
            inputs = null;
        }
    }

    @Override
    public void process() {
        super.process();
        try {
            StylesheetRoot sr = (StylesheetRoot)this.getFromContext("STYLESHEET_ROOT");
            if (sr == null) {
                throw new EjenException(this, "no 'STYLESHEET_ROOT' in context");
            }
            Enumeration is = this._childNodes.elements();
            while (is.hasMoreElements()) {
                EjenChildNode ecn = (EjenChildNode)is.nextElement();
                String oldMessageIndent = _messageIndent;
                _messageIndent = "  " + _messageIndent;
                ecn.beforeProcess();
                ecn.process();
                ecn.afterProcess();
                ecn.idle();
                _messageIndent = oldMessageIndent;
            }
            sr.recompose();
        }
        catch (EjenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
    }

    @Override
    public void afterProcess() {
        super.afterProcess();
        try {
            this.popContext();
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
    }

    private boolean transformInputFile(String file) {
        boolean retVal = true;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            File datafile = new File(file);
            File output = new File(file);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document inputDocument = builder.parse(datafile);
            Document document = builder.parse(datafile);
            boolean hasImports = true;
            NodeList list = document.getElementsByTagName("xsl:import");
            String importHrefValue = "";
            if (list.item(0) != null) {
                importHrefValue = ((Element)list.item(0)).getAttribute("href");
            } else {
                hasImports = false;
            }
            boolean hasIncludes = true;
            list = document.getElementsByTagName("xsl:include");
            String includeHrefValue = "";
            if (list.item(0) != null) {
                includeHrefValue = ((Element)list.item(0)).getAttribute("href");
            } else {
                hasIncludes = false;
            }
            String hrefValue = "";
            if (hasImports) {
                hrefValue = importHrefValue;
            } else if (hasIncludes) {
                hrefValue = includeHrefValue;
            }
            if ((hasImports || hasIncludes) && !this.checkFilePath(file, hrefValue)) {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                StreamSource stylesource = new StreamSource(new StringReader(this.stylesheet));
                Transformer transformer = tFactory.newTransformer(stylesource);
                DOMSource source = new DOMSource(inputDocument);
                StreamResult result = new StreamResult(new FileOutputStream(output));
                transformer.transform(source, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("exception in EjenStylesheetNode.transformInputFile() : " + e.getMessage());
            retVal = false;
        }
        return retVal;
    }

    private boolean checkFilePath(String file, String hrefValue) {
        boolean retVal = false;
        String relPath = file;
        String hrefPath = "";
        int indexOfBackslash = file.lastIndexOf("/");
        relPath = relPath.substring(0, indexOfBackslash + 1);
        indexOfBackslash = hrefValue.lastIndexOf("/");
        if (indexOfBackslash != -1) {
            hrefPath = hrefValue.substring(0, indexOfBackslash + 1);
        }
        if (this.comparePaths(relPath, hrefPath)) {
            retVal = true;
        } else {
            int startPosition = 0;
            startPosition = indexOfBackslash == -1 ? 1 : hrefPath.length() + 1;
            this.composeStylesheet(relPath, startPosition);
        }
        return retVal;
    }

    private boolean comparePaths(String relPath, String hrefPath) {
        boolean retVal = false;
        retVal = System.getProperty("path.separator").equals(";") ? relPath.equalsIgnoreCase(hrefPath) : relPath.equals(hrefPath);
        return retVal;
    }

    private void composeStylesheet(String relPath, int startPosition) {
        String stylesheet;
        this.stylesheet = stylesheet = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:gvs=\"org.ejen.ext.GlobalVariables\"><xsl:output method=\"xml\" indent=\"yes\" encoding=\"UTF-8\"/><xsl:template match=\"/\"><xsl:element name=\"xsl:stylesheet\"><xsl:attribute name=\"version\">1.0</xsl:attribute><xsl:attribute name=\"extension-element-prefixes\">gvs</xsl:attribute><xsl:attribute name=\"exclude-result-prefixes\">gvs</xsl:attribute><xsl:apply-templates/></xsl:element></xsl:template><xsl:template match=\"stylesheet/*\"><xsl:choose><xsl:when test=\"name() = 'xsl:import'\"><xsl:call-template name=\"import\"/></xsl:when><xsl:when test=\"name() = 'xsl:include'\"><xsl:call-template name=\"include\"/></xsl:when><xsl:otherwise><xsl:copy-of select=\".\"/></xsl:otherwise></xsl:choose></xsl:template><xsl:template name=\"import\"><xsl:element name=\"xsl:import\"><xsl:attribute name=\"href\">" + relPath + "<xsl:value-of select=\"substring(@href," + startPosition + ")\"/></xsl:attribute></xsl:element></xsl:template><xsl:template name=\"include\"><xsl:element name=\"xsl:include\"><xsl:attribute name=\"href\">" + relPath + "<xsl:value-of select=\"substring(@href," + startPosition + ")\"/></xsl:attribute></xsl:element></xsl:template></xsl:stylesheet>";
    }
}

