/*
 * Decompiled with CFR 0.152.
 */
package org.ejen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.ejen.EjenChildNode;
import org.ejen.EjenException;

public class EjenSaveNode
extends EjenChildNode {
    protected String _file = null;
    protected String _encoding = "iso-8859-1";
    protected String _indent = "yes";
    protected String _amount = "2";

    @Override
    public String nodeName() {
        return "save";
    }

    @Override
    public Properties getAttributes() {
        Properties attrs = super.getAttributes();
        if (this._file != null) {
            attrs.setProperty("file", this._file);
        }
        if (this._encoding != null) {
            attrs.setProperty("encoding", this._encoding);
        }
        if (this._indent != null) {
            attrs.setProperty("indent", this._indent);
        }
        if (this._amount != null) {
            attrs.setProperty("amount", this._amount);
        }
        return attrs;
    }

    public void setFile(String file) {
        this._file = file;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public void setIndent(String indent) {
        this._indent = indent;
    }

    public void setAmount(String amount) {
        this._amount = amount;
    }

    @Override
    public void check() {
        super.check();
        if (this._file == null) {
            throw new EjenException(this, "No 'file' attribute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        super.process();
        TransformerFactoryImpl tfi = null;
        DOMSource src = null;
        try {
            tfi = (TransformerFactoryImpl)this.getFromGlobalContext("TRANSFORMER_FACTORY_IMPL");
            src = (DOMSource)this.getFromGlobalContext("DOM_SOURCE");
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        if (tfi == null) {
            throw new EjenException(this, "no 'TRANSFORMER_FACTORY_IMPL' in global context");
        }
        if (src == null) {
            throw new EjenException(this, "no 'DOM_SOURCE' in global context");
        }
        OutputStream outputs = null;
        try {
            File f = new File(this.evaluateAVT(this._file));
            File pf = f.getParentFile();
            if (pf != null) {
                pf.mkdirs();
            }
            outputs = new FileOutputStream(f.getPath());
            Transformer serializer = tfi.newTransformer();
            serializer.setOutputProperty("indent", this.evaluateAVT(this._indent));
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("encoding", this.evaluateAVT(this._encoding));
            serializer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", this.evaluateAVT(this._amount));
            serializer.transform(src, new StreamResult(outputs));
        }
        catch (Exception e) {
            throw new EjenException(this, this._file, e);
        }
        finally {
            if (outputs != null) {
                try {
                    outputs.close();
                }
                catch (Exception exception) {
                }
                finally {
                    outputs = null;
                }
            }
        }
    }
}

