/*
 * Decompiled with CFR 0.152.
 */
package org.ejen;

import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.dom.DOMSource;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.ejen.EjenConstants;
import org.ejen.EjenContext;
import org.ejen.EjenContextsStack;
import org.ejen.EjenEvent;
import org.ejen.EjenException;
import org.ejen.EjenListener;
import org.ejen.util.XSLUtil;

public abstract class EjenChildNode
implements EjenConstants {
    private static final EjenContextsStack _ejenContextsStack = new EjenContextsStack();
    private static EjenListener _ejenListener = null;
    protected static String _messageIndent = "";
    private int _state = 0;

    public abstract String nodeName();

    public Properties getAttributes() {
        return new Properties();
    }

    public Vector getChildren() {
        return new Vector();
    }

    public void check() {
        this._state = 4;
        this.sendStateEvent();
    }

    public void beforeProcess() {
        this._state = 1;
        this.sendStateEvent();
    }

    public void process() {
        this._state = 2;
        this.sendStateEvent();
    }

    public void afterProcess() {
        this._state = 3;
        this.sendStateEvent();
    }

    public final void idle() {
        this._state = 0;
        this.sendStateEvent();
    }

    public final int getState() {
        return this._state;
    }

    public static final void setListener(EjenListener ejenListener) {
        _ejenListener = ejenListener;
    }

    public static final EjenListener getListener() {
        return _ejenListener;
    }

    public final void sendStateEvent() {
        if (_ejenListener != null) {
            _ejenListener.stateChanged(new EjenEvent(this, STATES[this._state], 3));
        }
    }

    public final void sendMessageEvent(String msg) {
        this.sendMessageEvent(msg, 2);
    }

    public final void sendMessageEvent(String msg, int level) {
        if (_ejenListener != null) {
            _ejenListener.nodeMessageSent(new EjenEvent(this, _messageIndent + msg, level));
        }
    }

    public static final void sendXSLMessageEvent(String msg) {
        EjenChildNode.sendXSLMessageEvent(msg, 2);
    }

    public static final void sendXSLMessageEvent(String msg, int level) {
        if (_ejenListener != null) {
            _ejenListener.xslMessageSent(new EjenEvent("(xsl)", _messageIndent + "[xsl] " + msg, level));
        }
    }

    public final String toString() {
        return this.nodeName() + " " + this.getAttributes();
    }

    protected final Object getFromContext(String name) {
        return _ejenContextsStack.peekContext().get(name);
    }

    protected final Object getFromContext(String name, int offset) {
        return _ejenContextsStack.peekContext(_ejenContextsStack.size() + offset - 1).get(name);
    }

    protected final Object getFromGlobalContext(String name) {
        return _ejenContextsStack.globalGet(name);
    }

    protected final Object putInContext(String name, Object value) {
        return _ejenContextsStack.peekContext().put(name, value);
    }

    protected final Object putInGlobalContext(String name, Object value) {
        return _ejenContextsStack.globalPut(name, value);
    }

    protected final EjenContext popContext() {
        return _ejenContextsStack.popContext();
    }

    protected final EjenContext pushContext(EjenContext ejenContext) {
        return _ejenContextsStack.pushContext(ejenContext);
    }

    protected final EjenContext cloneContext() {
        if (!_ejenContextsStack.isEmpty()) {
            return new EjenContext(_ejenContextsStack.peekContext());
        }
        return new EjenContext();
    }

    protected final String evaluateAVT(String avt) {
        TransformerImpl ti = null;
        try {
            ti = (TransformerImpl)this.getFromGlobalContext("TRANSFORMER_IMPL");
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        if (ti == null) {
            throw new EjenException(this, "no 'TRANSFORMER_IMPL' in global context");
        }
        return this.evaluateAVT(ti, avt);
    }

    protected final String evaluateAVT(TransformerImpl ti, String avt) {
        StylesheetHandler sh = null;
        DOMSource src = null;
        try {
            src = (DOMSource)this.getFromGlobalContext("DOM_SOURCE");
            sh = (StylesheetHandler)this.getFromGlobalContext("STYLESHEET_HANDLER");
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        if (sh == null) {
            throw new EjenException(this, "no 'STYLESHEET_HANDLER' in global context");
        }
        if (src == null) {
            throw new EjenException(this, "no 'DOM_SOURCE' in global context");
        }
        try {
            String s = XSLUtil.evaluateAttribute(sh, ti.getXPathContext(), src.getNode(), avt);
            if (!s.equals(avt)) {
                this.sendMessageEvent("Resolved '" + avt + "' into '" + s + "'");
            }
            return s;
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
    }
}

