
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen;

/**
 * Ejen constants interface.
 * @author F. Wolff
 * @version 1.0
 */
public interface EjenConstants {

    /** Context key */
    public static final String  CTX_STYLESHEET_HANDLER = "STYLESHEET_HANDLER";

    /** Context key */
    public static final String  CTX_DOM_SOURCE = "DOM_SOURCE";

    /** Context key */
    public static final String  CTX_DOM_SOURCE_FILE = "DOM_SOURCE_FILE";

    /** Context key */
    public static final String  CTX_TRANSFORMER_IMPL = "TRANSFORMER_IMPL";

    /** Context key */
    public static final String  CTX_STYLESHEET_ROOT = "STYLESHEET_ROOT";

    /** Context key */
    public static final String  CTX_TRANSFORMER_FACTORY_IMPL = "TRANSFORMER_FACTORY_IMPL";

    /** State (of an EjenChildNode) names */
    public static final String [] STATES = {
        "idle", "before process", "processing", "after process", "checking"
    };

    /** State of an EjenChildNode */
    public static final int STATE_IDLE = 0;

    /** State of an EjenChildNode */
    public static final int STATE_BEFORE_PROCESS = 1;

    /** State of an EjenChildNode */
    public static final int STATE_PROCESS = 2;

    /** State of an EjenChildNode */
    public static final int STATE_AFTER_PROCESS = 3;

    /** State of an EjenChildNode */
    public static final int STATE_CHECK = 4;

    /** Message level */
    public static final int MSG_ERR = 0;

    /** Message level */
    public static final int MSG_WARN = 1;

    /** Message level */
    public static final int MSG_INFO = 2;

    /** Message level */
    public static final int MSG_VERBOSE = 3;

    /** Message level */
    public static final int MSG_DEBUG = 4;

    /** Message indentation string */
    public static final String  LOG_INDENT_STR1 = "  ";

    /** Message indentation string */
    public static final String  LOG_INDENT_STR2 = "  ";

    /**
     * <pre><code>
     *&lt;?xml version="1.0" encoding="iso-8859-1"?&gt;
     *&lt;ejen/&gt;
     * </code></pre>
     */
    public static final String  DEFAULT_XML_DATA
            = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>" + "<ejen/>";

    /** Default encoding: "ISO-8859-1" */
    public static final String  DEFAULT_XML_DATA_ENCODING = "ISO-8859-1";

    /**
     * <pre><code>
     *&lt;?xml version="1.0" encoding="iso-8859-1"?&gt;
     *&lt;xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"/&gt;
     * </code></pre>
     */
    public static final String  DEFAULT_XSL_DATA
            = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>"
            + "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\""
            + " xmlns:fiu=\"org.ejen.ext.FileUtil\""
            + " xmlns:stu=\"org.ejen.ext.StringUtil\""
            + " xmlns:ver=\"org.ejen.ext.Version\""
            + " exclude-result-prefixes=\"fiu stu ver\"" + " version=\"1.0\"/>";
}
