/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.utils.WrappedRuntimeException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DOMUtil {
    public static final String S_PY_PROPERTY_NODE_NAME = "property";
    public static final String S_PY_NAME = "name";
    public static final String S_PY_VALUE = "value";

    public static String getAttribute(Node n, String name) {
        Node attr;
        NamedNodeMap nnm;
        if (n != null && name != null && (nnm = n.getAttributes()) != null && (attr = nnm.getNamedItem(name)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static String getProperty(Node n, String name) {
        String[] prop;
        if (n != null && name != null && (prop = DOMUtil.getProperty(n)) != null && name.equals(prop[0])) {
            return prop[1];
        }
        return null;
    }

    public static String[] getProperty(Node n) {
        NamedNodeMap nnm;
        if (n != null && S_PY_PROPERTY_NODE_NAME.equals(n.getNodeName()) && (nnm = n.getAttributes()) != null) {
            Node name = nnm.getNamedItem(S_PY_NAME);
            Node value = nnm.getNamedItem(S_PY_VALUE);
            if (name != null && value != null) {
                return new String[]{name.getNodeValue(), value.getNodeValue()};
            }
        }
        return null;
    }

    public static Properties getChildProperties(Node n) {
        return DOMUtil.getChildProperties(n, new Properties());
    }

    public static Properties getChildProperties(Node parent, Properties props) {
        if (props != null) {
            for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
                String[] prop = DOMUtil.getProperty(n);
                if (prop == null) continue;
                props.setProperty(prop[0], prop[1]);
            }
        }
        return props;
    }

    public static Document newDocument() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXMLFile(String name) {
        FileInputStream inputs = null;
        try {
            inputs = new FileInputStream(name);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document document = dbf.newDocumentBuilder().parse(new InputSource(inputs));
            return document;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (inputs != null) {
                try {
                    ((InputStream)inputs).close();
                }
                catch (Exception exception) {
                }
                finally {
                    inputs = null;
                }
            }
        }
    }

    public static Document parseXMLString(String xmlString) {
        ByteArrayInputStream inputs = null;
        try {
            inputs = xmlString == null ? new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><ejen/>".getBytes("ISO-8859-1")) : new ByteArrayInputStream(xmlString.getBytes("ISO-8859-1"));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            return dbf.newDocumentBuilder().parse(new InputSource(inputs));
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static Node createNode(Document doc, Node parent, String nodeName) {
        try {
            Element elt = doc.createElement(nodeName);
            parent.appendChild(elt);
            return elt;
        }
        catch (DOMException e) {
            throw new WrappedRuntimeException((Exception)e);
        }
    }

    public static Node createCDATANode(Document doc, Node parent, String nodeName, String nodeValue) {
        try {
            Element elt = doc.createElement(nodeName);
            elt.appendChild(doc.createCDATASection(nodeValue));
            parent.appendChild(elt);
            return elt;
        }
        catch (DOMException e) {
            throw new WrappedRuntimeException((Exception)e);
        }
    }

    public static Node createCDATANode(Document doc, String nodeName, String nodeValue) {
        try {
            Element elt = doc.createElement(nodeName);
            elt.appendChild(doc.createCDATASection(nodeValue));
            return elt;
        }
        catch (DOMException e) {
            throw new WrappedRuntimeException((Exception)e);
        }
    }

    public static Node createTextNode(Document doc, String nodeName, String nodeValue) {
        try {
            Element elt = doc.createElement(nodeName);
            elt.appendChild(doc.createTextNode(nodeValue));
            return elt;
        }
        catch (DOMException e) {
            throw new WrappedRuntimeException((Exception)e);
        }
    }
}

