/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.ejen.ext.db.TableMetaDataNodeBuilder;
import org.ejen.util.DOMUtil;
import org.ejen.util.XSLUtil;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class BasicMetaDataConnection
extends TableMetaDataNodeBuilder {
    public static final String S_CI_CONNECTION_NODE_NAME = "connection";
    public static final String S_CI_DRIVER = "driver";
    public static final String S_CI_URL = "url";
    protected static Hashtable _conns = new Hashtable();

    protected BasicMetaDataConnection() {
    }

    public static void open(XSLProcessorContext context, ElemExtensionCall elem) {
        String name = XSLUtil.getAttribute(context, elem, "name", true);
        String select = XSLUtil.getAttribute(context, elem, "select", true);
        XObject xo = XSLUtil.evaluate(context, elem, select);
        if (xo == null || !(xo instanceof XNodeSet)) {
            throw new RuntimeException("illegal 'select' attribute in 'connection' node");
        }
        NodeIterator ni = null;
        try {
            ni = xo.nodeset();
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        BasicMetaDataConnection.open(null, name, ni);
    }

    public static boolean open(ExpressionContext context, String name, NodeIterator connectionNi) {
        if (!BasicMetaDataConnection.close(null, name = XSLUtil.evaluate(context, name))) {
            return false;
        }
        try {
            boolean badNode = false;
            Properties props = null;
            String driver = null;
            String url = null;
            Node elt = connectionNi.nextNode();
            if (elt == null || !S_CI_CONNECTION_NODE_NAME.equals(elt.getNodeName())) {
                badNode = true;
            } else {
                driver = DOMUtil.getAttribute(elt, S_CI_DRIVER);
                url = DOMUtil.getAttribute(elt, S_CI_URL);
                if (driver == null || url == null) {
                    badNode = true;
                } else {
                    props = DOMUtil.getChildProperties(elt);
                }
            }
            if (badNode) {
                throw new RuntimeException("Illegal jdbc 'connection' node");
            }
            Class.forName(driver);
            _activeConn = DriverManager.getConnection(url, props);
            _conns.put(name, _activeConn);
        }
        catch (Exception e) {
            BasicMetaDataConnection.appendErrorNode(e);
        }
        return _errors == null;
    }

    public static void close(XSLProcessorContext context, ElemExtensionCall elem) {
        BasicMetaDataConnection.close(null, XSLUtil.getAttribute(context, elem, "name", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean close(ExpressionContext context, String name) {
        if (context != null) {
            name = XSLUtil.evaluate(context, name);
        }
        _errors = null;
        if (context != null) {
            Connection conn = (Connection)_conns.get(name);
            if (conn != null) {
                if (_activeConn == conn) {
                    _activeConn = null;
                }
                try {
                    conn.close();
                }
                catch (Exception e) {
                    BasicMetaDataConnection.appendErrorNode(e);
                }
                finally {
                    _conns.remove(name);
                }
            } else {
                throw new RuntimeException("No jdbc connection with this name: " + name);
            }
        }
        return _errors == null;
    }

    public static void setActive(XSLProcessorContext context, ElemExtensionCall elem) {
        String name = XSLUtil.getAttribute(context, elem, "name", true);
        Connection conn = (Connection)_conns.get(name);
        if (conn == null) {
            throw new RuntimeException("No jdbc connection with this name: " + name);
        }
        _activeConn = conn;
    }

    public static void closeAll(XSLProcessorContext context, ElemExtensionCall elem) {
        BasicMetaDataConnection.closeAll(null);
    }

    public static boolean closeAll(ExpressionContext context) {
        _errors = null;
        Enumeration e = _conns.elements();
        while (e.hasMoreElements()) {
            Connection conn = (Connection)e.nextElement();
            try {
                conn.close();
            }
            catch (Exception f) {
                BasicMetaDataConnection.appendErrorNode(f);
            }
        }
        _conns.clear();
        return _errors == null;
    }
}

