/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Enumeration;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.NodeSet;
import org.ejen.util.DOMUtil;
import org.ejen.util.XSLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Properties {
    protected Properties() {
    }

    public static NodeSet getSystemProperties(ExpressionContext context) {
        Document doc = XSLUtil.getContextDocument(context);
        try {
            java.util.Properties props = System.getProperties();
            NodeSet ns = new NodeSet();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Element parent = doc.createElement("property");
                DOMUtil.createCDATANode(doc, parent, "name", name);
                DOMUtil.createCDATANode(doc, parent, "value", props.getProperty(name, ""));
                ns.addElement((Node)parent);
            }
            return ns;
        }
        catch (WrappedRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeSet load(ExpressionContext context, String fileName) {
        fileName = XSLUtil.evaluate(context, fileName);
        Document doc = XSLUtil.getContextDocument(context);
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(fileName));
            java.util.Properties props = new java.util.Properties();
            props.load(bis);
            NodeSet ns = new NodeSet();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Element parent = doc.createElement("property");
                DOMUtil.createCDATANode(doc, parent, "name", name);
                DOMUtil.createCDATANode(doc, parent, "value", props.getProperty(name, ""));
                ns.addElement((Node)parent);
            }
            NodeSet nodeSet = ns;
            return nodeSet;
        }
        catch (WrappedRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {
                }
                finally {
                    bis = null;
                }
            }
        }
    }
}

