/*
 * Decompiled with CFR 0.152.
 */
package org.ejen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.XPathAPI;
import org.ejen.EjenException;
import org.ejen.EjenStylesheetNode;
import org.ejen.util.XSLUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjenTemplateNode
extends EjenStylesheetNode {
    protected String _foreach = null;
    protected String _filepattern = null;
    protected String _outdated = null;

    @Override
    public String nodeName() {
        return "template";
    }

    @Override
    public Properties getAttributes() {
        Properties attrs = super.getAttributes();
        if (this._foreach != null) {
            attrs.setProperty("foreach", this._foreach);
        }
        if (this._filepattern != null) {
            attrs.setProperty("filepattern", this._filepattern);
        }
        if (this._outdated != null) {
            attrs.setProperty("outdated", this._outdated);
        }
        return attrs;
    }

    public void setForeach(String foreach) {
        this._foreach = foreach;
    }

    public void setFilepattern(String filepattern) {
        this._filepattern = filepattern;
    }

    public void setOutdated(String outdate) {
        this._outdated = outdate;
    }

    @Override
    public void process() {
        super.process();
        TransformerImpl ti = null;
        DOMSource src = null;
        try {
            ti = (TransformerImpl)this.getFromContext("TRANSFORMER_IMPL");
            src = (DOMSource)this.getFromGlobalContext("DOM_SOURCE");
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        if (ti == null) {
            throw new EjenException(this, "no 'TRANSFORMER_IMPL' in context");
        }
        if (src == null) {
            throw new EjenException(this, "no 'DOM_SOURCE' in global context");
        }
        if (this._foreach != null) {
            NodeList nl = null;
            try {
                ti.setParameter("root", (Object)src.getNode());
                nl = XPathAPI.selectNodeList((Node)src.getNode(), (String)this.evaluateAVT(ti, this._foreach));
            }
            catch (Exception e) {
                throw new EjenException(this, "invalid 'foreach' attribute: " + this._foreach, e);
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                DOMSource nodeSrc = null;
                try {
                    nodeSrc = new DOMSource(nl.item(i));
                }
                catch (Exception e) {
                    throw new EjenException(this, "invalid 'foreach' attribute: " + this._foreach, e);
                }
                this.processTemplateStreamResult(ti, nodeSrc);
            }
        } else {
            this.processTemplateStreamResult(ti, src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTemplateStreamResult(TransformerImpl ti, DOMSource src) {
        StylesheetHandler sh = null;
        try {
            sh = (StylesheetHandler)this.getFromGlobalContext("STYLESHEET_HANDLER");
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        if (sh == null) {
            throw new EjenException(this, "no 'STYLESHEET_HANDLER' in context");
        }
        OutputStream outputs = null;
        try {
            StreamResult sres = null;
            if (this._filepattern != null) {
                File f;
                String fileName = XSLUtil.evaluateAttribute(sh, ti.getXPathContext(), src.getNode(), this._filepattern);
                boolean flag = false;
                if (this._outdated != null && this._outdated.equals("true")) {
                    flag = true;
                }
                if (!flag || this.outdated(fileName)) {
                    this.sendMessageEvent("Creating '" + fileName + "'");
                    f = new File(fileName);
                    File pf = f.getParentFile();
                    if (pf != null) {
                        pf.mkdirs();
                    }
                } else {
                    return;
                }
                outputs = new FileOutputStream(f.getPath());
                sres = new StreamResult(outputs);
            } else {
                sres = new StreamResult(new StringWriter());
            }
            ti.transform((Source)src, (Result)sres);
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        finally {
            if (outputs != null) {
                try {
                    outputs.close();
                }
                catch (Exception exception) {
                }
                finally {
                    outputs = null;
                }
            }
        }
    }

    protected boolean outdated(String fileName) {
        File srcFile = new File((String)this.getFromGlobalContext("DOM_SOURCE_FILE"));
        File genFile = new File(fileName);
        if (!genFile.exists() || !srcFile.exists()) {
            return true;
        }
        long slm = srcFile.lastModified();
        if (slm == 0L) {
            return true;
        }
        long glm = genFile.lastModified();
        if (glm == 0L) {
            return true;
        }
        return slm >= glm;
    }
}

