/*
 * Decompiled with CFR 0.152.
 */
package org.ejen;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.WrappedRuntimeException;
import org.ejen.EjenException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EjenErrors {
    public static final String EJEN_INFORMATION = "Ejen information";
    public static final String STACK_TRACE = "stack-trace";
    public static final String ID_FILE = "file";
    public static final String ID_NOTE = "note";
    public static final String ID_MESSAGE = "message";
    public static final String ID_PUBLIC_ID = "public-id";
    public static final String ID_SYSTEM_ID = "system-id";
    public static final String ID_LINE = "line";
    public static final String ID_COLUMN = "column";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    private EjenErrors() {
    }

    public static EjenError[] get(String file, String note, Throwable t) {
        return EjenErrors.get(file, note, t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjenError[] get(String file, String note, Throwable t, boolean printStackTrace) {
        Vector<EjenError> errors = new Vector<EjenError>();
        Throwable lastNonNullThrowable = null;
        if (file != null || note != null) {
            EjenError ee = new EjenError(EJEN_INFORMATION);
            if (file != null) {
                ee.putMessage(ID_FILE, file);
            }
            if (note != null) {
                ee.putMessage(ID_NOTE, note);
            }
            errors.add(ee);
        }
        while (t != null) {
            lastNonNullThrowable = t;
            EjenError ee = new EjenError(t.getClass().getName());
            if (t.getMessage() != null) {
                ee.putMessage(ID_MESSAGE, t.getMessage());
            }
            int column = -1;
            int line = -1;
            String systemId = null;
            String publicId = null;
            if (t instanceof EjenException) {
                t = ((EjenException)t).getEmbeddedThrowable();
            } else if (t instanceof WrappedRuntimeException) {
                t = ((WrappedRuntimeException)t).getException();
            } else if (t instanceof SAXException) {
                SAXException se = (SAXException)t;
                if (se instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)se;
                    column = spe.getColumnNumber();
                    line = spe.getLineNumber();
                    publicId = spe.getPublicId();
                    systemId = spe.getSystemId();
                }
                t = se.getException();
            } else if (t instanceof TransformerException) {
                TransformerException te = (TransformerException)t;
                SourceLocator sl = te.getLocator();
                if (sl != null) {
                    column = sl.getColumnNumber();
                    line = sl.getLineNumber();
                    publicId = sl.getPublicId();
                    systemId = sl.getSystemId();
                }
                t = ((TransformerException)t).getCause();
            } else {
                t = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : null;
            }
            if (publicId != null) {
                ee.putMessage(ID_PUBLIC_ID, publicId);
            }
            if (systemId != null) {
                ee.putMessage(ID_SYSTEM_ID, systemId);
            }
            if (line != -1) {
                ee.putMessage(ID_LINE, Integer.toString(line));
            }
            if (column != -1) {
                ee.putMessage(ID_COLUMN, Integer.toString(column));
            }
            errors.add(ee);
        }
        if (printStackTrace && lastNonNullThrowable != null) {
            PrintWriter pw = null;
            EjenError ee = new EjenError(lastNonNullThrowable.getClass().getName());
            try {
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                lastNonNullThrowable.printStackTrace(pw);
                ee.putMessage(STACK_TRACE, sw.toString());
            }
            catch (Exception e) {
                ee.putMessage(STACK_TRACE, "(failed)");
            }
            finally {
                errors.add(ee);
                pw.close();
            }
        }
        return errors.toArray(new EjenError[0]);
    }

    public static String toString(EjenError[] errors) {
        if (errors == null) {
            return "errors.null";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < errors.length; ++i) {
            if (i > 0) {
                sb.append(LINE_SEPARATOR);
            }
            sb.append('[').append(errors[i].getName()).append("] {").append(LINE_SEPARATOR);
            Properties msgs = errors[i].getMessages();
            Enumeration<?> e = msgs.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                sb.append("  ").append(name).append(": ").append(msgs.getProperty(name)).append(LINE_SEPARATOR);
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public static String toString(String file, String note, Throwable t) {
        return EjenErrors.toString(EjenErrors.get(file, note, t, false));
    }

    public static String toString(String file, String note, Throwable t, boolean printStackTrace) {
        return EjenErrors.toString(EjenErrors.get(file, note, t, printStackTrace));
    }

    public static class EjenError {
        private String _name;
        private Properties _messages;

        public EjenError(String name) {
            this._name = name;
            this._messages = new Properties();
        }

        public String getName() {
            return this._name;
        }

        public Properties getMessages() {
            return this._messages;
        }

        public void putMessage(String id, String message) {
            this._messages.setProperty(id, message);
        }
    }
}

