/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.ejen.ext.Version;

public class Install {
    private static final String ejenVersion = "Ejen-" + Version.toString(null);

    public Install() {
        MainFrame frame = new MainFrame();
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Install();
    }

    public class MainFrame
    extends JFrame {
        JPanel contentPanel;
        JTextField jdkTextField;
        String javaRuntimeName;
        String javaVersion;
        String osName;
        String osVersion;
        String osArch;
        String javaHome;
        String strippedJavaHome;
        String fileSeparator;

        public MainFrame() {
            this.enableEvents(64L);
            try {
                this.getSystemProperties();
                this.jInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jInit() throws Exception {
            this.setTitle(ejenVersion + " Installation");
            this.contentPanel = (JPanel)this.getContentPane();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JTextArea welcome = new JTextArea(this.javaRuntimeName + ", version " + this.javaVersion + ",\n" + this.osName + " " + this.osVersion + " (" + this.osArch + ").\n\nBased on the file separator (" + this.fileSeparator + "), this is a " + (this.fileSeparator.equals("/") ? "Unix" : "Windows") + " system.\nYour JDK installation directory is:");
            welcome.setEditable(false);
            welcome.setBackground(this.contentPanel.getBackground());
            welcome.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String actionCommand = e.getActionCommand();
                    if (actionCommand.equals("fileChooserButton")) {
                        JFileChooser chooser = new JFileChooser();
                        chooser.setFileSelectionMode(1);
                        chooser.setDialogTitle("Choose your JDK installation directory");
                        if (chooser.showOpenDialog(MainFrame.this.contentPanel) == 0) {
                            MainFrame.this.jdkTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                        }
                    } else if (actionCommand.equals("okButton")) {
                        MainFrame.this.install();
                    } else if (actionCommand.equals("cancelButton")) {
                        System.exit(0);
                    }
                }
            };
            JPanel jdkPanel = new JPanel(new BorderLayout());
            this.jdkTextField = new JTextField(this.strippedJavaHome);
            JButton fileChooserButton = new JButton("...");
            fileChooserButton.setActionCommand("fileChooserButton");
            fileChooserButton.addActionListener(actionListener);
            jdkPanel.add((Component)this.jdkTextField, "Center");
            jdkPanel.add((Component)fileChooserButton, "East");
            JPanel actionPanel = new JPanel(new BorderLayout());
            JTextArea label = new JTextArea("Check those values before installing.");
            label.setEditable(false);
            label.setBackground(this.contentPanel.getBackground());
            label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JButton okButton = new JButton("Install");
            okButton.setActionCommand("okButton");
            okButton.addActionListener(actionListener);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setActionCommand("cancelButton");
            cancelButton.addActionListener(actionListener);
            actionPanel.add((Component)label, "North");
            actionPanel.add((Component)okButton, "Center");
            actionPanel.add((Component)cancelButton, "East");
            this.contentPanel.add((Component)welcome, "North");
            this.contentPanel.add((Component)jdkPanel, "Center");
            this.contentPanel.add((Component)actionPanel, "South");
        }

        @Override
        protected void processWindowEvent(WindowEvent e) {
            super.processWindowEvent(e);
            if (e.getID() == 201) {
                System.exit(0);
            }
        }

        private void getSystemProperties() {
            try {
                int i;
                this.javaRuntimeName = System.getProperty("java.runtime.name");
                this.javaVersion = System.getProperty("java.version");
                this.osName = System.getProperty("os.name");
                this.osVersion = System.getProperty("os.version");
                this.osArch = System.getProperty("os.arch");
                this.javaHome = System.getProperty("java.home");
                this.fileSeparator = System.getProperty("file.separator");
                if (this.fileSeparator == null || this.fileSeparator.length() == 0) {
                    this.showError("Empty file separator !");
                }
                if (!this.fileSeparator.equals("/") && !this.fileSeparator.equals("\\")) {
                    this.showError("Unknown file separator [" + this.fileSeparator + "] !");
                }
                if (this.javaHome == null) {
                    this.showError("Could not get java home directory !");
                }
                if ((i = this.javaHome.lastIndexOf(this.fileSeparator)) == -1) {
                    this.showError("Invalid java home directory: " + this.javaHome);
                }
                this.strippedJavaHome = this.javaHome.substring(0, i);
            }
            catch (Exception e) {
                this.showError(e.toString());
            }
        }

        private void showError(String msg) {
            JOptionPane.showMessageDialog(this, msg + "\n\nPlease send a bug report to <ejen@noos.fr>,\nSorry.", "Fatal error", 0);
            System.exit(-1);
        }

        private void showWarning(String msg) {
            JOptionPane.showMessageDialog(this, msg, "Warning", 2);
        }

        private void showInformation(String msg) {
            JOptionPane.showMessageDialog(this, msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void install() {
            String fileContent;
            String fileName;
            if (this.fileSeparator.equals("/")) {
                fileName = "java-env";
                fileContent = "#!/bin/sh\nexport JAVA_HOME=\"" + this.strippedJavaHome + "\"";
            } else {
                fileName = "java-env.bat";
                fileContent = "set JAVA_HOME=\"" + this.strippedJavaHome + "\"";
            }
            FileWriter fw = null;
            try {
                fw = new FileWriter(fileName);
                fw.write(fileContent);
            }
            catch (Exception e) {
                this.showError("Could not create \"" + fileName + "\": " + e.toString());
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Exception e) {
                    }
                    finally {
                        fw = null;
                    }
                }
            }
            if (this.fileSeparator.equals("/")) {
                try {
                    Runtime.getRuntime().exec("chmod +x " + fileName);
                }
                catch (Exception e) {
                    this.showWarning("Could not set the execute permission for \"" + fileName + "\": " + e.toString() + "\nDo it yourself...");
                }
            }
            this.showInformation("\"" + fileName + "\" created.\n\n" + ejenVersion + " installation finished.");
            System.exit(0);
        }
    }
}

