
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen;

import java.util.EventObject ;

/**
 * Ejen event class.
 * @author F. Wolff
 * @version 1.0
 * @see org.ejen.EjenListener
 */
public class EjenEvent extends EventObject  implements EjenConstants {
    protected String  _msg = null;
    protected int _level = MSG_DEBUG;

    /**
     * Constructs a new EjenEvent object (with message set to null
     * and level set to {@link org.ejen.EjenConstants#MSG_DEBUG}).
     * @param source the object on which the Event initially occurred
     *        (may not be null).
     */
    public EjenEvent(Object  source) {
        this(source, null, MSG_DEBUG);
    }

    /**
     * Constructs a new EjenEvent object (with message set to null).
     * @param source the object on which the Event initially occurred
     *        (may not be null).
     * @param level level of this EjenEvent (see {@link org.ejen.EjenConstants})
     */
    public EjenEvent(Object  source, int level) {
        this(source, null, level);
    }

    /**
     * Constructs a new EjenEvent object (with level set to
     * {@link org.ejen.EjenConstants#MSG_INFO}).
     * @param source the object on which the Event initially occurred
     *        (may not be null).
     * @param msg message associated to this EjenEvent.
     */
    public EjenEvent(Object  source, String  msg) {
        this(source, msg, MSG_INFO);
    }

    /**
     * Constructs a new EjenEvent object.
     * @param source the object on which the Event initially occurred
     *        (may not be null).
     * @param msg message associated to this EjenEvent.
     * @param level level of this EjenEvent (see {@link org.ejen.EjenConstants})
     */
    public EjenEvent(Object  source, String  msg, int level) {
        super(source);
        _msg = msg;
        _level = level;
    }
    
    /**
     * Returns this EjenEvent message.
     * @return the message (may be null).
     */
    public String  getMessage() {
        return _msg;
    }
    
    /**
     * Returns this EjenEvent level.
     * @return the level.
     */
    public int getLevel() {
        return _level;
    }
    
    /**
     * Returns this EjenEvent message.
     * @return the message (may be null).
     */
    public String  toString() {
        return _msg;
    }
}
