/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.util;

import java.io.StringReader;
import java.lang.reflect.Constructor;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.NodeSet;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XSLUtil {
    protected XSLUtil() {
    }

    public static TransformerImpl getDefaultTransformer(TransformerFactoryImpl tfi) {
        try {
            return (TransformerImpl)tfi.newTransformer((Source)new StreamSource(new StringReader("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" xmlns:fiu=\"org.ejen.ext.FileUtil\" xmlns:stu=\"org.ejen.ext.StringUtil\" xmlns:ver=\"org.ejen.ext.Version\" exclude-result-prefixes=\"fiu stu ver\" version=\"1.0\"/>")));
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static String getAttribute(XSLProcessorContext context, ElemExtensionCall elem, String name, boolean throwsIfNull) {
        try {
            String value = elem.getAttribute(name, context.getContextNode(), context.getTransformer());
            if (value == null && throwsIfNull) {
                throw new IllegalArgumentException("no \"" + name + "\" attribute");
            }
            return value;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static XObject getXOAttribute(XSLProcessorContext context, ElemExtensionCall elem, String name, boolean isAVT, boolean throwsIfNull) {
        String value = null;
        try {
            value = isAVT ? elem.getAttribute(name, context.getContextNode(), context.getTransformer()) : elem.getAttribute(name);
            if (value == null && throwsIfNull) {
                throw new IllegalArgumentException("no \"" + name + "\" attribute");
            }
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
        return value == null ? null : XSLUtil.evaluate(context, elem, value);
    }

    public static Object getOAttribute(XSLProcessorContext context, ElemExtensionCall elem, String name, Class clazz, boolean isAVT, boolean throwsIfNull) {
        XObject xo = XSLUtil.getXOAttribute(context, elem, name, isAVT, throwsIfNull);
        if (xo == null) {
            return null;
        }
        if (xo.object() == null || clazz.isAssignableFrom(xo.object().getClass())) {
            return xo.object();
        }
        throw new WrappedRuntimeException((Exception)new ClassCastException("Class of \"" + name + "\" attribute should be " + clazz));
    }

    public static String evaluate(XSLProcessorContext context, ElemExtensionCall elem) {
        return XSLUtil.getAttribute(context, elem, "avt", true);
    }

    public static String evaluate(ExpressionContext context, String avt) {
        try {
            if (!(context instanceof XPathContext.XPathExpressionContext)) {
                throw new IllegalArgumentException("bad context: " + context);
            }
            XPathContext.XPathExpressionContext xpec = (XPathContext.XPathExpressionContext)context;
            StylesheetHandler sh = (StylesheetHandler)((TransformerFactoryImpl)TransformerFactory.newInstance()).newTemplatesHandler();
            return XSLUtil.evaluateAttribute(sh, xpec.getXPathContext(), xpec.getContextNode(), avt);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static XObject evaluate(XSLProcessorContext context, ElemExtensionCall elem, String expression) {
        try {
            XPathContext xpc = context.getTransformer().getXPathContext();
            XPath xp = new XPath(expression, (SourceLocator)elem, xpc.getNamespaceContext(), 0);
            return xp.execute(xpc, context.getContextNode(), (PrefixResolver)elem);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static XObject evaluate(Node contextNode, String str) {
        return XSLUtil.evaluate(contextNode, str, contextNode, null);
    }

    public static XObject evaluate(Node contextNode, String str, ErrorListener el) {
        return XSLUtil.evaluate(contextNode, str, contextNode, el);
    }

    public static XObject evaluate(Node contextNode, String str, Node namespaceNode, ErrorListener el) {
        try {
            XPathContext xpc = new XPathContext();
            PrefixResolverDefault pr = new PrefixResolverDefault(namespaceNode.getNodeType() == 9 ? ((Document)namespaceNode).getDocumentElement() : namespaceNode);
            XPath xp = new XPath(str, null, (PrefixResolver)pr, 0, el);
            int iContextNode = xpc.getDTMHandleFromNode(contextNode);
            return xp.execute(xpc, iContextNode, (PrefixResolver)pr);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    private static AVT constructAVT(StylesheetHandler handler, String uri, String name, String rawName, String stringedValue) throws Exception {
        Class[] parameterType = new Class[6];
        Constructor<?> avtConstr = null;
        AVT avt = null;
        try {
            parameterType[0] = Class.forName("org.apache.xalan.processor.StylesheetHandler");
            parameterType[1] = Class.forName("java.lang.String");
            parameterType[2] = Class.forName("java.lang.String");
            parameterType[3] = Class.forName("java.lang.String");
            parameterType[4] = Class.forName("java.lang.String");
            parameterType[5] = Class.forName("org.apache.xalan.templates.ElemTemplateElement");
            avtConstr = Class.forName("org.apache.xalan.templates.AVT").getConstructor(parameterType);
            Object[] parameter = new Object[]{handler, uri, name, rawName, stringedValue, null};
            avt = (AVT)avtConstr.newInstance(parameter);
        }
        catch (Exception e) {
            parameterType = new Class[]{Class.forName("org.apache.xalan.processor.StylesheetHandler"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
            avtConstr = Class.forName("org.apache.xalan.templates.AVT").getConstructor(parameterType);
            Object[] parameter = new Object[]{handler, uri, name, rawName, stringedValue};
            avt = (AVT)avtConstr.newInstance(parameter);
        }
        return avt;
    }

    public static String evaluateAttribute(StylesheetHandler sh, XPathContext xpc, Node node, String expr) throws TransformerException {
        String name;
        String uri = node.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        if ((name = node.getNodeName()) == null) {
            name = "";
        }
        String prefix = node.getPrefix();
        String rawName = (prefix != null ? prefix + ":" : "") + name;
        AVT avt = null;
        try {
            avt = XSLUtil.constructAVT(sh, uri, name, rawName, expr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException("AVT constructor not found");
        }
        PrefixResolverDefault pr = new PrefixResolverDefault(node.getNodeType() == 9 ? ((Document)node).getDocumentElement() : node);
        return avt.evaluate(xpc, xpc.getDTMHandleFromNode(node), (PrefixResolver)pr).toString();
    }

    public static boolean equals(NodeIterator ni1, NodeIterator ni2) {
        NodeSet ns1 = new NodeSet(ni1);
        NodeSet ns2 = new NodeSet(ni2);
        if (ns1.getLength() != ns2.getLength()) {
            return false;
        }
        for (int i = 0; i < ns1.getLength(); ++i) {
            if (XSLUtil.equals(ns1.elementAt(i), ns2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Node n1, Node n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.getNodeType() != n2.getNodeType()) {
            return false;
        }
        if (!n1.getNodeName().equals(n2.getNodeName())) {
            return false;
        }
        String v1 = n1.getNodeValue();
        String v2 = n2.getNodeValue();
        if (v1 == null && v2 != null || v1 != null && !v1.equals(v2)) {
            return false;
        }
        NamedNodeMap nnm1 = n1.getAttributes();
        NamedNodeMap nnm2 = n2.getAttributes();
        if ((nnm1 == null || nnm2 == null) && nnm1 != nnm2) {
            return false;
        }
        if (nnm1 != null) {
            int nnm1Length = nnm1.getLength();
            if (nnm1Length != nnm2.getLength()) {
                return false;
            }
            for (int i = 0; i < nnm1Length; ++i) {
                if (XSLUtil.equals(nnm1.item(i), nnm2.item(i))) continue;
                return false;
            }
        }
        NodeList nl1 = n1.getChildNodes();
        NodeList nl2 = n2.getChildNodes();
        int nl1Length = nl1.getLength();
        if (nl1Length != nl2.getLength()) {
            return false;
        }
        for (int i = 0; i < nl1Length; ++i) {
            if (XSLUtil.equals(nl1.item(i), nl2.item(i))) continue;
            return false;
        }
        return true;
    }

    public static Document getContextDocument(ExpressionContext context) {
        try {
            return context.getContextNode().getOwnerDocument();
        }
        catch (Exception e) {
            throw new WrappedRuntimeException("Failed to get Document from ExpressionContext", e);
        }
    }
}

