/*
 * Decompiled with CFR 0.152.
 */
package org.ejen.ext;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.regexp.RE;
import org.apache.xalan.extensions.ExpressionContext;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.NodeSet;
import org.ejen.util.DOMUtil;
import org.ejen.util.XSLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FileUtil {
    public static final String S_TRUE = "true";
    public static final String S_FALSE = "false";

    protected FileUtil() {
    }

    public static NodeSet properties(ExpressionContext context, String fileName) {
        fileName = XSLUtil.evaluate(context, fileName);
        Document doc = XSLUtil.getContextDocument(context);
        try {
            File f = new File(fileName);
            NodeSet ns = new NodeSet();
            ns.addElement(DOMUtil.createCDATANode(doc, "raw", fileName));
            String s = f.getName();
            ns.addElement(DOMUtil.createCDATANode(doc, "name", s));
            int i = s.indexOf(46);
            ns.addElement(DOMUtil.createCDATANode(doc, "name-no-ext", i != -1 ? s.substring(0, i) : s));
            s = f.getParent();
            ns.addElement(DOMUtil.createCDATANode(doc, "parent", s != null ? s : ""));
            ns.addElement(DOMUtil.createCDATANode(doc, "path", f.getPath()));
            ns.addElement(DOMUtil.createCDATANode(doc, "is-absolute", f.isAbsolute() ? S_TRUE : S_FALSE));
            ns.addElement(DOMUtil.createCDATANode(doc, "absolute-path", f.getAbsolutePath()));
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "canonical-path", f.getCanonicalPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "url", f.toURL().toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "can-read", f.canRead() ? S_TRUE : S_FALSE));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "can-write", f.canWrite() ? S_TRUE : S_FALSE));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "exists", f.exists() ? S_TRUE : S_FALSE));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "is-directory", f.isDirectory() ? S_TRUE : S_FALSE));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "is-hidden", f.isHidden() ? S_TRUE : S_FALSE));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "last-modified", Long.toString(f.lastModified())));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                ns.addElement(DOMUtil.createCDATANode(doc, "length", Long.toString(f.length())));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return ns;
        }
        catch (WrappedRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    public static NodeSet listFiles(ExpressionContext context, String path) {
        return FileUtil.listFiles(context, path, null, false);
    }

    public static NodeSet listFiles(ExpressionContext context, String path, String filter) {
        return FileUtil.listFiles(context, path, filter, false);
    }

    public static NodeSet listFiles(ExpressionContext context, String path, String filter, boolean rec) {
        path = XSLUtil.evaluate(context, path);
        final String ffilter = filter != null ? XSLUtil.evaluate(context, filter) : null;
        Document doc = XSLUtil.getContextDocument(context);
        try {
            File f = new File(path);
            if (!f.isDirectory()) {
                throw new IllegalArgumentException(path + " is not a directory.");
            }
            FileFilter ff = null;
            if (ffilter != null) {
                ff = new FileFilter(){
                    RE _re;
                    {
                        this._re = new RE(ffilter);
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || this._re.match(f.getName());
                    }

                    public String getDescription() {
                        return ffilter;
                    }
                };
            }
            File[] files = f.listFiles(ff);
            NodeSet ns = new NodeSet();
            FileUtil.appendFiles(doc, ns, files, ff, rec);
            return ns;
        }
        catch (Exception e) {
            throw new WrappedRuntimeException(e);
        }
    }

    protected static void appendFiles(Document doc, NodeSet ns, File[] files, FileFilter ff, boolean rec) throws Exception {
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!f.isDirectory()) {
                Element file = doc.createElement("file");
                Element elt = doc.createElement("path");
                String path = f.getCanonicalFile().getParent();
                elt.appendChild(doc.createCDATASection(path != null ? path : ""));
                file.appendChild(elt);
                elt = doc.createElement("sep");
                elt.appendChild(doc.createCDATASection(File.separator));
                file.appendChild(elt);
                elt = doc.createElement("name");
                elt.appendChild(doc.createCDATASection(f.getName()));
                file.appendChild(elt);
                ns.addElement((Node)file);
                continue;
            }
            if (!rec) continue;
            FileUtil.appendFiles(doc, ns, f.listFiles(ff), ff, rec);
        }
    }
}

