/*
 * Decompiled with CFR 0.152.
 */
package org.ejen;

import java.util.Properties;
import javax.xml.transform.dom.DOMSource;
import org.apache.xpath.XPathAPI;
import org.ejen.EjenChildNode;
import org.ejen.EjenException;
import org.ejen.util.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EjenMergeNode
extends EjenChildNode {
    protected String _file = null;
    protected String _select = null;
    protected String _to = null;

    @Override
    public String nodeName() {
        return "source";
    }

    @Override
    public Properties getAttributes() {
        Properties attrs = super.getAttributes();
        if (this._file != null) {
            attrs.setProperty("file", this._file);
        }
        if (this._select != null) {
            attrs.setProperty("select", this._select);
        }
        if (this._to != null) {
            attrs.setProperty("to", this._to);
        }
        return attrs;
    }

    public void setFile(String file) {
        this._file = file;
    }

    public void setSelect(String select) {
        this._select = select;
    }

    public void setTo(String to) {
        this._to = to;
    }

    @Override
    public void check() {
        super.check();
        if (this._file == null) {
            throw new EjenException(this, "No 'file' attribute");
        }
    }

    @Override
    public void process() {
        super.process();
        DOMSource src = null;
        try {
            src = (DOMSource)this.getFromGlobalContext("DOM_SOURCE");
        }
        catch (Exception e) {
            throw new EjenException(this, null, e);
        }
        if (src == null) {
            throw new EjenException(this, "no 'DOM_SOURCE' in global context");
        }
        try {
            Document srcDoc = (Document)src.getNode();
            Node to = srcDoc.getDocumentElement();
            if (this._to != null) {
                to = XPathAPI.selectSingleNode((Node)srcDoc, (String)this.evaluateAVT(this._to));
            }
            Document mergeDoc = DOMUtil.parseXMLFile(this.evaluateAVT(this._file));
            if (this._select == null) {
                to.appendChild(srcDoc.importNode(mergeDoc.getDocumentElement().cloneNode(true), true));
            } else {
                NodeList nl = XPathAPI.selectNodeList((Node)mergeDoc, (String)this.evaluateAVT(this._select));
                for (int i = 0; i < nl.getLength(); ++i) {
                    to.appendChild(srcDoc.importNode(nl.item(i), true));
                }
            }
        }
        catch (EjenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EjenException(this, "merge error", e);
        }
    }
}

