
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen;

import java.util.EventListener ;

/**
 * Ejen listener class.
 * @author F. Wolff
 * @version 1.0
 * @see org.ejen.EjenEvent
 */
public interface EjenListener extends EventListener  {

    /**
     * Invoked when an EjenChildNode state has changed. See
     * {@link org.ejen.EjenChildNode#sendStateEvent()}.
     */
    public void stateChanged(EjenEvent ejenEvent);

    /**
     * Invoked when an EjenChildNode sends a message. See
     * {@link org.ejen.EjenChildNode#sendMessageEvent(String msg)}.
     */
    public void nodeMessageSent(EjenEvent ejenEvent);

    /**
     * Invoked when an XSL stylesheet sends a message. See
     * {@link org.ejen.ext.Messenger#send(XSLProcessorContext context, ElemExtensionCall elem)}.
     */
    public void xslMessageSent(EjenEvent ejenEvent);
}
