
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen;

import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xalan.templates.StylesheetRoot;

/**
 * Import node class.
 * <p>
 * An import node allows to import a stylesheet into another stylesheet
 * (filter, template, include or even import).
 * <p>
 * <table class="usage">
 * <tr><th class="usage">Usage (ant build file)</th></tr>
 * <tr><td class="usage"><pre><code>
 *  &lt;?xml version="1.0" encoding="UTF-8"?&gt;
 *
 *  &lt;project name="generate" default="build"&gt;
 *
 *    &lt;taskdef name="ejen" classname="org.ejen.EjenTask"/&gt;
 *
 *    &lt;target name="build"&gt;
 *      &lt;{@link org.ejen.EjenTask ejen} ...&gt;
 *        ...
 *        &lt;{@link org.ejen.EjenFilterNode filter} ...&gt;
 *          ...
 *          <b>&lt;import {@link org.ejen.EjenStylesheetNode#setFile(String) file}="import.xml"&gt;</b>
 *            ...
 *            [&lt;{@link org.ejen.EjenIncludeNode include} .../&gt;]
 *            [&lt;import .../&gt;]
 *            [&lt;{@link org.ejen.EjenParamNode param} .../&gt;]
 *            ...
 *          <b>&lt;/import&gt;</b>
 *          ...
 *        &lt;/filter&gt;
 *        ...
 *      &lt;/ejen&gt;
 *    &lt;/target&gt;
 *
 *  &lt;/project&gt;
 * </code></pre></td></tr></table>
 * <p>
 * <b>Parent nodes</b>:
 * <ul>
 *   <li>{@link org.ejen.EjenFilterNode filter}
 *   <li>{@link org.ejen.EjenTemplateNode template}
 *   <li>{@link org.ejen.EjenIncludeNode include}
 *   <li>import
 * </ul>
 * @author F. Wolff
 * @version 1.0
 */
public class EjenImportNode extends EjenStylesheetNode {

    /**
     * Returns the name of this EjenImportNode (always "import").
     * @return the name of this EjenImportNode.
     */
    public String  nodeName() {
        return "import";
    }
    
    /**
     * Executes this EjenImportNode.
     * @throws org.ejen.EjenException if something goes wrong...
     */
    public void process() {
        super.process();
        try {
            TransformerImpl ti = (TransformerImpl) (getFromContext(CTX_TRANSFORMER_IMPL));

            if (ti == null) {
                throw new EjenException(this,
                        "no '" + CTX_TRANSFORMER_IMPL + "' in context");
            }
            StylesheetRoot sr = (StylesheetRoot) (getFromContext(CTX_STYLESHEET_ROOT,
                    -1));

            if (sr == null) {
                throw new EjenException(this,
                        "no '" + CTX_STYLESHEET_ROOT + "' in context");
            }
            sr.setImport(ti.getStylesheet());
        } catch (EjenException e) {
            throw e;
        } catch (Exception  e) {
            throw new EjenException(this, "bad include", e);
        }
    }
}
