
//
// Ejen (code generation system)
// Copyright (C) 2001, 2002 François Wolff (ejen@noos.fr).
//
// This file is part of Ejen.
//
// Ejen is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Ejen is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Ejen; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
package org.ejen;

/**
 * Ejen exception class. May wrap another exception. 
 * @author F. Wolff
 * @version 1.0
 */
public class EjenException extends RuntimeException  {
    protected EjenChildNode _ejenChildNode = null;
    protected String  _message = "(no message)";
    protected Throwable  _embeddedThrowable = null;

    /**
     * Constructor.
     * @param ejenChildNode the EjenChildNode that is throwing this EjenException.
     * @param message the message associated with this EjenException.
     */
    public EjenException(EjenChildNode ejenChildNode, String  message) {
        this(ejenChildNode, message, null);
    }

    /**
     * Constructor.
     * @param ejenChildNode the EjenChildNode that is throwing this EjenException.
     * @param message the message associated with this EjenException.
     * @param t an embedded exception.
     */
    public EjenException(EjenChildNode ejenChildNode, String  message, Throwable  t) {
        _ejenChildNode = ejenChildNode;
        if (message != null) {
            _message = message;
        }
        _embeddedThrowable = t;
    }
    
    /**
     * Returns a compound message: "&lt;ecn&gt; {&lt;attrs&gt;}: &lt;msg&gt; [&lt;eemsg&gt;]",
     * where:
     * <ul>
     *   <li>&lt;ecn&gt; is the name of the EjenChildNode that have thrown this
     *       EjenException.
     *   <li>&lt;attrs&gt; are all attributes of the EjenChildNode that have thrown this
     *       EjenException.
     *   <li>&lt;msg&gt; is the message associated with this EjenException.
     *   <li>&lt;eemsg&gt; is the message associated with the embedded exception.
     * </ul>
     * @return the compound message.
     */
    public String  getMessage() {
        String  nodeInfo = "(unknown node)";
        String  embeddedThrowableString = "";

        if (_ejenChildNode != null) {
            nodeInfo = _ejenChildNode.toString();
        }
        if (_embeddedThrowable != null) {
            embeddedThrowableString = " [" + _embeddedThrowable.toString() + "]";
        }
        return nodeInfo + ": " + _message + embeddedThrowableString;
    }
    
    /**
     * Returns the embedded exception.
     * @return the embedded message (may be null).
     */
    public Throwable  getEmbeddedThrowable() {
        return _embeddedThrowable;
    }
    
    /**
     * Returns the EjenChildNode that have thrown this EjenException.
     * @return the EjenChildNode.
     */
    public EjenChildNode getEjenChildNode() {
        return _ejenChildNode;
    }
    
    /**
     * Returns the message associated with this EjenException.
     * @return the message (may be null).
     */
    public String  getRawMessage() {
        return _message;
    }
}
