/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.xslt;

import java.io.File;
import java.io.RandomAccessFile;

public class ConfigWritter {
    public void writeDefaultsToConfig(String outputPath) {
        try {
            File file;
            if (!outputPath.endsWith("\\") && !outputPath.endsWith("/")) {
                outputPath = outputPath + "/";
            }
            if (!(file = new File(outputPath)).exists()) {
                file.createNewFile();
            }
            RandomAccessFile fileConf = new RandomAccessFile(file, "rw");
            fileConf.seek(fileConf.length());
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.lazyLoading=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.maxExecuteTime=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.AllReadOnly=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.TransactionCheck=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.DeleteCheckVersion=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.AutoWrite=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.TransactionCaches=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.AutoSave=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.AutoSaveCreateVirgin=false");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.DefaultFetchSize=-1");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.MainCacheLockTimeout=100");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.CacheLockTimeout=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.CacheLockRetryCount=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.QueryTimeout=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.MaxConnectionUsages=-1");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.cache.maxCacheSize=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.cache.maxSimpleCacheSize=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.cache.maxComplexCacheSize=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.cache.maxMultiJoinCacheSize=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.cache.reserveFactor=0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.cache.CachePercentage=-1.0");
            fileConf.writeBytes("\r\n");
            fileConf.writeBytes("DatabaseManager.defaults.cache.initAllCaches=false");
            fileConf.writeBytes("\r\n");
            fileConf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToConfig(String outputPath, String databaseName, String tableName, String attrName, String attrValue) {
        try {
            File file;
            if (!outputPath.endsWith("\\") && !outputPath.endsWith("/")) {
                outputPath = outputPath + "/";
            }
            if (!(file = new File(outputPath)).exists()) {
                file.createNewFile();
            }
            RandomAccessFile fileConf = new RandomAccessFile(file, "rw");
            fileConf.seek(fileConf.length());
            fileConf.writeBytes("\r\n");
            if (attrName.equals("isLazyLoading") && attrValue.equals("true")) {
                fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".lazyLoading=true");
                fileConf.writeBytes("\r\n");
            }
            if (attrName.equals("caching")) {
                if (attrValue.equals("full")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.maxCacheSize=-1");
                    fileConf.writeBytes("\r\n");
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.initialCondition=*");
                    fileConf.writeBytes("\r\n");
                }
                if (attrValue.equals("partial")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.maxCacheSize=-1");
                    fileConf.writeBytes("\r\n");
                }
                if (attrValue.equals("none")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.maxCacheSize=0");
                    fileConf.writeBytes("\r\n");
                }
            }
            fileConf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeToConfigDefault(String outputPath, String databaseName, String tableName, String attrName, String defaultValue) {
        try {
            File file;
            if (!outputPath.endsWith("\\") && !outputPath.endsWith("/")) {
                outputPath = outputPath + "/";
            }
            if (!(file = new File(outputPath)).exists()) {
                file.createNewFile();
            }
            RandomAccessFile fileConf = new RandomAccessFile(file, "rw");
            fileConf.seek(fileConf.length());
            fileConf.writeBytes("\r\n");
            if (attrName.equals("isLazyLoading")) {
                if (defaultValue.equals("true")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".lazyLoading=true");
                    fileConf.writeBytes("\r\n");
                }
                if (defaultValue.equals("false")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".lazyLoading=false");
                    fileConf.writeBytes("\r\n");
                }
                if (defaultValue.equals("${defaultLazyLoading}")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".lazyLoading=");
                    fileConf.writeBytes("\r\n");
                }
            }
            if (attrName.equals("caching")) {
                if (defaultValue.equals("full")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.maxCacheSize=-1");
                    fileConf.writeBytes("\r\n");
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.initialCondition=*");
                    fileConf.writeBytes("\r\n");
                }
                if (defaultValue.equals("partial")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.maxCacheSize=-1");
                    fileConf.writeBytes("\r\n");
                }
                if (defaultValue.equals("none")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.maxCacheSize=0");
                    fileConf.writeBytes("\r\n");
                }
                if (defaultValue.equals("${defaultCaching}")) {
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.maxCacheSize=");
                    fileConf.writeBytes("\r\n");
                    fileConf.writeBytes("DatabaseManager.DB." + databaseName + "." + tableName + ".cache.initialCondition=");
                    fileConf.writeBytes("\r\n");
                }
            }
            fileConf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

