/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.enhydra.dods.Common;
import org.enhydra.dods.wizard.DefaultDODSWizard;
import org.enhydra.dods.wizard.DirectoryFilter;
import org.enhydra.dods.wizard.DomlFilter;
import org.enhydra.dods.wizard.ExecThread;
import org.enhydra.dods.wizard.MessageDialog;
import org.enhydra.dods.wizard.XYConstraints;
import org.enhydra.dods.wizard.XYLayout;
import org.enhydra.dods.xml.XmlUtil;

public class WizardFrame1
extends JFrame {
    JPanel contentPane;
    JPanel jButtonPanel = new JPanel();
    JPanel jPictPanel = new JPanel();
    JPanel jContentPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    XYLayout xyLayout = new XYLayout();
    JLabel jIconLabel = new JLabel();
    JLabel jTitleLabel = new JLabel();
    JLabel jOutputDirLabel = new JLabel();
    JLabel jDomlRootLabel = new JLabel();
    JLabel jTemplateTypeLabel = new JLabel();
    JLabel jDocLabel = new JLabel();
    JLabel jVendorTypeLabel = new JLabel();
    JLabel jJavaLabel = new JLabel();
    JLabel jConfigDirLabel = new JLabel();
    JTextField jOutputDirTextField = new JTextField();
    JTextField jDomlTextField = new JTextField();
    JTextField jConfigDirTextField = new JTextField();
    JButton jDomlButton = new JButton();
    JButton jSpaceButton = new JButton();
    JButton jGenerateButton = new JButton();
    JButton jCancelButton = new JButton();
    JButton jOutputDirButton = new JButton();
    JButton jSpace = new JButton();
    JButton jCloseButton = new JButton();
    JButton jSpace1 = new JButton();
    JButton jConfigDirButton = new JButton();
    Image appImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("smallicon.gif"));
    ImageIcon enhydra = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("Enhydra.gif")));
    ResourceBundle rb;
    JCheckBox jCheckBoxSQL = new JCheckBox();
    JCheckBox jCheckBoxSQLSplitter = new JCheckBox();
    JCheckBox jCheckBoxJava = new JCheckBox();
    JCheckBox jCheckBoxCompile = new JCheckBox();
    JCheckBox jCheckBoxDoml2Html = new JCheckBox();
    JCheckBox jCheckBoxDoml2Pdf = new JCheckBox();
    JCheckBox jCheckBoxDoml2Xmi = new JCheckBox();
    JCheckBox jCheckBoxDoml2Ptl = new JCheckBox();
    JCheckBox jCheckBoxForce = new JCheckBox();
    JCheckBox jCheckBoxInvoke = new JCheckBox();
    JComboBox jComboBoxTemplateSet = new JComboBox();
    JComboBox jComboBoxVendors = new JComboBox();

    public WizardFrame1() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setIconImage(this.appImage);
        this.setResizable(false);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(570, 550));
        this.setTitle("DODS Generator Wizard");
        this.jButtonPanel.setDebugGraphicsOptions(-1);
        this.jButtonPanel.setMinimumSize(new Dimension(233, 50));
        this.jButtonPanel.setPreferredSize(new Dimension(500, 50));
        this.jContentPanel.setLayout(this.xyLayout);
        this.jGenerateButton.setFont(new Font("SansSerif", 0, 11));
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            this.jGenerateButton.setNextFocusableComponent(this.jCheckBoxInvoke);
        } else {
            this.jGenerateButton.setNextFocusableComponent(this.jConfigDirTextField);
        }
        this.jGenerateButton.setActionCommand("Generate");
        this.jGenerateButton.setSelected(true);
        this.jGenerateButton.setText("Generate");
        this.jGenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jGenerateButton_actionPerformed(e);
            }
        });
        this.jCancelButton.setFont(new Font("SansSerif", 0, 11));
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            this.jCancelButton.setNextFocusableComponent(this.jCloseButton);
        } else {
            this.jCancelButton.setNextFocusableComponent(this.jGenerateButton);
        }
        this.jCancelButton.setText("Cancel");
        this.jCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jCancelButton_actionPerformed(e);
            }
        });
        this.jCloseButton.setFont(new Font("SansSerif", 0, 11));
        this.jCloseButton.setNextFocusableComponent(this.jGenerateButton);
        this.jCloseButton.setText(" Close ");
        this.jCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jCloseButton_actionPerformed(e);
            }
        });
        this.jConfigDirTextField.setNextFocusableComponent(this.jConfigDirButton);
        this.jConfigDirTextField.setText(Common.getConfigDir());
        this.jConfigDirLabel.setFont(new Font("SansSerif", 0, 12));
        this.jConfigDirLabel.setText("Config directory :");
        this.jConfigDirButton.setFont(new Font("SansSerif", 0, 12));
        this.jConfigDirButton.setMaximumSize(new Dimension(55, 25));
        this.jConfigDirButton.setMinimumSize(new Dimension(55, 25));
        this.jConfigDirButton.setNextFocusableComponent(this.jOutputDirTextField);
        this.jConfigDirButton.setPreferredSize(new Dimension(55, 25));
        this.jConfigDirButton.setMargin(new Insets(2, 14, 3, 14));
        this.jConfigDirButton.setText("Set ...");
        this.jConfigDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jConfigDirButton_actionPerformed(e);
            }
        });
        this.jSpace.setEnabled(false);
        this.jSpace.setBorder(null);
        this.jSpace.setPreferredSize(new Dimension(30, 20));
        this.jSpace.setFocusPainted(false);
        this.jSpace.setMargin(new Insets(2, 50, 2, 14));
        this.jSpace1.setEnabled(false);
        this.jSpace1.setBorder(null);
        this.jSpace1.setPreferredSize(new Dimension(30, 20));
        this.jSpace1.setFocusPainted(false);
        this.jSpace1.setMargin(new Insets(2, 50, 2, 14));
        this.jOutputDirTextField.setNextFocusableComponent(this.jOutputDirButton);
        this.jOutputDirTextField.setText(DefaultDODSWizard.getGenerator().getOutputDir());
        this.jDomlTextField.setNextFocusableComponent(this.jDomlButton);
        this.jDomlTextField.setText(DefaultDODSWizard.getGenerator().getDoml());
        this.jTitleLabel.setFont(new Font("SansSerif", 0, 12));
        this.jTitleLabel.setText("Please select config directory, output directory, doml file, template set and choose actions.");
        this.jOutputDirLabel.setFont(new Font("SansSerif", 0, 12));
        this.jOutputDirLabel.setText("Output directory :");
        this.jOutputDirButton.setFont(new Font("SansSerif", 0, 12));
        this.jOutputDirButton.setMaximumSize(new Dimension(55, 25));
        this.jOutputDirButton.setMinimumSize(new Dimension(55, 25));
        this.jOutputDirButton.setNextFocusableComponent(this.jDomlTextField);
        this.jOutputDirButton.setPreferredSize(new Dimension(55, 25));
        this.jOutputDirButton.setMargin(new Insets(2, 14, 3, 14));
        this.jOutputDirButton.setText("Set ...");
        this.jOutputDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jOutputDirButton_actionPerformed(e);
            }
        });
        this.jDomlRootLabel.setText("Doml file :");
        this.jDomlRootLabel.setFont(new Font("SansSerif", 0, 12));
        this.jDomlButton.setFont(new Font("SansSerif", 0, 12));
        this.jDomlButton.setMaximumSize(new Dimension(50, 25));
        this.jDomlButton.setMinimumSize(new Dimension(55, 25));
        this.jDomlButton.setNextFocusableComponent(this.jCheckBoxDoml2Html);
        this.jDomlButton.setPreferredSize(new Dimension(55, 25));
        this.jDomlButton.setMargin(new Insets(2, 14, 3, 14));
        this.jDomlButton.setText("Set ...");
        this.jDomlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jDomlButton_actionPerformed(e);
            }
        });
        this.jDocLabel.setText("Documentation :");
        this.jDocLabel.setFont(new Font("SansSerif", 0, 12));
        this.jCheckBoxDoml2Html.setMaximumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Html.setMinimumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Html.setNextFocusableComponent(this.jCheckBoxDoml2Pdf);
        this.jCheckBoxDoml2Html.setSelected(DefaultDODSWizard.getGenerator().getHtml());
        this.jCheckBoxDoml2Html.setText(" HTML");
        this.jCheckBoxDoml2Pdf.setMaximumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Pdf.setMinimumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Pdf.setNextFocusableComponent(this.jCheckBoxDoml2Xmi);
        this.jCheckBoxDoml2Pdf.setSelected(DefaultDODSWizard.getGenerator().getPdf());
        this.jCheckBoxDoml2Pdf.setText(" PDF");
        this.jCheckBoxDoml2Xmi.setMaximumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Xmi.setMinimumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Xmi.setNextFocusableComponent(this.jCheckBoxDoml2Ptl);
        this.jCheckBoxDoml2Xmi.setSelected(DefaultDODSWizard.getGenerator().getXmi());
        this.jCheckBoxDoml2Xmi.setText(" XMI");
        this.jCheckBoxDoml2Ptl.setMaximumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Ptl.setMinimumSize(new Dimension(100, 22));
        this.jCheckBoxDoml2Ptl.setNextFocusableComponent(this.jComboBoxTemplateSet);
        this.jCheckBoxDoml2Ptl.setSelected(DefaultDODSWizard.getGenerator().getPtl());
        this.jCheckBoxDoml2Ptl.setText("PTL");
        this.jCheckBoxForce.setMaximumSize(new Dimension(100, 22));
        this.jCheckBoxForce.setMinimumSize(new Dimension(100, 22));
        this.jCheckBoxForce.setNextFocusableComponent(this.jComboBoxVendors);
        this.jCheckBoxForce.setSelected(true);
        if (DefaultDODSWizard.getGenerator().getForce().equals("false")) {
            this.jCheckBoxForce.setSelected(false);
        }
        this.jCheckBoxForce.setText("Overwrite");
        this.jCheckBoxInvoke.setNextFocusableComponent(this.jOutputDirTextField);
        this.jCheckBoxInvoke.setSelected(DefaultDODSWizard.getGenerator().getInvoke());
        this.jCheckBoxInvoke.setText("Invoke DODS generator during project ant rebild");
        this.jTemplateTypeLabel.setText("Template set :");
        this.jTemplateTypeLabel.setFont(new Font("SansSerif", 0, 12));
        this.jComboBoxTemplateSet.setNextFocusableComponent(this.jCheckBoxForce);
        HashSet dirs = Common.getAllTemplateSets();
        String item2 = null;
        int i = 0;
        int selIndex = 1;
        if (dirs != null) {
            for (String item2 : dirs) {
                this.jComboBoxTemplateSet.addItem(" " + item2);
                if (item2.equals(DefaultDODSWizard.getGenerator().getTemplateSet())) {
                    selIndex = i;
                }
                ++i;
            }
            this.jComboBoxTemplateSet.setSelectedIndex(selIndex);
            this.jComboBoxTemplateSet.setMinimumSize(new Dimension(135, 20));
            this.jVendorTypeLabel.setText("DB vendor :");
            this.jVendorTypeLabel.setFont(new Font("SansSerif", 0, 12));
            this.jJavaLabel.setText("Java code :");
            this.jJavaLabel.setFont(new Font("SansSerif", 0, 12));
            Set vendors = Common.getDodsConfVendorNames();
            String vendor2 = null;
            i = 0;
            selIndex = 0;
            this.jComboBoxVendors.addItem(" ");
            for (String vendor2 : vendors) {
                this.jComboBoxVendors.addItem(" " + vendor2);
                if (vendor2.equals(DefaultDODSWizard.getGenerator().getDatabase())) {
                    selIndex = i;
                }
                ++i;
            }
        } else {
            JOptionPane.showMessageDialog(null, "Error configuration folder not found.");
            System.exit(1);
        }
        this.jComboBoxVendors.setSelectedIndex(selIndex);
        this.jComboBoxVendors.setMinimumSize(new Dimension(121, 20));
        this.jComboBoxVendors.setNextFocusableComponent(this.jCheckBoxSQL);
        this.jSpaceButton.setEnabled(false);
        this.jSpaceButton.setForeground(Color.lightGray);
        this.jSpaceButton.setBorder(null);
        this.jSpaceButton.setMaximumSize(new Dimension(20, 20));
        this.jSpaceButton.setMinimumSize(new Dimension(20, 20));
        this.jSpaceButton.setPreferredSize(new Dimension(30, 30));
        this.jSpaceButton.setActionCommand("");
        this.jSpaceButton.setFocusPainted(false);
        this.jSpaceButton.setMargin(new Insets(3, 3, 3, 3));
        this.jIconLabel.setIconTextGap(10);
        this.jIconLabel.setIcon(this.enhydra);
        this.jPictPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(20);
        this.jCheckBoxSQL.setMaximumSize(new Dimension(103, 22));
        this.jCheckBoxSQL.setMinimumSize(new Dimension(103, 22));
        this.jCheckBoxSQL.setNextFocusableComponent(this.jCheckBoxSQLSplitter);
        this.jCheckBoxSQL.setSelected(false);
        this.jCheckBoxSQL.setText("SQL generate");
        this.jCheckBoxSQL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jCheckBoxSQL_actionPerformed(e);
            }
        });
        this.jCheckBoxSQLSplitter.setMaximumSize(new Dimension(103, 22));
        this.jCheckBoxSQLSplitter.setMinimumSize(new Dimension(103, 22));
        this.jCheckBoxSQLSplitter.setNextFocusableComponent(this.jCheckBoxJava);
        this.jCheckBoxSQLSplitter.setSelected(false);
        this.jCheckBoxSQLSplitter.setText("SQL splitter");
        this.jCheckBoxJava.setMaximumSize(new Dimension(104, 22));
        this.jCheckBoxJava.setMinimumSize(new Dimension(104, 22));
        this.jCheckBoxJava.setNextFocusableComponent(this.jCheckBoxCompile);
        this.jCheckBoxJava.setSelected(false);
        this.jCheckBoxJava.setText("Java generate");
        this.jCheckBoxJava.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardFrame1.this.jCheckBoxJava_actionPerformed(e);
            }
        });
        this.jCheckBoxCompile.setMaximumSize(new Dimension(100, 22));
        this.jCheckBoxCompile.setMinimumSize(new Dimension(100, 22));
        this.jCheckBoxCompile.setNextFocusableComponent(this.jCancelButton);
        this.jCheckBoxCompile.setText("Compile java");
        this.jCheckBoxCompile.setSelected(false);
        String action = DefaultDODSWizard.getGenerator().getAction();
        if (action.equals("dods:build_all") || action.equals("dods:sql") || action.equals("dods:noCompile") || action.equals("build_all_split") || action.equals("dods:sqlsplit") || action.equals("dods:noCompileSplit")) {
            this.jCheckBoxSQL.setSelected(true);
        }
        if (action.equals("build_all_split") || action.equals("dods:sqlsplit") || action.equals("dods:noCompileSplit")) {
            this.jCheckBoxSQLSplitter.setSelected(true);
        }
        if (action.equals("dods:build_all") || action.equals("dods:java") || action.equals("dods:noCompile") || action.equals("build_all_split") || action.equals("dods:javaNoCompile") || action.equals("dods:noCompileSplit")) {
            this.jCheckBoxJava.setSelected(true);
        }
        if ((action.equals("dods:build_all") || action.equals("dods:java") || action.equals("build_all_split")) && !DefaultDODSWizard.getGenerator().getKelp()) {
            this.jCheckBoxCompile.setSelected(true);
        }
        int kelp = 0;
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            this.jContentPanel.add((Component)this.jCheckBoxInvoke, new XYConstraints(32, 0, -1, -1));
            this.jContentPanel.add((Component)this.jTitleLabel, new XYConstraints(35, 35, -1, -1));
            kelp = 10;
        } else {
            this.jContentPanel.add((Component)this.jTitleLabel, new XYConstraints(35, 15, -1, -1));
        }
        this.jContentPanel.add((Component)this.jConfigDirLabel, new XYConstraints(35, 60 + kelp, -1, -1));
        this.jContentPanel.add((Component)this.jConfigDirTextField, new XYConstraints(130, 60 + kelp, 290, 20));
        this.jContentPanel.add((Component)this.jConfigDirButton, new XYConstraints(430, 60 + kelp, 65, 20));
        this.jContentPanel.add((Component)this.jOutputDirLabel, new XYConstraints(35, 95 + kelp, -1, -1));
        this.jContentPanel.add((Component)this.jOutputDirTextField, new XYConstraints(130, 95 + kelp, 290, 20));
        this.jContentPanel.add((Component)this.jOutputDirButton, new XYConstraints(430, 95 + kelp, 65, 20));
        this.jContentPanel.add((Component)this.jDomlRootLabel, new XYConstraints(35, 130 + kelp, -1, -1));
        this.jContentPanel.add((Component)this.jDomlTextField, new XYConstraints(130, 130 + kelp, 290, 20));
        this.jContentPanel.add((Component)this.jDomlButton, new XYConstraints(430, 130 + kelp, 65, 20));
        this.jContentPanel.add((Component)this.jDocLabel, new XYConstraints(35, 165 + kelp, -1, -1));
        this.jContentPanel.add((Component)this.jCheckBoxDoml2Html, new XYConstraints(132, 165 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jCheckBoxDoml2Pdf, new XYConstraints(212, 165 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jCheckBoxDoml2Xmi, new XYConstraints(292, 165 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jCheckBoxDoml2Ptl, new XYConstraints(372, 165 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jTemplateTypeLabel, new XYConstraints(35, 205 + kelp, -1, -1));
        this.jContentPanel.add((Component)this.jComboBoxTemplateSet, new XYConstraints(135, 205 + kelp, 165, 20));
        this.jContentPanel.add((Component)this.jCheckBoxForce, new XYConstraints(372, 205 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jVendorTypeLabel, new XYConstraints(35, 240 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jComboBoxVendors, new XYConstraints(135, 240 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jCheckBoxSQL, new XYConstraints(265, 240 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jCheckBoxSQLSplitter, new XYConstraints(372, 240 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jJavaLabel, new XYConstraints(35, 275 + kelp, -1, 20));
        this.jContentPanel.add((Component)this.jCheckBoxJava, new XYConstraints(135, 275 + kelp, -1, 20));
        if (!DefaultDODSWizard.getGenerator().getKelp()) {
            this.jContentPanel.add((Component)this.jCheckBoxCompile, new XYConstraints(265, 275 + kelp, -1, 20));
        }
        this.jButtonPanel.add((Component)this.jGenerateButton, null);
        this.jButtonPanel.add((Component)this.jSpace, null);
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            this.jButtonPanel.add((Component)this.jCloseButton, null);
            this.jButtonPanel.add((Component)this.jSpace1, null);
        }
        this.jButtonPanel.add((Component)this.jCancelButton, null);
        this.contentPane.add((Component)this.jPictPanel, "North");
        this.contentPane.add((Component)this.jButtonPanel, "South");
        this.jPictPanel.add((Component)this.jIconLabel, null);
        this.contentPane.add((Component)this.jContentPanel, "Center");
    }

    public void setDefaultFocus() {
        this.jGenerateButton.requestFocus();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            DefaultDODSWizard.getGenerator().preCancel();
            if (DefaultDODSWizard.getGenerator().getKelp()) {
                this.dispose();
            } else {
                System.exit(0);
            }
        }
    }

    void jCancelButton_actionPerformed(ActionEvent e) {
        DefaultDODSWizard.getGenerator().preCancel();
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    void jCloseButton_actionPerformed(ActionEvent e) {
        this.saveParameters();
        DefaultDODSWizard.getGenerator().preClose();
        this.dispose();
    }

    void jOutputDirButton_actionPerformed(ActionEvent e) {
        JFileChooser chooser = null;
        File choice = null;
        chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter((FileFilter)new DirectoryFilter());
        chooser.setDialogTitle("Select Project Root");
        chooser.setApproveButtonText("OK");
        String strFieldText = this.jDomlTextField.getText();
        if (strFieldText == null || strFieldText.equals("")) {
            strFieldText = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File(strFieldText));
        int v = chooser.showOpenDialog(this);
        this.requestFocus();
        switch (v) {
            case 0: {
                File parentFile;
                if (chooser.getSelectedFile() == null) break;
                choice = chooser.getSelectedFile().exists() ? chooser.getSelectedFile() : (parentFile = new File(chooser.getSelectedFile().getParent()));
                this.jOutputDirTextField.setText(choice.getPath());
                break;
            }
        }
        chooser.removeAll();
        chooser = null;
    }

    void jDomlButton_actionPerformed(ActionEvent e) {
        JFileChooser chooser = null;
        File choice = null;
        chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter((FileFilter)new DomlFilter());
        chooser.setDialogTitle("Select .doml file");
        chooser.setAcceptAllFileFilterUsed(false);
        String strFieldText = this.jDomlTextField.getText();
        if (strFieldText == null || strFieldText.equals("")) {
            strFieldText = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File(strFieldText));
        chooser.setApproveButtonText("OK");
        int v = chooser.showOpenDialog(this);
        this.requestFocus();
        block1 : switch (v) {
            case 0: {
                File parentFile;
                if (chooser.getSelectedFile() == null) break;
                choice = chooser.getSelectedFile().exists() ? chooser.getSelectedFile() : (parentFile = new File(chooser.getSelectedFile().getParent()));
                this.jDomlTextField.setText(choice.getPath());
                String tempSet = null;
                String vendor = null;
                try {
                    if (choice.isFile()) {
                        tempSet = XmlUtil.getSingleAttribute(choice.getPath(), "/doml/database@templateset", null);
                        vendor = XmlUtil.getSingleAttribute(choice.getPath(), "/doml/database@database", null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tempSet != null) {
                    tempSet = " " + tempSet;
                    for (int i = 0; i < this.jComboBoxTemplateSet.getItemCount(); ++i) {
                        if (!((String)this.jComboBoxTemplateSet.getItemAt(i)).equals(tempSet)) continue;
                        this.jComboBoxTemplateSet.setSelectedIndex(i);
                        break;
                    }
                }
                if (vendor == null) break;
                vendor = " " + vendor;
                for (int i = 0; i < this.jComboBoxVendors.getItemCount(); ++i) {
                    if (!((String)this.jComboBoxVendors.getItemAt(i)).equals(vendor)) continue;
                    this.jComboBoxVendors.setSelectedIndex(i);
                    break block1;
                }
                break;
            }
        }
        chooser.removeAll();
        chooser = null;
    }

    void jGenerateButton_actionPerformed(ActionEvent e) {
        try {
            File outDir = new File(this.jOutputDirTextField.getText());
            File dfile = new File(this.jDomlTextField.getText());
            if (dfile.isFile()) {
                if (!outDir.mkdirs() && !outDir.isDirectory()) {
                    MessageDialog message = new MessageDialog(" Please enter or choose valid project root directory file ", (Frame)this, " Invalid project root directory ");
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    message.setLocation((dimension.width - message.getSize().width) / 2, (dimension.height - message.getSize().height) / 2);
                    message.setVisible(true);
                    return;
                }
                this.saveParameters();
                DefaultDODSWizard.getGenerator().preGenerate();
                Common.setDomlFile((String)DefaultDODSWizard.getGenerator().getDoml());
                Common.setProjectRoot((String)DefaultDODSWizard.getGenerator().getOutputDir());
                Common.setConfigDir((String)DefaultDODSWizard.getGenerator().getConfigDir());
                ExecThread runEjen = new ExecThread();
                runEjen.start();
            } else {
                MessageDialog message = new MessageDialog(" Please enter or choose valid .doml file ", (Frame)this, " Invalid .doml file ");
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                message.setLocation((dimension.width - message.getSize().width) / 2, (dimension.height - message.getSize().height) / 2);
                message.setVisible(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void saveParameters() {
        DefaultDODSWizard.getGenerator().setOutputDir(this.jOutputDirTextField.getText());
        DefaultDODSWizard.getGenerator().setDoml(this.jDomlTextField.getText());
        DefaultDODSWizard.getGenerator().setConfigDir(this.jConfigDirTextField.getText());
        DefaultDODSWizard.getGenerator().setAction("dods:build_all");
        if (this.jCheckBoxSQL.isSelected() && !this.jCheckBoxSQLSplitter.isSelected() && !this.jCheckBoxJava.isSelected()) {
            DefaultDODSWizard.getGenerator().setAction("dods:sql");
        }
        if (this.jCheckBoxSQL.isSelected() && this.jCheckBoxSQLSplitter.isSelected() && !this.jCheckBoxJava.isSelected()) {
            DefaultDODSWizard.getGenerator().setAction("dods:sqlsplit");
        }
        if (!this.jCheckBoxSQL.isSelected() && this.jCheckBoxJava.isSelected()) {
            if (this.jCheckBoxCompile.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:java");
            } else {
                DefaultDODSWizard.getGenerator().setAction("dods:javaNoCompile");
            }
        }
        if (this.jCheckBoxSQL.isSelected() && this.jCheckBoxJava.isSelected()) {
            if (this.jCheckBoxCompile.isSelected() && !this.jCheckBoxSQLSplitter.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:build_all");
            } else if (this.jCheckBoxCompile.isSelected() && this.jCheckBoxSQLSplitter.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:build_all_split");
            } else if (!this.jCheckBoxCompile.isSelected() && !this.jCheckBoxSQLSplitter.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:noCompile");
            } else {
                DefaultDODSWizard.getGenerator().setAction("dods:noCompileSplit");
            }
        }
        if (this.jCheckBoxDoml2Html.isSelected()) {
            DefaultDODSWizard.getGenerator().setHtml(true);
        } else {
            DefaultDODSWizard.getGenerator().setHtml(false);
        }
        if (this.jCheckBoxDoml2Pdf.isSelected()) {
            DefaultDODSWizard.getGenerator().setPdf(true);
        } else {
            DefaultDODSWizard.getGenerator().setPdf(false);
        }
        if (this.jCheckBoxDoml2Xmi.isSelected()) {
            DefaultDODSWizard.getGenerator().setXmi(true);
        } else {
            DefaultDODSWizard.getGenerator().setXmi(false);
        }
        if (this.jCheckBoxDoml2Ptl.isSelected()) {
            DefaultDODSWizard.getGenerator().setPtl(true);
        } else {
            DefaultDODSWizard.getGenerator().setPtl(false);
        }
        if (this.jCheckBoxForce.isSelected()) {
            DefaultDODSWizard.getGenerator().setForce("true");
        } else {
            DefaultDODSWizard.getGenerator().setForce("false");
        }
        DefaultDODSWizard.getGenerator().setTemplateSet(((String)this.jComboBoxTemplateSet.getSelectedItem()).substring(1));
        if (!((String)this.jComboBoxVendors.getSelectedItem()).equals(" ")) {
            DefaultDODSWizard.getGenerator().setDatabase(((String)this.jComboBoxVendors.getSelectedItem()).substring(1));
        }
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            if (this.jCheckBoxInvoke.isSelected()) {
                DefaultDODSWizard.getGenerator().setInvoke(true);
            } else {
                DefaultDODSWizard.getGenerator().setInvoke(false);
            }
        }
    }

    void jCheckBoxSQL_actionPerformed(ActionEvent e) {
        if (this.jCheckBoxSQL.isSelected()) {
            this.jCheckBoxSQLSplitter.setSelected(true);
            this.jCheckBoxSQLSplitter.setEnabled(true);
        } else {
            this.jCheckBoxSQLSplitter.setSelected(true);
            this.jCheckBoxSQLSplitter.setSelected(false);
            this.jCheckBoxSQLSplitter.setEnabled(false);
            this.jCheckBoxJava.setSelected(true);
            if (!DefaultDODSWizard.getGenerator().getKelp()) {
                this.jCheckBoxCompile.setSelected(true);
            }
            this.jCheckBoxCompile.setEnabled(true);
        }
    }

    void jConfigDirButton_actionPerformed(ActionEvent e) {
        JFileChooser chooser = null;
        File choice = null;
        chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter((FileFilter)new DirectoryFilter());
        chooser.setDialogTitle("Select Config Dir");
        chooser.setApproveButtonText("OK");
        String strFieldText = Common.getConfigDir();
        if (strFieldText == null || strFieldText.equals("")) {
            strFieldText = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File(strFieldText));
        int v = chooser.showOpenDialog(this);
        this.requestFocus();
        switch (v) {
            case 0: {
                File confFile;
                if (chooser.getSelectedFile() == null) break;
                choice = chooser.getSelectedFile().exists() ? ((confFile = new File(chooser.getSelectedFile().getAbsolutePath() + File.separator + "dodsConf.xml")).exists() || confFile.isFile() ? chooser.getSelectedFile() : new File(Common.getConfigDir())) : new File(Common.getConfigDir());
                this.jConfigDirTextField.setText(choice.getPath());
                Common.setConfigDir((String)choice.getPath());
                break;
            }
        }
        chooser.removeAll();
        chooser = null;
        Set vendors = Common.getDodsConfVendorNames();
        String vendor2 = null;
        int i = 0;
        int selIndex = 0;
        this.jComboBoxVendors.removeAllItems();
        this.jComboBoxVendors.addItem(" ");
        for (String vendor2 : vendors) {
            this.jComboBoxVendors.addItem(" " + vendor2);
            if (vendor2.equals(DefaultDODSWizard.getGenerator().getDatabase())) {
                selIndex = i;
            }
            ++i;
        }
        this.jComboBoxVendors.setSelectedIndex(selIndex);
    }

    void jCheckBoxJava_actionPerformed(ActionEvent e) {
        if (this.jCheckBoxJava.isSelected()) {
            if (!DefaultDODSWizard.getGenerator().getKelp()) {
                this.jCheckBoxCompile.setSelected(true);
            }
            this.jCheckBoxCompile.setEnabled(true);
            this.jCheckBoxSQLSplitter.setEnabled(true);
        } else {
            this.jCheckBoxSQL.setSelected(true);
            this.jCheckBoxSQLSplitter.setEnabled(true);
            if (!DefaultDODSWizard.getGenerator().getKelp()) {
                this.jCheckBoxCompile.setSelected(false);
            }
            this.jCheckBoxCompile.setEnabled(false);
        }
    }
}

