/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.trans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.enhydra.dods.trans.Column;
import org.enhydra.dods.trans.DefaultTagValues;
import org.enhydra.dods.trans.Index;
import org.enhydra.dods.trans.InvalidDomlException;
import org.enhydra.dods.trans.Referrer;

public class Table {
    protected String pckg = null;
    protected String author = "NN";
    protected String project_name = "DODS Project";
    protected String table_name = null;
    protected String class_name = null;
    protected String db_vendor = DefaultTagValues.TABLE_DB_VENDOR;
    private static final String PARVALUE_COMPATIBLE = "Compatible";
    private static final String PARVALUE_DEPRECATE = "Deprecate";
    private static final String PARVALUE_OMIT = "Omit";
    protected String dirtyDOs = "Compatible";
    public static final String[] caching_value = new String[]{"none", "partial", "full", "lru"};
    public static final int NONE = 0;
    public static final int PARTIAL = 1;
    public static final int FULL = 2;
    public static final int LRU = 3;
    protected boolean do_is_oid_based = true;
    protected boolean do_secure = false;
    protected boolean do_insecure = true;
    protected boolean do_multidb = false;
    protected boolean is_abstract = false;
    protected boolean delete_cascade = false;
    protected boolean mass_updates = DefaultTagValues.MASS_UPDATES;
    protected boolean mass_deletes = DefaultTagValues.MASS_DELETES;
    protected ArrayList columns = new ArrayList();
    protected HashMap referrers = new HashMap();
    protected boolean isAnyColumnSecure = false;
    protected ArrayList indexes = new ArrayList();

    public Table(boolean genSecure, boolean genInsecure, String dirty) {
        this.do_secure = genSecure;
        this.do_insecure = genInsecure;
        if (this.dirtyDOs != null) {
            this.dirtyDOs = dirty;
        }
    }

    public Table() {
    }

    public String pckg() {
        return this.pckg;
    }

    public String author() {
        return this.author;
    }

    public String projectName() {
        return this.project_name;
    }

    public String tableName() {
        return this.table_name;
    }

    public String className() {
        return this.class_name;
    }

    public String dbVendor() {
        return this.db_vendor;
    }

    public boolean doIsOidBased() {
        return this.do_is_oid_based;
    }

    public boolean doSecure() {
        return this.do_secure;
    }

    public boolean doInSecure() {
        return this.do_insecure;
    }

    public boolean doMultidb() {
        return this.do_multidb;
    }

    public boolean doMassUpdates() {
        return this.mass_updates;
    }

    public boolean doMassDeletes() {
        return this.mass_deletes;
    }

    public boolean isAbstract() {
        return this.is_abstract;
    }

    public boolean isAnyColumnSecure() {
        return this.isAnyColumnSecure;
    }

    public boolean deleteCascade() {
        return this.delete_cascade;
    }

    public ArrayList columns() {
        return this.columns;
    }

    public int columnsSize() {
        return this.columns.size();
    }

    public Column column(int index) {
        return (Column)this.columns.get(index);
    }

    public HashMap referrers() {
        return this.referrers;
    }

    public int referrersSize() {
        return this.referrers.size();
    }

    public Iterator referrersIterator() {
        return this.referrers.entrySet().iterator();
    }

    public Iterator referrersKeyIterator() {
        return this.referrers.keySet().iterator();
    }

    public Iterator referrersValueIterator() {
        return this.referrers.values().iterator();
    }

    public Collection referrersValues() {
        return this.referrers.values();
    }

    public ArrayList indexes() {
        return this.indexes;
    }

    public int indexesSize() {
        return this.indexes.size();
    }

    public Index index(int index) {
        return (Index)this.indexes.get(index);
    }

    public void pckg(String pckg) {
        this.pckg = pckg;
    }

    public void author(String author) {
        this.author = author;
    }

    public void projectName(String project_name) {
        this.project_name = project_name;
    }

    public void tableName(String table_name) {
        this.table_name = table_name;
    }

    public void className(String class_name) {
        this.class_name = class_name;
    }

    public void dbVendor(String db_vendor) {
        this.db_vendor = db_vendor;
    }

    public void doIsOidBased(boolean do_is_oid_based) {
        this.do_is_oid_based = do_is_oid_based;
    }

    public void doSecure(boolean do_secure) {
        this.do_secure = do_secure;
    }

    public void doInSecure(boolean do_Insecure) {
        this.do_insecure = do_Insecure;
    }

    public void doMassUpdates(boolean do_mass) {
        this.mass_updates = do_mass;
    }

    public void doMassDeletes(boolean do_mass) {
        this.mass_deletes = do_mass;
    }

    public void doMultidb(boolean do_Multidb) {
        this.do_multidb = do_Multidb;
    }

    public void isAbstract(boolean is_abstract) {
        this.is_abstract = is_abstract;
    }

    public void anyColumnSecure(boolean value) {
        this.isAnyColumnSecure = value;
    }

    public void refConstarint(boolean delete_cascade) {
        this.delete_cascade = delete_cascade;
    }

    public void columns(ArrayList columns) {
        this.columns = columns;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void referrers(HashMap referrers) {
        this.referrers = referrers;
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    public void indexes(ArrayList indexes) {
        this.indexes = indexes;
    }

    public boolean addReferrer(Referrer referrer) {
        boolean inserted;
        String id = referrer.pckg() + "." + referrer.name();
        boolean bl = inserted = !this.referrers.containsKey(id);
        if (inserted) {
            this.referrers.put(id, referrer);
        }
        return inserted;
    }

    public void setDirtyDOs(String howToGenerate) throws InvalidDomlException {
        if (0 != howToGenerate.compareTo(PARVALUE_COMPATIBLE) && 0 != howToGenerate.compareTo(PARVALUE_DEPRECATE) && 0 != howToGenerate.compareTo(PARVALUE_OMIT)) {
            throw new InvalidDomlException("DirtyDOs out of range!");
        }
        this.dirtyDOs = howToGenerate;
    }

    public String getDirtyDOs() {
        return this.dirtyDOs;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("package=").append(this.pckg).append(" author=").append(this.author);
        ret.append(" project_name=").append(this.project_name).append(" table_name=").append(this.table_name);
        ret.append(" class_name=").append(this.class_name).append(" db_vendor=").append(this.db_vendor);
        ret.append(" do_is_oid_based=").append(this.do_is_oid_based).append(" is_abstract=").append(this.is_abstract);
        ret.append(" delete_cascade=").append(this.delete_cascade);
        ret.append(" do_secure=").append(this.do_secure);
        ret.append(" do_insecure=").append(this.do_insecure);
        ret.append("\ncolumns:\n");
        for (int i = 0; i < this.columns.size(); ++i) {
            ret.append("  column=").append(this.columns.get(i)).append("\n");
        }
        ret.append(":referrers:\n");
        Iterator iter = this.referrers.values().iterator();
        while (iter.hasNext()) {
            ret.append("  referrer=").append(iter.next()).append("\n");
        }
        ret.append("\nindexess:\n");
        for (int i = 0; i < this.indexes.size(); ++i) {
            ret.append("  index=").append(this.indexes.get(i)).append("\n");
        }
        return ret.toString();
    }

    public static void main(String[] args) {
        Table table = new Table();
        table.pckg("packag0.package1");
        table.tableName("Person");
        Column column1 = new Column();
        Column column2 = new Column();
        column1.name("name");
        column1.name("surname");
        table.addColumn(column1);
        table.addColumn(column2);
        Referrer referrer1 = new Referrer("package0.package1", "Person");
        referrer1.addAttribute("Manager", "package0.package1.Manager", false);
        referrer1.addAttribute("Employee", "package0.package1.Employee", false);
        Referrer referrer2 = new Referrer("package0.package1", "Manager");
        referrer2.addAttribute("Employee", "package0.package1.Employee", false);
        table.addReferrer(referrer1);
        table.addReferrer(referrer2);
        System.out.println("Table: \n" + table);
    }
}

