
/*
 * Title:        DODS Ant task
 * Description:  DODS
 */
package  org.enhydra.ant.taskdefs;

import java.io.File ;
import java.util.ArrayList ;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;

/**
 * @author Sinisa Milosevic
 * Invoke DODS to generate a set of java classes from a doml file
 * <p>The files will only be regenerated/compiled if the date on the doml file is
 * newer than at least one of the generated files
 * <p>This taskdef extends Ant's <javac> task; refer to that documentation for
 * parameters that affect compilation.
 * <p>Typically made visible to an Ant build file with the following declaration:<PRE>
 *  &lt;taskdef name="dods" classname="org.enhydra.ant.taskdefs.Dods"/&gt;</PRE>
 *
 * <B>Parameters</B><PRE>
 *
 * dir        - The base SQLSplitter directory. Required = Yes
 * resultsql  - Absolute path and base name of created sql files. Required = Yes
 * force      - Force SQLSplitter to always be regenerated source files. Required = No</PRE>
 * <p>
 * Examples<PRE>
 * &lt;sqlsplitter dir="${project.root}/sql"
 *        resultsql="${project.root}/Test.sql"/&gt;</PRE>
 *
 */
public class SQLSplitterTask extends org.apache.tools.ant.taskdefs.Javac {
    protected File  dir = null;
    protected File  resultsql = null;
    protected boolean forceBuild = false;
    protected boolean splitsqlprimary = true;
    public static class BooleanAttribute extends EnumeratedAttribute {

        /**
         *  Set value for Boolean parameters
         */
        public String [] getValues() {
            return (new String [] {"yes", "no", "true", "false" });
        }

        public BooleanAttribute() {}
    }
    public SQLSplitterTask() {
        dir = null;
        resultsql = null;
    }

    /**
     * Simply invoke DODS Generator, and then compile the generated files
     * @exception org.apache.tools.ant.BuildException
     */
    public void execute() throws org.apache.tools.ant.BuildException {
        if (dir == null) {
            throw new BuildException("dir attribute must be set!");
        }
        if (resultsql == null) {
            throw new BuildException("resultsql attribute must be set!");
        } else {
            int dirpos = -1;

            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                dirpos = resultsql.getAbsolutePath().lastIndexOf("\\");
            } else {
                dirpos = resultsql.getAbsolutePath().lastIndexOf("/");
            }   
            String  resultsqldir = null;
            String  beginfilename = null;

            if (dirpos != -1) {
                resultsqldir = resultsql.getAbsolutePath().substring(0, dirpos);
                String  sqlfilename = resultsql.getAbsolutePath().substring(dirpos
                        + 1);
                int pointpos = sqlfilename.indexOf(".sql");

                if (pointpos != -1) {
                    beginfilename = sqlfilename.substring(0, pointpos);
                } else {
                    beginfilename = sqlfilename;
                }   
            } else {
                resultsqldir = ".";
                int pointpos = resultsql.getAbsolutePath().indexOf(".sql");

                if (pointpos != -1) {
                    beginfilename = resultsql.getAbsolutePath().substring(0,
                            pointpos);
                } else {
                    beginfilename = resultsql.getAbsolutePath();
                }   
            }       
            String [] files = (new File (resultsqldir)).list();

            for (int i = 0; i < files.length; i++) {
                if ((files[i].startsWith(beginfilename))
                        && (files[i].endsWith(".sql"))) {
                    if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                        (new File (resultsqldir + "\\" + files[i])).delete();
                    } else {
                        (new File (resultsqldir + "/" + files[i])).delete();
                    }                            
                            
                }   
            }
                    
        }
                
        java.util.ArrayList  argsList = new ArrayList ();

        argsList.add(dir.getAbsolutePath());
        argsList.add(resultsql.getAbsolutePath());
        if(!splitsqlprimary){
            argsList.add("false");
        }                    
        try {
            String  splitterClassName = "org.webdocwf.util.sql.SQLSplitter";
            java.lang.reflect.Method  m = null;
            java.lang.Class  c = null;

            try {
                c = java.lang.Class.forName(splitterClassName);
                m = c.getMethod("main", new java.lang.Class [] {
                    String [].class
                });
            } catch (java.lang.Exception  e) {
                ((java.lang.Throwable ) (e)).printStackTrace();
                throw new BuildException(((java.lang.Throwable ) (e)));
            }
            String  args[] = (String []) argsList.toArray(((java.lang.Object []) (
                    new String [argsList.size()])));
                    
            if (m != null) {
                m.invoke(((java.lang.Object ) (null)), new java.lang.Object [] {
                    args
                });
            }
        } catch (java.lang.reflect.InvocationTargetException  ite) {
            ite.printStackTrace();
            throw new BuildException(((java.lang.Throwable ) (ite)));
        } catch (java.lang.Exception  e) {
            ((java.lang.Throwable ) (e)).printStackTrace();
            throw new BuildException(((java.lang.Throwable ) (e)));
        }

        /* org.apache.tools.ant.taskdefs.Touch touch = new Touch();
         ((org.apache.tools.ant.ProjectComponent)(touch)).setProject((this).project);
         touch.setFile(resultsql);
         touch.execute();
         */ 
    }

    /**
     * 
     * @param sqlDir New sql dir.
     */
    public void setDir(File  sqlDir) {
        this.dir = sqlDir;
    }

    /**
     * The destination directory into which the generated sources are written
     * @param sqlBase - Target for generated classes, expressed as a directory
     * path
     */
    public void setResultsql(File  sqlBase) {
        this.resultsql = sqlBase;
    }
    
    /**
     * Force DODS to split PRIMARY KEY statments from CREATE TABLE in separate file
     * during of SQLSpliter task.
     * @param splitPrimary - Set to "true" or "false"
     */
    public void setSplitsqlprimary(String  splitPrimary) {
        this.splitsqlprimary = (new Boolean (splitPrimary)).booleanValue();
    }
    
    /**
     * Force DODS to always be regenerated source files
     * @param force - Set to "true" or "false"
     */
    public void setForce(String  force) {
        forceBuild = (new Boolean (force)).booleanValue();
    }
}
