/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.ant.taskdefs;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Touch;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.enhydra.dods.Common;

public class DODS_XMLBuilder
extends Javac {
    protected File domlFile = null;
    protected File sourceoutDir = null;
    protected String database = null;
    protected boolean forceBuild = false;
    protected boolean tablesOnly = false;
    protected String configDir = null;

    public void execute() throws BuildException {
        boolean regen;
        try {
            if (this.configDir != null) {
                Common.setConfigDir((String)this.configDir);
            }
        }
        catch (Error e) {
            throw new BuildException("path to dodsConf.xml must be valid");
        }
        if (this.domlFile == null) {
            throw new BuildException("doml attribute must be set!");
        }
        if (this.sourceoutDir == null) {
            throw new BuildException("outdir attribute must be set!");
        }
        if (!this.sourceoutDir.isDirectory()) {
            throw new BuildException("outdir must be a valid directory!");
        }
        File domlTmp = null;
        if (domlTmp == null) {
            String s = this.domlFile.getAbsolutePath().toLowerCase();
            int i = s.indexOf(".doml");
            domlTmp = i > -1 ? new File(this.domlFile.getAbsolutePath().substring(0, i) + ".uptodate") : new File(this.domlFile.getAbsolutePath() + ".uptodate");
        }
        boolean bl = regen = !this.sourceoutDir.exists() || !domlTmp.exists() || domlTmp.lastModified() < this.domlFile.lastModified();
        if (regen) {
            this.project.log("Regenerating DODS files from " + this.domlFile + "... ");
        } else {
            this.project.log(String.valueOf(this.domlFile) + " up to date.", 2);
        }
        if (regen || this.forceBuild) {
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add(new Boolean(this.tablesOnly).toString());
            if (this.database != null) {
                argsList.add(this.database);
            }
            try {
                String dodsClassName = "org.enhydra.dods.trans.TransientXMLBuilderFactory";
                Method m = null;
                Class<?> c = null;
                try {
                    c = Class.forName(dodsClassName);
                    m = c.getMethod("main", String[].class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BuildException((Throwable)e);
                }
                String[] args = (String[])argsList.toArray((Object[])new String[argsList.size()]);
                if (m != null) {
                    m.invoke(null, new Object[]{args});
                }
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
                throw new BuildException((Throwable)ite);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
            if (!this.tablesOnly) {
                Touch touch = new Touch();
                touch.setProject(this.project);
                touch.setFile(domlTmp);
                touch.execute();
            }
        }
    }

    public void setDoml(File domlFile) {
        this.domlFile = domlFile;
    }

    public void setOutdir(File sourceout) {
        this.sourceoutDir = sourceout;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTablesonly(boolean isTablesOnly) {
        this.tablesOnly = isTablesOnly;
    }

    public void setForce(String force) {
        this.forceBuild = new Boolean(force);
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String string) {
        this.configDir = string;
    }

    public static class BooleanAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"yes", "no", "true", "false"};
        }
    }
}

