
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: DomlValidateTask.java,v 1.1 2004/09/03 13:43:13 sinisa Exp $
 */

/*
 *
 * @author    Nenad Vico
 * @since     LBS1.8
 * @version   $Revision: 1.1 $
 *
 */
package org.enhydra.ant.taskdefs;

import java.io.File ;
import java.io.FileNotFoundException ;
import java.io.IOException ;
import java.util.Properties ;
import javax.xml.transform.OutputKeys ;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.enhydra.dods.xml.XmlUtil;
import org.enhydra.dods.xml.XmlUtilException;

/**
 * This class represent task for tarnsformation doml file for validation. 
 */
public class DomlValidateTask extends Task {
    
    private String  doml;
    private String  projRoot;
    private String  template;
    private String  force;

    /**
     * constructor with index id and unique
     */
    public DomlValidateTask() {}

    /**
     *  The setter for the "doml" attribute
     *
     */
    public void setDoml(String  doml) {
        this.doml = doml;
    }
  
    /**
     * The setter for the "projRoot" attribute
     *
     */
    public void setProjRoot(String  projRoot) {
        this.projRoot = projRoot;
    }
    
    /**
     * The setter for the "template" attribute
     *
     */
    public void setTemplate(String  temp) {
        this.template = temp;
    }

    /**
     * The setter for the "force" attribute
     *
     */
    public void setForce(String  force) {
        this.force = force;
    }

    public void execute() throws BuildException {
        try {
            if (doml == null) {
                doml = getDomlFile();
            }
            if (projRoot == null) {
                projRoot = getProjectRoot();
            }
            if (template == null) {
                template = "standard";
            }
            copyDoml();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }
    
    public void copyDoml() throws FileNotFoundException , IOException  {
        File  domlFile = new File (doml);

        if (!domlFile.exists()) {
            throw new FileNotFoundException (doml + " file not found");
        }
        File  projFile = new File (projRoot); 

        if (!projFile.exists()) {
            throw new FileNotFoundException (projRoot + " not found");
        }
        try {
            if (!force.equals("true")) { // not forcing output
 int dotIndex = doml.indexOf(".");
                String  update = projRoot
                        + doml.substring(doml.lastIndexOf(File.separator),
                                doml.lastIndexOf(".")) + ".uptodate";
                File  updateFile = new File (update);

                if (domlFile.lastModified() < updateFile.lastModified()) {
                    return;
                }
            }
        } catch (StringIndexOutOfBoundsException  ex) {}
        Properties  prop = new Properties ();

        prop.setProperty(OutputKeys.DOCTYPE_SYSTEM,
                "file:///" + System.getProperty("DODS_HOME") + File.separator
                + "build" + File.separator + "dtd" + File.separator + "doml.dtd");
        prop.setProperty(OutputKeys.VERSION, "1.0");
        prop.setProperty(OutputKeys.ENCODING, "UTF-8");
        prop.setProperty(OutputKeys.STANDALONE, "no");
        try {
            XmlUtil xmlUtil = new XmlUtil(doml);

            xmlUtil.setSingleAttribute("/doml/database@templateset", null,
                    template);
            xmlUtil.store(projRoot + File.separator + domlFile.getName(), prop);
        } catch (XmlUtilException e) {
            e.printStackTrace();
        }
    }

    /**
     * get uses project root
     * @return project root
     */
    public static String  getProjectRoot() {
        String  projectRoot = null;

        projectRoot = System.getProperty("PROJECT_ROOT");       
        if (projectRoot == null) {
            projectRoot = ".";
        }
        return projectRoot;
    }
 
    /**
     * get uses doml file
     * @return uses doml file
     */
    public static String  getDomlFile() {
        String  strDoml = null;

        strDoml = System.getProperty("DOML_FILE");      
        String  domlFile = null;

        if (strDoml == null) {
            File  current = new File (".");
            String [] files = current.list();

            out:
            for (int i = 0; i < files.length; i++) {
                if (files[i].toLowerCase().endsWith(".doml")) {
                    domlFile = files[i];
                    break out;
                } else {
                    domlFile = null;
                }       
            }
            strDoml = domlFile;     
        }   
        return strDoml;
    }

    public static void main(String [] args) {
        DomlValidateTask validate = new DomlValidateTask();

        try {
            validate.copyDoml();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }
}
