/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.xslt;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Vector;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.ejen.util.XSLUtil;
import org.enhydra.dods.Common;

public class XSLTUtil {
    public String strVectorValues_1 = new String();
    public String strVectorValues_2 = new String();
    public String strVectorValues_3 = new String();
    public String strVectorValues_4 = new String();
    public static String strAttribut_0 = new String();
    public static String strAttribut_1 = new String();
    public String strAttribut_11 = new String();
    public static String strAttribut_2 = new String();
    public static String strAttribut_3 = new String();
    public static String strAttribut_4 = new String();
    public static String strAttribut_5 = new String();
    public static Vector vecDropPrimaryKey = new Vector();
    public static Vector vecDropUnique = new Vector();
    public static Vector vecDropIndex = new Vector();
    public static Vector vecDropTable = new Vector();
    public static Vector vecXSLUtil_01 = new Vector();
    public static Vector vecXSLUtilDrop_01 = new Vector();
    public static Vector vecXSLUtilDrop_11 = new Vector();
    public static Vector vecFKcreate_01 = new Vector();
    public static Vector vecFKdrop_01 = new Vector();
    public static Vector vecXSLUtil_02 = new Vector();
    public static Vector vecXSLUtilDrop_02 = new Vector();
    public static Vector vecXSLUtilDrop_12 = new Vector();
    public static Vector vecFKcreate_02 = new Vector();
    public static Vector vecFKdrop_02 = new Vector();
    public static Vector vecXSLUtil_11 = new Vector();
    public static Vector vecXSLUtil_12 = new Vector();
    public static Vector vecXSLUtil_2 = new Vector();
    public static Vector vecXSLUtil_3 = new Vector();
    public static Vector vecXSLUtil_41 = new Vector();
    public static Vector vecXSLUtil_42 = new Vector();
    public static Vector vecXSLUtil_5 = new Vector();
    public static String strPathProjectRoot = new String();
    public static String strPathDomlFile = new String();
    public static String strPathDodsConf = new String();
    public static String strPathTypesConf = new String();
    public static String strDatabase = new String();
    private static final int minKeyLength = 4;
    private static final int maxCounterLength = 3;
    private static HashMap counterMap = new HashMap();
    private static HashMap nameMap = new HashMap();
    public static String dbVendorName = "Standard";

    protected XSLTUtil() {
    }

    public static java.util.Date str2date(String s) {
        String[] formats = new String[]{"yyyy-MM-dd H:mm:ss a", "yyyy MM dd H:mm:ss a", "yyyy-MM-dd H:mm:ss", "yyyy MM dd H:mm:ss", "yyyy-MM-dd H:mm a", "yyyy MM dd H:mm a", "yyyy-MM-dd H:mm", "yyyy MM dd H:mm", "yyyy-MM-dd", "yyyy MM dd", "MMM dd yyyy h:mm:ss a", "MMM dd, yyyy h:mm:ss a", "MMM dd yyyy h:mm:ss", "MMM dd, yyyy h:mm:ss", "MMM dd yyyy h:mm a", "MMM dd, yyyy h:mm a", "MMM dd yyyy h:mm", "MMM dd, yyyy h:mm"};
        java.util.Date ret = null;
        for (int i = 0; i < formats.length; ++i) {
            SimpleDateFormat df = new SimpleDateFormat(formats[i]);
            try {
                ret = df.parse(s);
                break;
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return ret;
    }

    public static String fixDefault(String type, String value) {
        String defaultValue;
        String fixedValue;
        block80: {
            if (null == value) {
                value = "";
            }
            fixedValue = value;
            defaultValue = null;
            if (type.endsWith("DO")) {
                fixedValue = "null";
            } else if (type.equals("String")) {
                fixedValue = fixedValue.length() == 0 ? "null" : "\"" + value + "\"";
            } else if (type.equals("java.math.BigDecimal")) {
                if (value.length() == 0) {
                    fixedValue = "null";
                } else {
                    try {
                        BigDecimal test = new BigDecimal(fixedValue);
                        fixedValue = "new " + type + "(" + fixedValue + ")";
                    }
                    catch (RuntimeException e) {
                        defaultValue = "null";
                    }
                }
            } else if (type.equals("java.sql.Date")) {
                if (value.length() == 0) {
                    fixedValue = "null";
                } else {
                    try {
                        java.util.Date d = XSLTUtil.str2date(fixedValue);
                        Date test = new Date(d.getTime());
                        fixedValue = "new " + type + "(" + fixedValue + ")";
                    }
                    catch (RuntimeException e) {
                        defaultValue = "null";
                    }
                }
            } else if (type.equals("java.sql.Time")) {
                if (value.length() == 0) {
                    fixedValue = "null";
                } else {
                    try {
                        java.util.Date d = XSLTUtil.str2date(fixedValue);
                        Time test = new Time(d.getTime());
                        fixedValue = "new " + type + "(" + fixedValue + ")";
                    }
                    catch (RuntimeException e) {
                        defaultValue = "null";
                    }
                }
            } else if (type.equals("java.sql.Timestamp")) {
                if (value.length() == 0) {
                    fixedValue = "null";
                } else {
                    try {
                        java.util.Date d = XSLTUtil.str2date(fixedValue);
                        Timestamp test = new Timestamp(d.getTime());
                        fixedValue = "new " + type + "(" + fixedValue + ")";
                    }
                    catch (RuntimeException e) {
                        defaultValue = "null";
                    }
                }
            } else if (type.equals("int")) {
                if (value.length() == 0) {
                    fixedValue = "0";
                } else {
                    try {
                        int e = Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        defaultValue = "0";
                    }
                }
            } else if (type.equals("boolean")) {
                if (value.length() == 0) {
                    fixedValue = "false";
                } else {
                    try {
                        if (Boolean.valueOf(value).booleanValue()) {
                            fixedValue = "true";
                            break block80;
                        }
                        fixedValue = "false";
                    }
                    catch (Exception e) {
                        defaultValue = "false";
                    }
                }
            } else if (type.equals("float")) {
                if (value.length() == 0) {
                    fixedValue = "0f";
                } else {
                    try {
                        Float.valueOf(value);
                        if (!value.endsWith("f")) {
                            fixedValue = value + "f";
                        }
                    }
                    catch (Exception e) {
                        defaultValue = "0f";
                    }
                }
            } else if (type.equals("byte")) {
                if (value.length() == 0) {
                    fixedValue = "0";
                } else {
                    try {
                        Byte.parseByte(value);
                    }
                    catch (Exception e) {
                        defaultValue = "0";
                    }
                }
            } else if (type.equals("short")) {
                if (value.length() == 0) {
                    fixedValue = "0";
                } else {
                    try {
                        Short.parseShort(value);
                    }
                    catch (Exception e) {
                        defaultValue = "0";
                    }
                }
            } else if (type.equals("long")) {
                if (value.length() == 0) {
                    fixedValue = "0L";
                } else {
                    try {
                        Long.parseLong(value);
                        if (!value.endsWith("L")) {
                            fixedValue = value + "L";
                        }
                    }
                    catch (Exception e) {
                        defaultValue = "0L";
                    }
                }
            } else if (type.equals("double")) {
                if (value.length() == 0) {
                    fixedValue = "0d";
                } else {
                    try {
                        Double.valueOf(value);
                        if (!value.endsWith("d")) {
                            fixedValue = value + "d";
                        }
                    }
                    catch (Exception e) {
                        defaultValue = "0d";
                    }
                }
            } else if (type.equals("byte[]")) {
                try {
                    defaultValue = "{0}";
                }
                catch (RuntimeException runtimeException) {}
            } else {
                defaultValue = "null";
            }
        }
        if (null != defaultValue) {
            fixedValue = defaultValue;
        }
        return fixedValue;
    }

    public static String adjustJavaType(String type) {
        if (type.startsWith("root.")) {
            return type.substring(5);
        }
        return type;
    }

    public static String getAdjustedPackageName(String pckg) {
        if (pckg.startsWith("root.")) {
            return pckg.substring(5);
        }
        return pckg;
    }

    public static String cloneValue(String name, String javaType, String isObjectRef) throws Exception {
        String type = XSLTUtil.adjustJavaType(javaType);
        String retClone = null;
        String primitiveTypes = ":boolean:char:byte:short:int:long:float:double:";
        String timeTypes = ":java.sql.Date:java.sql.Time:java.sql.Timestamp:";
        if (-1 != primitiveTypes.indexOf(":" + type + ":")) {
            retClone = name;
        } else if (-1 != timeTypes.indexOf(":" + type + ":")) {
            String shortType = type.substring(type.lastIndexOf(46) + 1);
            retClone = "GenericDO.copy" + shortType + "(" + name + ")";
        } else {
            retClone = type.equals("String") ? "GenericDO.copyString(" + name + ")" : (type.equals("byte[]") ? "GenericDO.copyByteArray(" + name + ")" : (type.equals("java.math.BigDecimal") ? "GenericDO.copyBigDecimal(" + name + ")" : (isObjectRef.equals("true") ? type + ".createCopy( " + name + " )" : "(" + type + ") " + name + ".clone()")));
        }
        return retClone;
    }

    public static String capitalizeJavaBasicObject(String type) throws Exception {
        String javaType = type;
        String primitiveTypes = ":boolean:char:byte:short:int:long:float:double:";
        if (-1 != primitiveTypes.indexOf(":" + type + ":")) {
            javaType = Common.capitalizeName((String)type);
        }
        return javaType;
    }

    public static String javaType(String type) {
        String jt = type.replace('.', '_');
        return XSLTUtil.convertArrayType(jt);
    }

    public static String jdbcType(String javaType) {
        String type = javaType;
        int dot = type.lastIndexOf(46);
        if (-1 != dot) {
            type = type.substring(dot + 1);
        }
        String firstChar = type.substring(0, 1).toUpperCase();
        return XSLTUtil.convertArrayType(firstChar + type.substring(1));
    }

    public static String convertArrayType(String type) {
        String at = type;
        int i = type.indexOf("[]");
        if (-1 != i) {
            at = type.substring(0, i) + "s";
        }
        return at;
    }

    public static void createVector(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        vecDropPrimaryKey.clear();
        vecDropUnique.clear();
        vecDropIndex.clear();
        vecDropTable.clear();
        vecFKcreate_01.clear();
        vecFKcreate_02.clear();
        vecFKdrop_01.clear();
        vecFKdrop_02.clear();
        vecXSLUtil_01.clear();
        vecXSLUtil_02.clear();
        vecXSLUtilDrop_01.clear();
        vecXSLUtilDrop_11.clear();
        vecXSLUtilDrop_02.clear();
        vecXSLUtilDrop_12.clear();
        vecXSLUtil_11.clear();
        vecXSLUtil_12.clear();
        vecXSLUtil_2.clear();
        vecXSLUtil_3.clear();
        vecXSLUtil_41.clear();
        vecXSLUtil_42.clear();
        vecXSLUtil_5.clear();
    }

    public static void resetCreateVectors(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        vecFKcreate_01.clear();
        vecFKcreate_02.clear();
        vecXSLUtil_01.clear();
        vecXSLUtil_02.clear();
        vecXSLUtil_11.clear();
        vecXSLUtil_12.clear();
        vecXSLUtil_2.clear();
        vecXSLUtil_3.clear();
        vecXSLUtil_41.clear();
        vecXSLUtil_42.clear();
        vecXSLUtil_5.clear();
    }

    public static void fillVector(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        String s51;
        XObject obj0 = null;
        XObject obj1 = null;
        XObject obj2 = null;
        XObject obj3 = null;
        XObject obj4 = null;
        XString obj5 = null;
        String s0 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribut0", (boolean)false);
        String s1 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribut1", (boolean)false);
        String s2 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribut2", (boolean)false);
        String s3 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribut3", (boolean)false);
        String s4 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribut4", (boolean)false);
        String s5 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribut5", (boolean)false);
        int i = 0;
        String strTemp = new String();
        obj5 = new XString("");
        if (s5 != null && (obj5 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s5)) != null && (s51 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribute5", (boolean)false)) != null) {
            obj5 = new XString(s51);
        }
        if (s0 != null) {
            obj0 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s0);
            if (obj0 == null) {
                throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
            }
        } else {
            String s01 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribute0", (boolean)false);
            if (s01 != null) {
                obj0 = new XString(s01);
            }
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        }
        if (s1 != null) {
            obj1 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s1);
            if (obj1 == null) {
                throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
            }
        } else {
            String s11 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribute1", (boolean)false);
            if (s11 != null) {
                obj1 = new XString(s11);
            }
        }
        if (obj1 == null) {
            obj1 = new XString("(no value)");
        }
        if (s2 != null) {
            obj2 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s2);
            if (obj2 == null) {
                throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
            }
        } else {
            String s21 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribute2", (boolean)false);
            if (s21 != null) {
                obj2 = new XString(s21);
            }
        }
        if (obj2 == null) {
            obj2 = new XString("(no value)");
        }
        if (s3 != null) {
            obj3 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s3);
            if (obj3 == null) {
                throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
            }
        } else {
            String s31 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribute3", (boolean)false);
            if (s31 != null) {
                obj3 = new XString(s31);
            }
        }
        if (obj3 == null) {
            obj3 = new XString("(no value)");
        }
        if (s4 != null) {
            obj4 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s4);
            if (obj4 == null) {
                throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
            }
        } else {
            String s41 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"attribute4", (boolean)false);
            if (s41 != null) {
                obj4 = new XString(s41);
            }
        }
        if (obj4 == null) {
            obj4 = new XString("(no value)");
        } else {
            strAttribut_0 = obj0.toString();
            strAttribut_1 = obj1.toString();
            strAttribut_2 = obj2.toString();
            strAttribut_3 = obj3.toString();
            strAttribut_4 = obj4.toString();
            strAttribut_5 = obj5.toString();
            if (strAttribut_3.length() == 0) {
                strAttribut_3 = strAttribut_5.equalsIgnoreCase("") ? XSLTUtil.getDodsProperty("OidDbColumnName") : XSLTUtil.getDodsProperty("OidDbColumnName", strAttribut_5);
            }
            if (strAttribut_2.length() != 0 && strAttribut_4.length() == 0) {
                vecXSLUtil_01.addElement(strAttribut_0);
                vecXSLUtil_11.addElement(strAttribut_1);
                vecXSLUtilDrop_01.addElement(strAttribut_0);
                vecXSLUtilDrop_11.addElement(strAttribut_1);
                vecXSLUtil_2.addElement(strAttribut_2);
                vecXSLUtil_41.addElement(strAttribut_3);
            }
            if (strAttribut_2.length() != 0 && strAttribut_4.length() != 0) {
                if (!vecXSLUtil_5.contains(strAttribut_4)) {
                    vecXSLUtil_02.addElement(strAttribut_0);
                    vecXSLUtilDrop_02.addElement(strAttribut_0);
                    vecXSLUtilDrop_12.addElement(strAttribut_1);
                    vecXSLUtil_12.addElement(strAttribut_1);
                    vecXSLUtil_3.addElement(strAttribut_2);
                    vecXSLUtil_42.addElement(strAttribut_3);
                    vecXSLUtil_5.addElement(strAttribut_4);
                } else {
                    i = vecXSLUtil_5.indexOf(strAttribut_4);
                    strTemp = vecXSLUtil_12.elementAt(i).toString();
                    strTemp = strTemp + ", " + strAttribut_1;
                    vecXSLUtil_12.setElementAt(strTemp, i);
                    strTemp = vecXSLUtil_42.elementAt(i).toString();
                    strTemp = strTemp + ", " + strAttribut_3;
                    vecXSLUtil_42.setElementAt(strTemp, i);
                }
            }
        }
    }

    public static void fillVecDropPrimaryKey(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        Object obj0 = null;
        XObject obj1 = null;
        XObject obj2 = null;
        String s0 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"tableName", (boolean)false);
        String s1 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"vendorName", (boolean)false);
        String s2 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"columnName", (boolean)false);
        if (s2 != null && (obj2 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s2)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad database vendor attribute ?!"));
        }
        if (obj2 == null) {
            obj2 = new XString("(no value)");
        }
        if (s1 != null && (obj1 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s1)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad database vendor attribute ?!"));
        }
        if (obj1 == null) {
            obj1 = new XString("Standard");
        }
        if (s0 != null && (obj0 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s0)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        } else {
            String strTableName = obj0.toString();
            String strVendorName = obj1.toString();
            String strColumnName = obj2.toString();
            String strTmp = "ALTER TABLE " + strTableName + " DROP CONSTRAINT " + XSLTUtil.returnFixedConstraintName(strTableName, strColumnName, "DROP", "PK", strTableName, strColumnName, strVendorName) + " ;";
            vecDropPrimaryKey.addElement(strTmp);
        }
    }

    public static void fillVecDropUnique(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        Object obj0 = null;
        XObject obj1 = null;
        XObject obj2 = null;
        String s2 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"columnName", (boolean)false);
        String s0 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"tableName", (boolean)false);
        String s1 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"vendorName", (boolean)false);
        if (s2 != null && (obj2 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s2)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad database vendor attribute ?!"));
        }
        if (obj2 == null) {
            obj2 = new XString("(no value)");
        }
        if (s1 != null && (obj1 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s1)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad database vendor attribute ?!"));
        }
        if (obj1 == null) {
            obj1 = new XString("Standard");
        }
        if (s0 != null && (obj0 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s0)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        } else {
            String strTableName = obj0.toString();
            String strVendorName = obj1.toString();
            String strColumnName = obj2.toString();
            String strTmp = "ALTER TABLE " + strTableName + " DROP CONSTRAINT " + XSLTUtil.returnFixedConstraintName(strTableName, strColumnName, "DROP", "U", strTableName, strColumnName, strVendorName) + " ;";
            vecDropUnique.addElement(strTmp);
        }
    }

    public static void fillVecDropIndex(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        XObject obj0 = null;
        XObject obj1 = null;
        XObject obj2 = null;
        String s0 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"tableName", (boolean)false);
        String s1 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"indexName", (boolean)false);
        String s2 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"vendorName", (boolean)false);
        if (s2 != null && (obj2 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s2)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad database vendor attribute ?!"));
        }
        if (obj2 == null) {
            obj2 = new XString("Standard");
        }
        if (s0 != null && (obj0 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s0)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        }
        if (s1 != null && (obj1 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s1)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
        }
        if (obj1 == null) {
            obj1 = new XString("(no value)");
        } else {
            String strTableName = obj0.toString();
            String strIndexName = obj1.toString();
            String strVendorName = obj2.toString();
            String strTmp = "DROP INDEX " + XSLTUtil.returnFixedConstraintName(strTableName, strIndexName, "DROP", "I", strTableName, strIndexName, strVendorName) + " ;";
            vecDropIndex.addElement(strTmp);
        }
    }

    public static void fillVecDropTable(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        XObject obj0 = null;
        String s0 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"tableName", (boolean)false);
        if (s0 != null && (obj0 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s0)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        } else {
            String strTmp = "DROP TABLE " + obj0.toString() + " ;";
            vecDropTable.addElement(strTmp);
        }
    }

    public static String returnForeignKeyConstraints(String dbVendor) throws Exception {
        String strTemp11 = new String();
        String strTemp41 = new String();
        String strTemp = "";
        boolean delCascade = Common.getDodsConfProperty((String)"DeleteCascade", (String)dbVendor).equalsIgnoreCase("true");
        String keyLengthStr = Common.getDodsConfProperty((String)"ConstraintNameLength", (String)dbVendor);
        String tempName = null;
        int keyLength = -1;
        if (keyLengthStr != null) {
            keyLength = new Integer(keyLengthStr);
        }
        int i = 0;
        int j = 0;
        if (vecXSLUtil_01.size() > 0) {
            i = 0;
            tempName = XSLTUtil.returnFixedConstraintName(vecXSLUtil_01.elementAt(i).toString(), vecXSLUtil_11.elementAt(i).toString(), "CREATE", "FK", vecXSLUtil_01.elementAt(i).toString(), vecXSLUtil_11.elementAt(i).toString(), dbVendor);
            strTemp = "    CONSTRAINT " + tempName + " FOREIGN KEY (" + vecXSLUtil_11.elementAt(i).toString() + ") REFERENCES " + vecXSLUtil_2.get(i).toString() + " (" + vecXSLUtil_41.get(i).toString() + ")";
            strTemp = delCascade ? strTemp + " ON DELETE CASCADE ,\n" : strTemp + " ,\n";
            vecFKcreate_01.addElement(strTemp);
            j = 2;
            for (i = 1; i < vecXSLUtil_01.size(); ++i) {
                strTemp = vecXSLUtil_01.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtil_01.elementAt(i).toString())) {
                    tempName = XSLTUtil.returnFixedConstraintName(vecXSLUtil_01.elementAt(i).toString(), vecXSLUtil_11.elementAt(i).toString(), "CREATE", "FK", vecXSLUtil_01.elementAt(i).toString(), vecXSLUtil_11.elementAt(i).toString(), dbVendor);
                    strTemp = "    CONSTRAINT " + tempName + " FOREIGN KEY (" + vecXSLUtil_11.elementAt(i).toString() + ") REFERENCES " + vecXSLUtil_2.get(i).toString() + " (" + vecXSLUtil_41.get(i).toString() + ")";
                    strTemp = delCascade ? strTemp + " ON DELETE CASCADE ,\n" : strTemp + " ,\n";
                    vecFKcreate_01.addElement(strTemp);
                } else {
                    j = 1;
                    tempName = XSLTUtil.returnFixedConstraintName(vecXSLUtil_01.elementAt(i).toString(), vecXSLUtil_11.elementAt(i).toString(), "CREATE", "FK", vecXSLUtil_01.elementAt(i).toString(), vecXSLUtil_11.elementAt(i).toString(), dbVendor);
                    strTemp = "    CONSTRAINT " + tempName + " FOREIGN KEY (" + vecXSLUtil_11.elementAt(i).toString() + ") REFERENCES " + vecXSLUtil_2.get(i).toString() + " (" + vecXSLUtil_41.get(i).toString() + ")";
                    strTemp = delCascade ? strTemp + " ON DELETE CASCADE ,\n" : strTemp + " ,\n";
                    vecFKcreate_01.addElement(strTemp);
                }
                ++j;
            }
        }
        if (vecXSLUtil_02.size() > 0) {
            i = 0;
            tempName = XSLTUtil.returnFixedConstraintName("FKG", vecXSLUtil_02.elementAt(i).toString(), "CREATE", "FKG", "FKG", vecXSLUtil_02.elementAt(i).toString(), dbVendor);
            strTemp = "    CONSTRAINT " + tempName + " FOREIGN KEY (" + vecXSLUtil_12.elementAt(i).toString() + ") REFERENCES " + vecXSLUtil_3.get(i).toString() + " (" + vecXSLUtil_42.get(i).toString() + ")";
            strTemp = delCascade ? strTemp + " ON DELETE CASCADE ,\n" : strTemp + " ,\n";
            vecFKcreate_02.addElement(strTemp);
            j = 2;
            for (i = 1; i < vecXSLUtil_02.size(); ++i) {
                strTemp = vecXSLUtil_02.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtil_02.elementAt(i).toString())) {
                    tempName = XSLTUtil.returnFixedConstraintName("FKG", vecXSLUtil_02.elementAt(i).toString(), "CREATE", "FKG", "FKG", vecXSLUtil_02.elementAt(i).toString(), dbVendor);
                    strTemp = "    CONSTRAINT " + tempName + " FOREIGN KEY (" + vecXSLUtil_12.elementAt(i).toString() + ") REFERENCES " + vecXSLUtil_3.get(i).toString() + " (" + vecXSLUtil_42.get(i).toString() + ")";
                    strTemp = delCascade ? strTemp + " ON DELETE CASCADE ,\n" : strTemp + " ,\n";
                    vecFKcreate_02.addElement(strTemp);
                } else {
                    j = 1;
                    tempName = XSLTUtil.returnFixedConstraintName("FKG", vecXSLUtil_02.elementAt(i).toString(), "CREATE", "FKG", "FKG", vecXSLUtil_02.elementAt(i).toString(), dbVendor);
                    strTemp = "    CONSTRAINT " + tempName + "_" + j + " FOREIGN KEY (" + vecXSLUtil_12.elementAt(i).toString() + ") REFERENCES " + vecXSLUtil_3.get(i).toString() + " (" + vecXSLUtil_42.get(i).toString() + ")";
                    strTemp = delCascade ? strTemp + " ON DELETE CASCADE ,\n" : strTemp + " ,\n";
                    vecFKcreate_02.addElement(strTemp);
                }
                ++j;
            }
        }
        int i_fk = vecFKcreate_01.size();
        int i_fkg = vecFKcreate_02.size();
        strTemp = "";
        if (i_fk != 0) {
            for (i = 0; i < i_fk; ++i) {
                strTemp = strTemp + vecFKcreate_01.elementAt(i).toString();
            }
        }
        if (i_fkg != 0) {
            for (i = 0; i < i_fkg; ++i) {
                strTemp = strTemp + vecFKcreate_02.elementAt(i).toString();
            }
        }
        if (strTemp.length() != 0) {
            strTemp = strTemp.substring(0, strTemp.length() - 3);
        }
        return strTemp;
    }

    public static void createSQLdrop(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        StringBuffer buf;
        String strTmp = new String();
        String strTemp = new String();
        String strProjectRoot = Common.getProjectRoot();
        String strFileSep = System.getProperty("file.separator");
        String strSqlDrop = new String();
        strSqlDrop = strProjectRoot + strFileSep + "SQLdrop.sql";
        File fileSqlDrop = new File(strSqlDrop);
        if (fileSqlDrop.exists()) {
            fileSqlDrop.delete();
        }
        fileSqlDrop.createNewFile();
        FileWriter fileWrite = new FileWriter(fileSqlDrop);
        int i = 0;
        int j = 0;
        if (vecXSLUtilDrop_01.size() > 0) {
            i = 0;
            strTemp = vecXSLUtilDrop_01.elementAt(i).toString();
            strTemp = XSLTUtil.returnFixedConstraintName(vecXSLUtilDrop_01.elementAt(i).toString(), vecXSLUtilDrop_11.elementAt(i).toString(), "DROP", "FK", vecXSLUtilDrop_01.elementAt(i).toString(), vecXSLUtilDrop_11.elementAt(i).toString(), dbVendorName);
            vecFKdrop_01.addElement(strTemp);
            j = 2;
            for (i = 1; i < vecXSLUtilDrop_01.size(); ++i) {
                strTemp = vecXSLUtilDrop_01.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtilDrop_01.elementAt(i).toString())) {
                    strTemp = vecXSLUtilDrop_01.elementAt(i).toString();
                    strTemp = XSLTUtil.returnFixedConstraintName(strTemp, vecXSLUtilDrop_11.elementAt(i).toString(), "DROP", "FK", strTemp, vecXSLUtilDrop_11.elementAt(i).toString(), dbVendorName);
                    vecFKdrop_01.addElement(strTemp);
                } else {
                    j = 1;
                    strTemp = vecXSLUtilDrop_01.elementAt(i).toString();
                    strTemp = XSLTUtil.returnFixedConstraintName(strTemp, vecXSLUtilDrop_11.elementAt(i).toString(), "DROP", "FK", strTemp, vecXSLUtilDrop_11.elementAt(i).toString(), dbVendorName);
                    vecFKdrop_01.addElement(strTemp);
                }
                ++j;
            }
        }
        if (vecXSLUtilDrop_02.size() > 0) {
            i = 0;
            strTemp = vecXSLUtilDrop_02.elementAt(i).toString() + "_1";
            vecFKdrop_02.addElement(strTemp);
            j = 2;
            for (i = 1; i < vecXSLUtilDrop_02.size(); ++i) {
                strTemp = vecXSLUtilDrop_02.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtilDrop_02.elementAt(i).toString())) {
                    strTemp = vecXSLUtilDrop_02.elementAt(i).toString();
                    strTemp = XSLTUtil.returnFixedConstraintName(strTemp, vecXSLUtilDrop_12.elementAt(i).toString(), "DROP", "FKG", strTemp, vecXSLUtilDrop_12.elementAt(i).toString(), dbVendorName);
                    vecFKdrop_02.addElement(strTemp);
                } else {
                    j = 1;
                    strTemp = vecXSLUtilDrop_02.elementAt(i).toString();
                    strTemp = XSLTUtil.returnFixedConstraintName(strTemp, vecXSLUtilDrop_12.elementAt(i).toString(), "DROP", "FKG", strTemp, vecXSLUtilDrop_12.elementAt(i).toString(), dbVendorName);
                    vecFKdrop_02.addElement(strTemp);
                }
                ++j;
            }
        }
        if (vecXSLUtilDrop_01.size() != 0) {
            for (i = 0; i < vecXSLUtilDrop_01.size(); ++i) {
                buf = new StringBuffer();
                buf.append("ALTER TABLE ");
                buf.append(vecXSLUtilDrop_01.elementAt(i).toString());
                buf.append(" DROP CONSTRAINT ");
                buf.append(vecFKdrop_01.get(i).toString());
                buf.append(" ;");
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);
            }
            fileWrite.write(13);
            fileWrite.write(10);
        }
        if (vecXSLUtilDrop_02.size() != 0) {
            for (i = 0; i < vecXSLUtilDrop_02.size(); ++i) {
                buf = new StringBuffer();
                buf.append("ALTER TABLE ");
                buf.append(vecXSLUtilDrop_02.elementAt(i).toString());
                buf.append(" DROP CONSTRAINT ");
                buf.append(vecFKdrop_02.get(i).toString());
                buf.append(" ;");
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);
            }
            fileWrite.write(13);
            fileWrite.write(10);
        }
        if (vecDropUnique.size() != 0) {
            for (i = 0; i < vecDropUnique.size(); ++i) {
                buf = new StringBuffer();
                buf.append(vecDropUnique.elementAt(i).toString());
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);
            }
            fileWrite.write(13);
            fileWrite.write(10);
        }
        if (vecDropIndex.size() != 0) {
            for (i = 0; i < vecDropIndex.size(); ++i) {
                buf = new StringBuffer();
                buf.append(vecDropIndex.elementAt(i).toString());
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);
            }
            fileWrite.write(13);
            fileWrite.write(10);
        }
        if (vecDropTable.size() != 0) {
            for (i = 0; i < vecDropTable.size(); ++i) {
                buf = new StringBuffer();
                buf.append(vecDropTable.elementAt(i).toString());
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);
            }
            fileWrite.write(13);
            fileWrite.write(10);
            fileWrite.write("DROP TABLE objectid ;");
            fileWrite.write(13);
            fileWrite.write(10);
        }
        fileWrite.close();
    }

    public static void fillHashtables(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        Object obj1 = null;
        String s1 = XSLUtil.getAttribute((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)"database", (boolean)false);
        if (s1 != null && (obj1 = XSLUtil.evaluate((XSLProcessorContext)xslprocessorcontext, (ElemExtensionCall)elemextensioncall, (String)s1)) == null) {
            throw new WrappedRuntimeException((Exception)new IllegalArgumentException("bad \"select\" attribute ?!"));
        }
        strDatabase = obj1.toString();
    }

    public static void fillHashtables(String strUsedDatabase, String s2) throws Exception {
        strDatabase = strUsedDatabase;
    }

    public static String getDodsProperty(String strKey, String dbVendor) throws Exception {
        String strTemp = dbVendor != null ? Common.getDodsConfProperty((String)strKey, (String)dbVendor) : Common.getDodsConfProperty((String)strKey, (String)strDatabase);
        return strTemp;
    }

    public static String getDodsProperty(String strKey) throws Exception {
        String strTemp = Common.getDodsConfProperty((String)strKey, (String)strDatabase);
        return strTemp;
    }

    public static String getDataType(String strKey) throws Exception {
        String strDataType = "JDBCtype/" + strKey;
        strDataType = XSLTUtil.getDodsProperty(strDataType);
        return strDataType;
    }

    public static String getDataType(String strKey, String dbVendor) throws Exception {
        String strDataType = "JDBCtype/" + strKey;
        strDataType = XSLTUtil.getDodsProperty(strDataType, dbVendor);
        return strDataType;
    }

    public static void createSQLcomplete(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception {
        File fileSqlComplete;
        String strProjectRoot = Common.getProjectRoot();
        Vector vecUrlOfSqlFiles = new Vector();
        vecUrlOfSqlFiles = XSLTUtil.findSQLFiles(new File(strProjectRoot));
        String strFileSep = System.getProperty("file.separator");
        String strSqlDrop = new String();
        strSqlDrop = strProjectRoot + strFileSep + "SQLdrop.sql";
        strSqlDrop = strSqlDrop.replace('/', '\\');
        strSqlDrop = strSqlDrop.replace('\\', '/');
        if (System.getProperty("os.name").toLowerCase().startsWith("win") && strFileSep != "/") {
            strSqlDrop = strSqlDrop.replace('/', '\\');
        }
        String strSqlComplete = new String();
        strSqlComplete = strProjectRoot + strFileSep + "SQLcreate.sql";
        strSqlComplete = strSqlComplete.replace('/', '\\');
        strSqlComplete = strSqlComplete.replace('\\', '/');
        if (System.getProperty("os.name").toLowerCase().startsWith("win") && strFileSep != "/") {
            strSqlComplete = strSqlComplete.replace('/', '\\');
        }
        if ((fileSqlComplete = new File(strSqlComplete)).exists()) {
            fileSqlComplete.delete();
        }
        fileSqlComplete.createNewFile();
        FileWriter fileWrite = new FileWriter(fileSqlComplete);
        for (int i = 0; i < vecUrlOfSqlFiles.size(); ++i) {
            String strUrlOfSqlFile = vecUrlOfSqlFiles.get(i).toString();
            if (strUrlOfSqlFile.equalsIgnoreCase(strSqlDrop) || strUrlOfSqlFile.equalsIgnoreCase(strSqlComplete)) continue;
            FileReader fileRead = new FileReader(strUrlOfSqlFile);
            int ii = fileRead.read();
            while (ii != -1) {
                fileWrite.write(ii);
                ii = fileRead.read();
            }
            fileRead.close();
        }
        fileWrite.write(13);
        fileWrite.write(10);
        fileWrite.write(13);
        fileWrite.write(10);
        fileWrite.write(13);
        fileWrite.write(10);
        fileWrite.write("create table objectid");
        fileWrite.write(13);
        fileWrite.write(10);
        fileWrite.write("(");
        fileWrite.write(13);
        fileWrite.write(10);
        fileWrite.write("    next " + XSLTUtil.getDodsProperty("OidDbType") + " NOT NULL PRIMARY KEY");
        fileWrite.write(13);
        fileWrite.write(10);
        fileWrite.write(");");
        fileWrite.write(13);
        fileWrite.write(10);
        fileWrite.close();
    }

    public static Vector findSQLFiles(File fDirectory) {
        Vector vPathDirectory;
        block6: {
            vPathDirectory = new Vector();
            try {
                File[] arrFileSql = fDirectory.listFiles();
                if (arrFileSql != null) {
                    for (int i = 0; i < arrFileSql.length; ++i) {
                        if (arrFileSql[i].isDirectory()) {
                            Vector vTemp = XSLTUtil.findSQLFiles(arrFileSql[i]);
                            for (int j = 0; j < vTemp.size(); ++j) {
                                vPathDirectory.addElement(vTemp.get(j));
                            }
                            continue;
                        }
                        if (arrFileSql[i].toString().toUpperCase().indexOf(".SQL") == -1) continue;
                        vPathDirectory.addElement(arrFileSql[i]);
                    }
                    break block6;
                }
                System.out.println("Directory " + fDirectory.toString() + " doesn't exist");
            }
            catch (Exception se) {
                System.out.println("error " + se.getMessage());
            }
        }
        return vPathDirectory;
    }

    public static String fixDefaultSQL(String type, String value) {
        if (null == value) {
            value = "";
        }
        String fixedValue = value;
        String defaultValue = "";
        if (type.equals("DECIMAL") || type.equals("NUMERIC")) {
            if (value.length() == 0) {
                fixedValue = "0.0";
            } else {
                try {
                    BigDecimal bigDecimal = new BigDecimal(fixedValue);
                }
                catch (RuntimeException e) {
                    defaultValue = "0.0";
                }
            }
        } else if (type.equals("INTEGER") || type.equals("tinyint") || type.equals("TINYINT") || type.equals("smallint") || type.equals("SMALLINT") || type.equals("INT4") || type.equals("INT8") || type.equals("MEDIUMINT")) {
            if (value.length() == 0) {
                fixedValue = "0";
            } else {
                try {
                    Integer.parseInt(value);
                }
                catch (Exception e) {
                    defaultValue = "0";
                }
            }
        } else if (type.equals("REAL") || type.equals("FLOAT")) {
            if (value.length() == 0) {
                fixedValue = "0.0";
            } else {
                try {
                    Float.valueOf(value);
                }
                catch (Exception e) {
                    defaultValue = "0.0";
                }
            }
        } else if (type.equals("BIGINT")) {
            if (value.length() == 0) {
                fixedValue = "0";
            } else {
                try {
                    Long.parseLong(value);
                }
                catch (Exception e) {
                    defaultValue = "0";
                }
            }
        } else if (type.equals("DOUBLE")) {
            if (value.length() == 0) {
                fixedValue = "0.0";
            } else {
                try {
                    Double.valueOf(value);
                }
                catch (Exception e) {
                    defaultValue = "0.0";
                }
            }
        } else {
            defaultValue = "0";
        }
        if ("" != defaultValue) {
            fixedValue = defaultValue;
        }
        return fixedValue;
    }

    public static String returnFixedConstraintName(String namePrefix, String nameSufix, String operation, String counterType, String counterKeyPrefix, String counterKey, String dbVendor) {
        if (dbVendor != "" && !dbVendorName.equalsIgnoreCase(dbVendor)) {
            dbVendorName = dbVendor;
        }
        Integer keyLength = null;
        String result = "";
        result = namePrefix.equalsIgnoreCase("") || nameSufix.equalsIgnoreCase("") ? namePrefix + nameSufix : namePrefix + "_" + nameSufix;
        String keyLengthStr = Common.getDodsConfProperty((String)"ConstraintNameLength", (String)dbVendorName);
        if (keyLengthStr != null) {
            try {
                keyLength = new Integer(keyLengthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String counterMapKey = counterType.equalsIgnoreCase("PK") || counterType.equalsIgnoreCase("PKG") ? counterType + ":://" : (counterType.equalsIgnoreCase("I") ? counterType + ":://" : counterType + ":://");
        String nameMapKey = counterType + counterKeyPrefix + counterKey;
        int counter = 0;
        if (operation.equalsIgnoreCase("CREATE")) {
            boolean cuted = false;
            if (keyLength != null && keyLength >= 4 && result.length() > keyLength) {
                result = result.substring(0, keyLength - 3 - 1);
                counter = !counterMap.containsKey(counterMapKey = counterMapKey + ":///" + result) ? 1 : (Integer)counterMap.get(counterMapKey) + 1;
                counterMap.put(counterMapKey, new Integer(counter));
                cuted = true;
            }
            if (cuted || counterType.equalsIgnoreCase("FKG")) {
                result = result + "_" + counter;
            }
            nameMap.put(nameMapKey, result);
        } else if (!operation.equalsIgnoreCase("DROP") || (result = (String)nameMap.get(nameMapKey)) == null) {
            // empty if block
        }
        return result;
    }
}

