/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.enhydra.dods.generator.DODSGenerator;

public class Dods
extends Task {
    protected String domlfile = null;
    protected String outputDir = null;
    protected String action = "dods:build_all";
    protected String templateDir = null;
    protected String confDir = null;
    protected String templateSet = "standard";
    protected String force = "false";
    protected String database = "database_not_set";
    protected boolean html = false;
    protected boolean pdf = false;
    protected boolean xmi = false;
    protected boolean ptl = false;

    public void execute() throws BuildException {
        if (this.domlfile == null) {
            throw new BuildException("doml attribute must be set!");
        }
        if (this.outputDir == null) {
            throw new BuildException("output directory attribute must be set!");
        }
        if (!new File(this.outputDir).isDirectory()) {
            throw new BuildException("output directory must be a valid directory!");
        }
        if (this.confDir != null && !new File(this.confDir).isDirectory()) {
            throw new BuildException("configuration directory must be a valid directory!");
        }
        try {
            if (System.getProperty("DODS_HOME") == null) {
                if (System.getProperty("ENHYDRA_DIR") != null) {
                    System.setProperty("DODS_HOME", System.getProperty("ENHYDRA_DIR") + File.separator + "dods");
                } else {
                    throw new BuildException("DODS_HOME not set");
                }
            }
            System.setProperty("JAVA_HOME", System.getProperty("JAVA_HOME"));
            System.setProperty("TEMPLATESET", this.templateSet);
            int n = DODSGenerator.generateAll(this.outputDir, this.domlfile, this.action, this.confDir, this.templateDir, this.templateSet, this.force, this.database, this.html, this.pdf, this.xmi, this.ptl);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDomlfile(String domlfile) {
        this.domlfile = domlfile;
    }

    public void setTemplateDir(String tempDir) {
        this.templateDir = tempDir;
        if (tempDir != null) {
            try {
                File tempFile = new File(tempDir);
                if (!tempFile.isDirectory()) {
                    this.templateDir = null;
                }
            }
            catch (NullPointerException e) {
                this.templateDir = null;
            }
        }
    }

    public void setOutputDir(String outdir) {
        this.outputDir = outdir;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setTemplateSet(String template) {
        this.templateSet = template;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setForce(String force) {
        this.force = "false";
        if (force.equals("true")) {
            this.force = "true";
        }
    }

    public void setHtml(String html) {
        this.html = false;
        if (html.equals("true")) {
            this.html = true;
        }
    }

    public void setPdf(String pdf) {
        this.pdf = false;
        if (pdf.equals("true")) {
            this.pdf = true;
        }
    }

    public void setXmi(String xmi) {
        this.xmi = false;
        if (xmi.equals("true")) {
            this.xmi = true;
        }
    }

    public void setPtl(String ptl) {
        this.ptl = false;
        if (ptl.equals("true")) {
            this.ptl = true;
        }
    }

    public void setConfDir(String string) {
        this.confDir = string;
    }
}

