
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 */

/*
 *
 * @author    Nenad Vico
 * @version   1.0.0  2003/02/26
 *
 */
package org.enhydra.dods.wizard;

import java.awt.Dimension ;
import java.awt.Toolkit ;
import java.io.BufferedReader ;
import java.io.InputStreamReader ;
import org.enhydra.dods.generator.ErrorReader;

/**
 * This class building DODS. Output of this call will be shown in TraceDialog.
 *
 * @author Nenad Vico
 * @version 1.0
 */
public class ExecThread extends Thread  {
    
    TraceDialog td = null; // trace dialog of this Thread
 public ExecThread() {
        td = new TraceDialog(DefaultDODSWizard.frame, "Building ...");  
    }

    public void run() {
        TraceDialog td = new TraceDialog(DefaultDODSWizard.frame, "Building ...");
        Dimension  dimension = Toolkit.getDefaultToolkit().getScreenSize();

        td.setLocation((dimension.width - td.getSize().width) / 2,
                (dimension.height - td.getSize().height) / 2 - 10);
        td.setVisible(true);
        td.setDefaultFocus();
        try {
            
            ErrorReader errorReader;
            
            Process  process;
            BufferedReader  buffer;
            BufferedReader  error;            
            String  s;

            process = DefaultDODSWizard.getGenerator().generateAll(true);
            if (process != null) {
                buffer = new BufferedReader (new InputStreamReader (process.getInputStream()));
                error = new BufferedReader (new InputStreamReader (process.getErrorStream()));
                (new ErrorReader(error, true)).start();
                while ((s = buffer.readLine()) != null) {
                    td.appendLine(s + "\n");
                }
                process.waitFor();
                int k = process.exitValue();
            }
            td.setButtonName("OK");
            td.setTitle("Building (Done)");
            DefaultDODSWizard.getGenerator().postGenerate();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }
} 
