
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: Column.java,v 1.1 2004/09/03 13:43:13 sinisa Exp $
 */

/*
 *
 * @author    Nenad Vico
 * @since     LBS1.8
 * @version   $Revision: 1.1 $
 *
 */
package org.enhydra.dods.trans;

/**
 * This class represents database table column.
 */
public class Column {
    
    /**
     * column name
     */
    protected String  name = null; 

    /**
     * does column has reference
     */
    protected boolean is_reference = DefaultTagValues.COLUMN_IS_REFERENCE; 

    /**
     * reference name
     */
    protected String  ref_name = null; 

    /**
     * is reference used as a constraint
     */
    protected boolean ref_constarint = DefaultTagValues.COLUMN_REF_CONSTARINT; 

    /**
     * is reference abstarct
     */
    protected boolean ref_is_abstarct = DefaultTagValues.COLUMN_REF_IS_ABSTARCT; 

    /**
     * is reference used as foreign key
     */
    protected boolean ref_is_foreign_key = DefaultTagValues.COLUMN_REF_IS_FOREIGN_KEY; 

    /**
     * reference package
     */
    protected String  ref_package = null; 

    /**
     * reference foreign key column name
     */
    protected String  ref_foreign_key_column_name = null; 

    /**
     * reference foreign key group
     */
    protected String  ref_foreign_key_group = null; 

    /**
     * is column constant
     */
    protected boolean is_constant = DefaultTagValues.COLUMN_IS_CONSTANT; 

    /**
     * column javadoc
     */
    protected String  javadoc = null; 

    /**
     * column database type
     */
    protected String  db_type = DefaultTagValues.COLUMN_DB_TYPE; 

    /**
     * column java type
     */
    protected String  java_type = DefaultTagValues.COLUMN_JAVA_TYPE; 

    /**
     * column java default value
     */
    protected String  java_default_value = null; 

    /**
     * is column use for query
     */
    protected boolean used_for_query = DefaultTagValues.COLUMN_USED_FOR_QUERY; 

    /**
     * can column be null
     */
    protected boolean can_be_null = DefaultTagValues.COLUMN_CAN_BE_NULL; 

    /**
     * is column used as primary key
     */
    protected boolean is_primary_key = DefaultTagValues.COLUMN_IS_PRIMARY_KEY; 

    /**
     * column size
     */
    protected String  size = null; 

    /**
     * is column used as array
     */
    protected boolean is_array = DefaultTagValues.COLUMN_IS_ARRAY; 
    
    /**
     * This variable contains information whether the table column need security methods.
     */
    protected boolean  is_secure = DefaultTagValues.COLUMN_SECURITY; 

    /**
     * This variable contains information whether the table column need unsecurity methods.
     */
    protected boolean  is_insecure = DefaultTagValues.COLUMN_NON_SECURITY; 
    public Column(boolean genSecure, boolean genInsecure) {
        is_secure = genSecure;
        is_insecure = genInsecure;
    }
     
    public Column() {}     
      
    // -------------------------    get methodes    -----------------------------
 /**
     * Get column name.
     *
     * @return Column name.
     */
    public String  name() {
        return name;    
    }

    /**
     * Get the information if column has reference.
     *
     * @return True if column has reference.
     */
    public boolean isReference() {
        return is_reference;    
    }

    /**
     * Get reference name.
     *
     * @return Reference name.
     */
    public String  refName() {
        return ref_name;    
    }

    /**
     * Get information if reference is used as constarint.
     * @return True if the reference is used as constarint.
     */
    public boolean refConstarint() {
        return ref_constarint;  
    }

    /**
     * Get the information if reference is abstarct
     *
     * @return True if the reference is abstarct
     */
    public boolean refIsAbstarct() {
        return ref_is_abstarct; 
    }

    /**
     * Get the information if reference is used as foreign key.
     *
     * @return True if the reference is used as foreign key.
     */
    public boolean refIsForeignKey() {
        return ref_is_foreign_key;  
    }

    /**
     * Get reference package.
     *
     *@return Reference package.
     */
    public String  refPackage() {
        return ref_package; 
    }

    /**
     * Get reference's foreign key column name
     * 
     * @return Reference's foreign key column name.
     */
    public String  refForeignKeyColumnName() {
        return ref_foreign_key_column_name; 
    }

    /**
     * Get reference's foreign key group.
     *
     * @return Reference's foreign key group.
     */
    public String  refForeignKeyGroup() {
        return ref_foreign_key_group;   
    }

    /**
     * Get the information if column is constant.
     * 
     * @return True if the column is constant.
     */
    public boolean isConstant() {
        return is_constant; 
    }

    /**
     * Get column javadoc.
     *
     * @return Column javadoc.
     */
    public String  javadoc() {
        return javadoc; 
    }

    /**
     * Get column database type.
     *
     * @return Column database type.
     */
    public String  dbType() {
        return db_type; 
    }

    /**
     * Get column java type.
     *
     * @return Column java type.
     */
    public String  javaType() {
        return java_type;   
    }

    /**
     * Get column java default value.
     *
     * @return Column java default value.
     */
    public String  javaDefaultValue() {
        return java_default_value;  
    }

    /**
     * Get the information if column is used for query.
     *
     * @return True if the column is used for query.
     */
    public boolean usedForQuery() {
        return used_for_query;  
    }

    /**
     * Get the information if column is used for query.
     *
     * @return True if the column is used for query.
     */
    public boolean canBeNull() {
        return can_be_null; 
    }

    /**
     * Get the information if column is used as primary key.
     * 
     * @return True if the column is used as primary key.
     */
    public boolean isPrimaryKey() {
        return is_primary_key;  
    }

    /**
     * Get column size.
     *
     * @return Column size.
     */
    public String  size() {
        return size;    
    }

    /**
     * Get the information if column is used as array.
     *
     * @return True if the column is used as array.
     */
    public boolean isArray() {
        return is_array;    
    }

    /**
     * Get the information whether DO has security methods.
     *
     * @return True if DO is security based, otherwise false.
     */
    public boolean isSecure() {
        return is_secure; 
    }

    /**
     * Get the information whether DO has security methods.
     *
     * @return True if DO is unsecurity based, otherwise false.
     */
    public boolean isInSecure() {
        return is_insecure; 
    }

    // -------------------------    set methodes    -----------------------------
 /**
     * Set column name.
     *
     * @param name Column name.
     */
    public void name(String  name) {
        this.name = name;   
    }

    /**
     * Set reference name.
     * @param ref_name Reference name.
     */
    public void refName(String  ref_name) {
        this.ref_name = ref_name;
        this.is_reference = true;   
    }

    /**
     * Set reference to/not to be used as constarint.
     *
     * @param ref_constarint True if the reference is use as constarint, otherwise false.
     */
    public void refConstarint(boolean ref_constarint) {
        this.ref_constarint = ref_constarint;   
    }

    /**
     * reference to/not to be abstarct.
     *
     * @param ref_is_abstarct True if the reference is abstarct, otherwise false.
     */
    public void refIsAbstarct(boolean ref_is_abstarct) {
        this.ref_is_abstarct = ref_is_abstarct; 
    }

    /**
     * Set reference to/not to be used as foreign key.
     *
     * @param ref_is_foreign_key True if the reference is used as foreign key, otherwise false.
     */
    public void refIsForeignKey(boolean ref_is_foreign_key) {
        this.ref_is_foreign_key = ref_is_foreign_key;   
    }

    /**
     * Set reference package.
     *
     * @param ref_package Reference package.
     */
    public void refPackage(String  ref_package) {
        this.ref_package = ref_package; 
    }

    /**
     * Set reference's foreign key column name.
     *
     * @param ref_foreign_key_column_name Reference's foreign key column name.
     */
    public void refForeignKeyColumnName(String  ref_foreign_key_column_name) {
        this.ref_foreign_key_column_name = ref_foreign_key_column_name; 
    }

    /**
     * Set reference's foreign key group.
     *
     * @param ref_foreign_key_group Reference's foreign key group.
     */
    public void refForeignKeyGroup(String  ref_foreign_key_group) {
        this.ref_foreign_key_group = ref_foreign_key_group; 
    }

    /**
     * Set column to/not to be constant.
     *
     * @param is_constant True if the column is constant, otherwise false.
     */
    public void isConstant(boolean is_constant) {
        this.is_constant = is_constant; 
    }

    /**
     * Set column javadoc.
     *
     * @param javadoc Column javadoc.
     */
    public void javadoc(String  javadoc) {
        this.javadoc = javadoc; 
    }

    /**
     * Set column database type.
     *
     * @param db_type Column database type.
     */
    public void dbType(String  db_type) {
        this.db_type = db_type; 
    }

    /**
     * Set column java type.
     *
     * @param java_type Column java type.
     */
    public void javaType(String  java_type) {
        this.java_type = java_type; 
    }

    /**
     * Set column java default value.
     *
     * @param java_default_value Column java default value.
     */
    public void javaDefaultValue(String  java_default_value) {
        this.java_default_value = java_default_value;   
    }

    /**
     * Set column to/not to be used for query.
     *
     * @param used_for_query  True if the column is used for query, otherwise false.
     */
    public void usedForQuery(boolean used_for_query) {
        this.used_for_query = used_for_query;   
    }

    /**
     * Set column to/not to be able to be null.
     *
     * @param can_be_null True if the column can be null, otherwise false.
     */
    public void canBeNull(boolean can_be_null) {
        this.can_be_null = can_be_null; 
    }
    
    /**
     * Set column to/not to be used as primary key.
     *
     * @param is_primary_key True if the column is used as primary key, otherwise false.
     */
    public void isPrimaryKey(boolean is_primary_key) {
        this.is_primary_key = is_primary_key;   
    }

    /**
     * Set column size.
     *
     * @param size Column size.
     */
    public void size(String  size) {
        this.size = size;   
    }

    /**
     * Set column to/not to be used as array.
     *
     * @param is_array True if the column is used as array, otherwise false.
     */
    public void isArray(boolean is_array) {
        this.is_array = is_array;   
    }

    /**
     * Set DO to/not to have security methods.
     *
     * @param is_secure True if DO need security methods, otherwise false.
     */
    public void isSecure(boolean is_secure) {
        this.is_secure = is_secure; 
    }

    /**
     * Set DO to/not to have security methods.
     *
     * @param is_Insecure True if DO need unsecurity methods, otherwise false.
     */
    public void isInSecure(boolean is_Insecure) {
        this.is_insecure = is_Insecure; 
    }    

    /**
     * Get String representation.
     *
     * return String presentation.
     */
    public String  toString() {
        StringBuffer  ret = new StringBuffer ("name=").append(name).append(" is_reference=").append(is_reference).append(" ref_name=").append(ref_name);

        ret.append(" ref_constarint=").append(ref_constarint).append(" ref_is_abstarct=").append(ref_is_abstarct);
        ret.append(" ref_is_foreign_key=").append(ref_is_foreign_key).append(" ref_package=").append(ref_package);
        ret.append(" ref_foreign_key_column_name=").append(ref_foreign_key_column_name).append(" ref_foreign_key_group=").append(ref_foreign_key_group);
        ret.append(" is_constant=").append(is_constant).append(" javadoc=").append(javadoc);
        ret.append(" db_type=").append(db_type).append(" java_type=").append(java_type);
        ret.append(" java_default_value=").append(java_default_value).append(" used_for_query=").append(used_for_query);
        ret.append(" can_be_null=").append(can_be_null).append(" is_primary_key=").append(is_primary_key);
        ret.append(" size=").append(size).append(" is_array=").append(is_array);
        return ret.toString();
    }

    public static void main(String [] args) {
        Column column = new Column();

        System.out.println("Column: \n" + column); 
    }
}
