/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.enhydra.dods.xml.XmlUtilException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlUtil {
    protected String xmlFile;
    protected Document document;

    public XmlUtil(String xmlFile) throws XmlUtilException {
        this.xmlFile = xmlFile;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.document = db.parse(xmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void store() throws XmlUtilException {
        this.store(null);
    }

    public void store(Properties properties) throws XmlUtilException {
        this.store(null, properties);
    }

    public void store(String fileName, Properties properties) throws XmlUtilException {
        TransformerFactory tf = null;
        DOMSource src = null;
        if (fileName == null) {
            fileName = this.xmlFile;
        }
        tf = TransformerFactoryImpl.newInstance();
        src = new DOMSource(this.document.getDocumentElement());
        if (tf == null) {
            return;
        }
        if (src == null) {
            return;
        }
        FileOutputStream outputs = null;
        try {
            File f = new File(fileName);
            File pf = f.getParentFile();
            if (pf != null) {
                pf.mkdirs();
            }
            outputs = new FileOutputStream(f.getPath());
            Transformer serializer = tf.newTransformer();
            if (properties != null) {
                serializer.setOutputProperties(properties);
            }
            serializer.transform(src, new StreamResult(outputs));
        }
        catch (FileNotFoundException e) {
            throw new XmlUtilException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new XmlUtilException(e);
        }
        catch (TransformerException e) {
            throw new XmlUtilException(e);
        }
    }

    public String getSingleTextNode(String key) throws XmlUtilException {
        return this.getSingleTextNode(key, null);
    }

    public String getSingleTextNode(String key, int[] levelNodes) throws XmlUtilException {
        String subKey;
        String nodeValue = "";
        int cuurentLevel = 0;
        int pos = key.indexOf("/");
        if (pos < 0) {
            return null;
        }
        if (pos == 0) {
            subKey = key.substring(pos + 1);
            pos = subKey.indexOf("/");
        } else {
            subKey = key;
        }
        try {
            if (pos != -1) {
                String tag = subKey.substring(0, pos);
                subKey = subKey.substring(pos + 1);
                NodeList tagElems = this.document.getElementsByTagName(tag);
                Element tagElem = (Element)tagElems.item(0);
                ++cuurentLevel;
                pos = subKey.indexOf("/");
                if (pos != -1) {
                    while (pos != -1) {
                        tag = subKey.substring(0, pos);
                        subKey = subKey.substring(pos + 1);
                        tagElems = tagElem.getElementsByTagName(tag);
                        tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                        if (tagElem == null) {
                            return null;
                        }
                        ++cuurentLevel;
                        pos = subKey.indexOf("/");
                    }
                }
                tagElems = tagElem.getElementsByTagName(subKey);
                tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                tagElems = tagElem.getChildNodes();
                String text = "";
                for (int i = 0; i < tagElems.getLength(); ++i) {
                    if (tagElems.item(i).getNodeType() != 3) continue;
                    text = text + tagElems.item(i).getNodeValue();
                }
                return text;
            }
            NodeList tagElems = this.document.getElementsByTagName(subKey);
            Element tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
            tagElems = tagElem.getChildNodes();
            String text = "";
            for (int i = 0; i < tagElems.getLength(); ++i) {
                if (tagElems.item(i).getNodeType() != 3) continue;
                text = text + tagElems.item(i).getNodeValue();
            }
            return text;
        }
        catch (NullPointerException ex) {
            throw new XmlUtilException(ex);
        }
    }

    public String getSingleAttribute(String key) throws XmlUtilException {
        return this.getSingleAttribute(key, null);
    }

    public String getSingleAttribute(String key, int[] levelNodes) throws XmlUtilException {
        String nodeValue = "";
        NodeList tagElems = null;
        Element tagElem = null;
        String attrValue = null;
        int cuurentLevel = 0;
        int pos = key.indexOf("/");
        if (pos < 0) {
            return null;
        }
        try {
            String subKey;
            if (pos == 0) {
                subKey = key.substring(pos + 1);
                pos = subKey.indexOf("/");
            } else {
                subKey = key;
            }
            if (pos != -1) {
                String tag = subKey.substring(0, pos);
                subKey = subKey.substring(pos + 1);
                tagElems = this.document.getElementsByTagName(tag);
                tagElem = (Element)tagElems.item(0);
                ++cuurentLevel;
                pos = subKey.indexOf("/");
                if (pos != -1) {
                    while (pos != -1) {
                        tag = subKey.substring(0, pos);
                        subKey = subKey.substring(pos + 1);
                        tagElems = tagElem.getElementsByTagName(tag);
                        tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                        if (tagElem == null) {
                            return null;
                        }
                        ++cuurentLevel;
                        pos = subKey.indexOf("/");
                    }
                }
                pos = subKey.indexOf("@");
                tag = subKey.substring(0, pos);
                if (pos != -1) {
                    tagElems = tagElem.getElementsByTagName(tag);
                    tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                    String attrName = subKey.substring(pos + 1);
                    attrValue = tagElem.getAttribute(attrName);
                }
            } else {
                pos = subKey.indexOf("@");
                String tag = subKey.substring(0, pos);
                if (pos != -1) {
                    tagElems = this.document.getElementsByTagName(tag);
                    tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                    String attrName = subKey.substring(pos + 1);
                    attrValue = tagElem.getAttribute(attrName);
                }
            }
        }
        catch (NullPointerException ex) {
            throw new XmlUtilException(ex);
        }
        if (attrValue.equals("")) {
            attrValue = null;
        }
        return attrValue;
    }

    public void setSingleAttribute(String key, int[] levelNodes, String value) throws XmlUtilException {
        String nodeValue = "";
        NodeList tagElems = null;
        Element tagElem = null;
        int cuurentLevel = 0;
        int pos = key.indexOf("/");
        if (pos < 0) {
            return;
        }
        try {
            String subKey;
            if (pos == 0) {
                subKey = key.substring(pos + 1);
                pos = subKey.indexOf("/");
            } else {
                subKey = key;
            }
            if (pos != -1) {
                String tag = subKey.substring(0, pos);
                subKey = subKey.substring(pos + 1);
                tagElems = this.document.getElementsByTagName(tag);
                tagElem = (Element)tagElems.item(0);
                ++cuurentLevel;
                pos = subKey.indexOf("/");
                if (pos != -1) {
                    while (pos != -1) {
                        tag = subKey.substring(0, pos);
                        subKey = subKey.substring(pos + 1);
                        tagElems = tagElem.getElementsByTagName(tag);
                        tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                        if (tagElem == null) {
                            return;
                        }
                        ++cuurentLevel;
                        pos = subKey.indexOf("/");
                    }
                }
                pos = subKey.indexOf("@");
                tag = subKey.substring(0, pos);
                if (pos != -1) {
                    tagElems = tagElem.getElementsByTagName(tag);
                    tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                    String attrName = subKey.substring(pos + 1);
                    tagElem.setAttribute(attrName, value);
                }
            } else {
                pos = subKey.indexOf("@");
                String tag = subKey.substring(0, pos);
                if (pos != -1) {
                    tagElems = this.document.getElementsByTagName(tag);
                    tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                    String attrName = subKey.substring(pos + 1);
                    tagElem.setAttribute(attrName, value);
                }
            }
        }
        catch (NullPointerException ex) {
            throw new XmlUtilException(ex);
        }
    }

    public int getNumberOfNodes(String key) throws XmlUtilException {
        return this.getNumberOfNodes(key, null);
    }

    public int getNumberOfNodes(String key, int[] levelNodes) throws XmlUtilException {
        String subKey;
        String nodeValue = "";
        int cuurentLevel = 0;
        int pos = key.indexOf("/");
        if (pos < 0) {
            return 0;
        }
        if (pos == 0) {
            subKey = key.substring(pos + 1);
            pos = subKey.indexOf("/");
        } else {
            subKey = key;
        }
        try {
            if (pos != -1) {
                String tag = subKey.substring(0, pos);
                subKey = subKey.substring(pos + 1);
                NodeList tagElems = this.document.getElementsByTagName(tag);
                Element tagElem = (Element)tagElems.item(0);
                ++cuurentLevel;
                pos = subKey.indexOf("/");
                if (pos != -1) {
                    while (pos != -1) {
                        tag = subKey.substring(0, pos);
                        subKey = subKey.substring(pos + 1);
                        tagElems = tagElem.getElementsByTagName(tag);
                        tagElem = levelNodes != null && cuurentLevel < levelNodes.length ? (Element)tagElems.item(levelNodes[cuurentLevel]) : (Element)tagElems.item(0);
                        if (tagElem == null) {
                            return 0;
                        }
                        ++cuurentLevel;
                        pos = subKey.indexOf("/");
                    }
                }
                tagElems = tagElem.getElementsByTagName(subKey);
                return tagElems.getLength();
            }
            NodeList tagElems = this.document.getElementsByTagName(subKey);
            return tagElems.getLength();
        }
        catch (NullPointerException ex) {
            throw new XmlUtilException(ex);
        }
    }

    public static String getSingleTextNode(String xmlfile, String key, int[] levelNodes) throws XmlUtilException {
        XmlUtil xml = new XmlUtil(xmlfile);
        return xml.getSingleTextNode(key, levelNodes);
    }

    public static String getSingleAttribute(String xmlfile, String key, int[] levelNodes) throws XmlUtilException {
        XmlUtil xml = new XmlUtil(xmlfile);
        return xml.getSingleAttribute(key, levelNodes);
    }

    public static void setSingleAttribute(String xmlfile, String key, int[] levelNodes, String value, Properties prop) throws XmlUtilException {
        XmlUtil xml = new XmlUtil(xmlfile);
        xml.setSingleAttribute(key, levelNodes, value);
        xml.store(prop);
    }

    public static int getNumberOfNodes(String xmlfile, String key, int[] levelNodes) throws XmlUtilException {
        XmlUtil xml = new XmlUtil(xmlfile);
        return xml.getNumberOfNodes(key, levelNodes);
    }

    public static void main(String[] args) {
        int[] levelNodes = new int[]{0, 0, 1};
        String key = "/databaseManager/database/objectId@name";
        String value = "webdocwf";
        try {
            XmlUtil xml = new XmlUtil("discRackDods.xml");
            xml.setSingleAttribute(key, levelNodes, value);
            System.out.println(key + " = " + xml.getSingleAttribute(key, levelNodes));
            xml.store();
        }
        catch (XmlUtilException e) {
            e.printStackTrace();
        }
    }
}

