/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.enhydra.dods.Common;
import org.enhydra.dods.generator.DODSGenerateException;
import org.enhydra.dods.generator.DODSWizard;
import org.enhydra.dods.generator.ErrorReader;
import org.enhydra.dods.wizard.DefaultDODSWizard;

public class DODSGenerator {
    protected static final int HELP_PARAMETER = 0;
    protected static final int ACTION_PARAMETER = 10;
    protected static final int TEMPLATE_SET_PARAMETER = 20;
    protected static final int FORCE_PARAMETER = 30;
    protected static final int DATABASE_PARAMETER = 40;
    protected static final int CONFIGURATION_DIR_PARAMETER = 50;
    protected static final int HTML_PARAMETER = 100;
    protected static final int PDF_PARAMETER = 110;
    protected static final int XMI_PARAMETER = 120;
    protected static final int PTL_PARAMETER = 130;
    protected static final String HELP_MESSAGE = "\n";
    protected static final String INVALID_NUMBER_OF_PARAMETER_MESSAGE = "\nWrong number of input parameters.\n";
    protected static final String INVALID_PARAMETER_MESSAGE = "\nWrong input parameter ";
    protected static final String INVALID_ACTION_PARAMETER_MESSAGE = "\nWrong action parameter ";
    protected static final String INVALID_TEMPLATE_SET_PARAMETER_MESSAGE = "\n Wrong template set ";
    protected static final String INVALID_DOML_FILE = "\n Wrong .doml file ";
    protected static final String NONEXISTING_DOML_FILE = "\n Doml file doesn't exist  ";
    protected static final String INVALID_CONF_DIR_MESSAGE = "\nWrong input parameter ";
    public static final String DATABASE_NOT_SET = "database_not_set";
    protected DODSWizard wizard = new DefaultDODSWizard(this);
    protected String doml = null;
    protected String outputDir = null;
    protected String action = "dods:build_all";
    protected String templateSet = "standard";
    protected String configDir = null;
    protected String force = "false";
    protected String database = "database_not_set";
    protected boolean html = false;
    protected boolean pdf = false;
    protected boolean xmi = false;
    protected boolean ptl = false;
    protected boolean invoke = false;
    protected boolean kelp = false;
    protected static boolean help = false;
    protected static HashMap parameters = new HashMap();
    protected static HashSet actions;
    protected static HashSet templateSets;

    public DODSWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(DODSWizard wizard) {
        this.wizard = wizard;
    }

    public String getDoml() {
        return this.doml;
    }

    public void setDoml(String doml) {
        this.doml = doml;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getTemplateSet() {
        return this.templateSet;
    }

    public void setTemplateSet(String templateSet) {
        this.templateSet = templateSet;
    }

    public String getForce() {
        return this.force;
    }

    public void setForce(String force) {
        this.force = force;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean getHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public boolean getPdf() {
        return this.pdf;
    }

    public void setPdf(boolean pdf) {
        this.pdf = pdf;
    }

    public boolean getXmi() {
        return this.xmi;
    }

    public void setXmi(boolean xmi) {
        this.xmi = xmi;
    }

    public boolean getPtl() {
        return this.ptl;
    }

    public void setPtl(boolean ptl) {
        this.ptl = ptl;
    }

    public boolean getInvoke() {
        return this.invoke;
    }

    public void setInvoke(boolean invoke) {
        this.invoke = invoke;
    }

    public boolean getKelp() {
        return this.kelp;
    }

    public void setKelp(boolean kelp) {
        this.kelp = kelp;
    }

    public void runWizard() {
        this.wizard.startup();
    }

    public void preGenerate() {
    }

    public void postGenerate() {
    }

    public void preClose() {
    }

    public void preCancel() {
    }

    public static Process generateCode(String outputDir, String domlFile, String action, String templateSet, String forceBuild, String database, boolean ownErrorReader) throws DODSGenerateException {
        Process process = null;
        try {
            if (action == null) {
                action = "dods:build_all";
            }
            if (templateSet == null) {
                templateSet = "standard";
            }
            if (forceBuild == null) {
                forceBuild = "false";
            }
            if (database == null) {
                database = DATABASE_NOT_SET;
            }
            ArrayList<String> argsList = new ArrayList<String>();
            argsList.add(domlFile);
            argsList.add(outputDir);
            argsList.add(templateSet);
            argsList.add(database);
            argsList.add(forceBuild);
            String className = "org.enhydra.dods.generator.DODSEjenProperties";
            Method m = null;
            Class<?> c = null;
            c = Class.forName(className);
            m = c.getMethod("main", String[].class);
            String[] args = (String[])argsList.toArray((Object[])new String[argsList.size()]);
            if (m != null) {
                m.invoke(null, new Object[]{args});
            }
            String[] as = null;
            String endorsing = System.getProperty("DODS_ENDORSED", null);
            as = new String[]{System.getProperty("JAVA_HOME") + File.separator + "bin" + File.separator + "java", "-DDODS_HOME=" + System.getProperty("DODS_HOME"), "-DPROJECT_ROOT=" + outputDir, "-DDOML_FILE=" + domlFile, "-DTEMPLATESET=" + templateSet, "-DDATABASE_VENDOR=" + database, "-DFORCE=" + forceBuild, null != endorsing ? "-Djava.endorsed.dirs=" + endorsing : "-DDODS_HOME=" + System.getProperty("DODS_HOME"), "org.apache.tools.ant.Main", "-f", new String(System.getProperty("DODS_HOME") + File.separator + "build" + File.separator + "generate.xml"), action};
            process = Runtime.getRuntime().exec(as);
            if (!ownErrorReader) {
                BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(errorBufferedReader, true).start();
            }
        }
        catch (ClassNotFoundException e) {
            throw new DODSGenerateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DODSGenerateException(e);
        }
        catch (IllegalAccessException e) {
            throw new DODSGenerateException(e);
        }
        catch (IOException e) {
            throw new DODSGenerateException(e);
        }
        catch (InvocationTargetException e) {
            throw new DODSGenerateException(e);
        }
        return process;
    }

    public Process generateCode(boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateCode(this.outputDir, this.doml, this.action, this.templateSet, this.force, this.database, ownErrorReader);
    }

    public static Process generateHTML(String outputDir, String domlFile, String htmlFile, String forceBuild, boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(outputDir, domlFile, htmlFile, forceBuild, ownErrorReader, "html", "html");
    }

    public Process generateHTML(boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(this.outputDir, this.doml, null, this.force, ownErrorReader, "html", "html");
    }

    public static Process generatePDF(String outputDir, String domlFile, String pdfFile, String forceBuild, boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(outputDir, domlFile, pdfFile, forceBuild, ownErrorReader, "pdf", "pdf");
    }

    public Process generatePDF(boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(this.outputDir, this.doml, null, this.force, ownErrorReader, "pdf", "pdf");
    }

    public static Process generateXMI(String outputDir, String domlFile, String xmiFile, String forceBuild, boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(outputDir, domlFile, xmiFile, forceBuild, ownErrorReader, "xmi", "xmi");
    }

    public Process generateXMI(boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(this.outputDir, this.doml, null, this.force, ownErrorReader, "xmi", "xmi");
    }

    public static Process generatePTL(String outputDir, String domlFile, String ptlFile, String forceBuild, boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(outputDir, domlFile, ptlFile, forceBuild, ownErrorReader, "ptl", "ptl");
    }

    public Process generatePTL(boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateDocumentation(this.outputDir, this.doml, null, this.force, ownErrorReader, "ptl", "ptl");
    }

    private static Process generateDocumentation(String outputDir, String doml, String outputName, String forceBuild, boolean ownErrorReader, String type, String extension) throws DODSGenerateException {
        Process process = null;
        String[] as = new String[3];
        try {
            as[0] = System.getProperty("os.name").toLowerCase().startsWith("win") ? System.getProperty("DODS_HOME") + File.separator + "bin" + File.separator + "doml2" + type + ".bat" : System.getProperty("DODS_HOME") + File.separator + "bin" + File.separator + "doml2" + type;
            as[1] = doml;
            if (outputName == null) {
                int index = doml.lastIndexOf(File.separator);
                outputName = index != -1 ? doml.substring(index + 1) : doml;
                outputName = outputName.substring(0, outputName.lastIndexOf(".doml"));
            }
            as[2] = outputDir + File.separator + outputName + "." + extension;
            process = Runtime.getRuntime().exec(as);
            if (!ownErrorReader) {
                BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(errorBufferedReader, true).start();
            }
        }
        catch (IOException e) {
            throw new DODSGenerateException(e);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new DODSGenerateException(e);
        }
        return process;
    }

    public static int generateAll(String outputDir, String domlFile, String genAction, String templateSet, String forceBuild, String database, boolean genHtml, boolean genPdf, boolean genXmi, boolean genPtl) throws DODSGenerateException {
        int exit = 0;
        try {
            String s;
            BufferedReader error;
            BufferedReader buffer;
            Process process;
            File f = new File(domlFile);
            outputDir = new File(outputDir).getAbsolutePath();
            File dir = new File(outputDir);
            dir.mkdirs();
            domlFile = f.getAbsolutePath();
            f = new File(domlFile);
            if (!f.exists()) {
                throw new DODSGenerateException("\n Doml file doesn't exist   " + domlFile + HELP_MESSAGE);
            }
            if (genHtml) {
                process = DODSGenerator.generateHTML(outputDir, domlFile, null, "true", true);
                buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
                error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(error, true).start();
                while ((s = buffer.readLine()) != null) {
                    System.out.println(s);
                }
                if (exit != 0) {
                    return exit;
                }
            }
            if (genPdf) {
                process = DODSGenerator.generatePDF(outputDir, domlFile, null, "true", true);
                buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
                error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(error, true).start();
                while ((s = buffer.readLine()) != null) {
                    System.out.println(s);
                }
                if (exit != 0) {
                    return exit;
                }
            }
            if (genXmi) {
                process = DODSGenerator.generateXMI(outputDir, domlFile, null, "true", true);
                buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
                error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(error, true).start();
                while ((s = buffer.readLine()) != null) {
                    System.out.println(s);
                }
                if (exit != 0) {
                    return exit;
                }
            }
            if (genPtl) {
                process = DODSGenerator.generatePTL(outputDir, domlFile, null, "true", true);
                buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
                error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(error, true).start();
                while ((s = buffer.readLine()) != null) {
                    System.out.println(s);
                }
                if (exit != 0) {
                    return exit;
                }
            }
            if (!genAction.equalsIgnoreCase("dods:generatorOff")) {
                process = DODSGenerator.generateCode(outputDir, domlFile, genAction, templateSet, forceBuild, database, true);
                buffer = new BufferedReader(new InputStreamReader(process.getInputStream()));
                error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(error, true).start();
                while ((s = buffer.readLine()) != null) {
                    System.out.println(s);
                }
                exit = process.waitFor();
            }
        }
        catch (IOException e) {
            throw new DODSGenerateException(e);
        }
        catch (InterruptedException e) {
            throw new DODSGenerateException(e);
        }
        catch (DODSGenerateException e) {
            Throwable pe = e.getCause();
            if (pe instanceof StringIndexOutOfBoundsException) {
                System.out.println(INVALID_DOML_FILE + domlFile + HELP_MESSAGE);
            }
            throw new DODSGenerateException(e);
        }
        return exit;
    }

    public static int generateAll(String outputDir, String domlFile, String genAction, String configDir, String templateDir, String templateSet, String forceBuild, String database, boolean genHtml, boolean genPdf, boolean genXmi, boolean genPtl) throws DODSGenerateException {
        Common.setCustomTemplateDir((String)templateDir);
        Common.setConfigDir((String)configDir);
        return DODSGenerator.generateAll(outputDir, domlFile, genAction, templateSet, forceBuild, database, genHtml, genPdf, genXmi, genPtl);
    }

    public int generateAll() throws DODSGenerateException {
        return DODSGenerator.generateAll(this.outputDir, this.doml, this.action, this.templateSet, this.force, this.database, this.html, this.pdf, this.xmi, this.ptl);
    }

    public static Process generateAll(String outputDir, String domlFile, String genAction, String configDir, String templateSet, String forceBuild, String database, boolean genHtml, boolean genPdf, boolean genXmi, boolean genPtl, boolean ownErrorReader) throws DODSGenerateException {
        boolean exit = false;
        Process process = null;
        try {
            File f = new File(domlFile);
            outputDir = new File(outputDir).getAbsolutePath();
            domlFile = f.getAbsolutePath();
            f = new File(domlFile);
            if (!f.exists()) {
                throw new DODSGenerateException("\n Doml file doesn't exist   " + domlFile + HELP_MESSAGE);
            }
            String[] tmp = new String[16];
            int param = 1;
            tmp[0] = System.getProperty("os.name").toLowerCase().startsWith("win") ? System.getProperty("DODS_HOME") + File.separator + "bin" + File.separator + "dods.bat" : System.getProperty("DODS_HOME") + File.separator + "bin" + File.separator + "dods";
            if (genAction != null) {
                tmp[param] = "-a";
                tmp[++param] = genAction;
                ++param;
            }
            if (configDir != null) {
                tmp[param] = "-c";
                tmp[++param] = configDir;
                ++param;
            }
            if (templateSet != null) {
                tmp[param] = "-t";
                tmp[++param] = templateSet;
                ++param;
            }
            if (forceBuild != null && forceBuild.equals("true")) {
                tmp[param] = "-f";
                ++param;
            }
            if (database != null) {
                tmp[param] = "-b";
                tmp[++param] = database;
                ++param;
            }
            if (genHtml) {
                tmp[param] = "-h";
                ++param;
            }
            if (genPdf) {
                tmp[param] = "-p";
                ++param;
            }
            if (genXmi) {
                tmp[param] = "-x";
                ++param;
            }
            if (genPtl) {
                tmp[param] = "-r";
                ++param;
            }
            tmp[param] = domlFile;
            tmp[++param] = outputDir;
            String[] as = new String[++param];
            for (int i = 0; i < param; ++i) {
                as[i] = tmp[i];
            }
            process = Runtime.getRuntime().exec(as);
            if (!ownErrorReader) {
                BufferedReader errorBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                new ErrorReader(errorBufferedReader, true).start();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DODSGenerateException(e);
        }
        return process;
    }

    public static Process generateAll(String outputDir, String domlFile, String genAction, String templateSet, String forceBuild, String database, boolean genHtml, boolean genPdf, boolean genXmi, boolean genPtl, boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateAll(outputDir, domlFile, genAction, null, templateSet, forceBuild, database, genHtml, genPdf, genXmi, genPtl, ownErrorReader);
    }

    public Process generateAll(boolean ownErrorReader) throws DODSGenerateException {
        return DODSGenerator.generateAll(this.outputDir, this.doml, this.action, this.configDir, this.templateSet, this.force, this.database, this.html, this.pdf, this.xmi, this.ptl, ownErrorReader);
    }

    public static void help() {
        String dods = "dods";
        String space = "    ";
        String example = "/home/tanja/test/discRack.doml /home/tanja/test/discRack";
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            dods = "dods.bat";
            space = "        ";
            example = "c:\\test\\discRack.doml c:\\test\\discRack";
        }
        System.out.println("\nCommand line help:\n");
        System.out.println(dods + " [-?/help] [-a action] [-t templateset] [-b/-database] [-c confPath] ");
        System.out.println(space + "[-f/force] [-h/html] [-p/pdf] [-x/xmi] [-r/ptl] domlfile outputdir\n");
        System.out.println(" where:\n");
        System.out.println("  outputdir   full path to output directory that will be used.\n");
        System.out.println("  domlfile      full path to .doml file for generating code.\n");
        System.out.println(" options:\n");
        System.out.println("  [-? -help]    shows help.\n");
        System.out.println("  [-a action]   ant task parameter for code generation:");
        System.out.println("        dods:build_all       - to create all sql files and java classes (default).");
        System.out.println("        dods:sql             - to create only sql files.");
        System.out.println("        dods:java            - to create only java files and to compile them.");
        System.out.println("        dods:javaNoCompile   - to create only java files and not to compile them.");
        System.out.println("        dods:noCompile       - to create SQL files and java files and not to");
        System.out.println("                               compile them.");
        System.out.println("        dods:build_all_split - to create all sql files and java classes and to");
        System.out.println("                               compile it. SQL files will be divided into separate");
        System.out.println("                               files using SQLSplitter .");
        System.out.println("        dods:sqlsplit        - to create only sql files and separate in different");
        System.out.println("                               files using SQLSplitter.");
        System.out.println("        dods:noCompileSplit  - to create SQL files and separate sql commands using");
        System.out.println("                               SQLSplitter and java files and not to compile them.\n");
        System.out.println("  [-t templateset]  template set for generating java and sql code:");
        System.out.println("                 standard         - generate standard java code (default).");
        System.out.println("                 <user_defined>   - any user defined template set.\n");
        System.out.println("  [-b/-database] sets database vendor for generating sql.\n");
        System.out.println("  [-c confPath]  sets folder with dodsConf.xml file \n");
        System.out.println("  [-f/-force]  with this switch, code will be always generated, without it, only changes");
        System.out.println("               will be regenerated.\n");
        System.out.println("  [-h/-html]    generates DODS html documentation from .doml file.\n");
        System.out.println("  [-p/-pdf]     generates DODS pdf documentation from .doml file.\n");
        System.out.println("  [-x/-xmi]     generates DODS xmi documentation from .doml file.\n");
        System.out.println("  [-r/-ptl]     generates DODS ptl (Rational Rose) documentation from .doml file.\n");
        System.out.println("Example:\n");
        System.out.println("  " + dods + " -a dods:java -t standard -f -pdf -x " + example + HELP_MESSAGE);
    }

    public String parse(String[] args) {
        try {
            Integer integer;
            int curr = 0;
            int param = -1;
            while (curr < args.length && (integer = (Integer)parameters.get(args[curr])) != null) {
                param = integer;
                ++curr;
                switch (param) {
                    case 0: {
                        help = true;
                        return HELP_MESSAGE;
                    }
                    case 10: {
                        if (!actions.contains(args[curr])) {
                            return INVALID_ACTION_PARAMETER_MESSAGE + args[curr];
                        }
                        this.action = args[curr];
                        ++curr;
                        break;
                    }
                    case 50: {
                        this.configDir = args[curr];
                        ++curr;
                        break;
                    }
                    case 20: {
                        this.templateSet = args[curr];
                        ++curr;
                        break;
                    }
                    case 40: {
                        this.database = args[curr];
                        ++curr;
                        break;
                    }
                    case 30: {
                        this.force = "true";
                        break;
                    }
                    case 100: {
                        this.html = true;
                        break;
                    }
                    case 110: {
                        this.pdf = true;
                        break;
                    }
                    case 120: {
                        this.xmi = true;
                        break;
                    }
                    case 130: {
                        this.ptl = true;
                    }
                }
            }
            try {
                Common.setConfigDir((String)this.configDir);
            }
            catch (Error e) {
                return "\nWrong input parameter " + this.configDir;
            }
            templateSets = Common.getAllTemplateSets();
            if (!templateSets.contains(this.templateSet)) {
                return INVALID_TEMPLATE_SET_PARAMETER_MESSAGE + this.templateSet;
            }
            if (args.length - curr < 2) {
                return INVALID_NUMBER_OF_PARAMETER_MESSAGE;
            }
            if (args[curr].startsWith("-") || args[curr + 1].startsWith("-")) {
                return "\nWrong input parameter " + args[curr];
            }
            this.doml = args[curr];
            this.outputDir = args[curr + 1];
        }
        catch (NullPointerException e) {
            return "\nWrong input parameter ";
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return INVALID_NUMBER_OF_PARAMETER_MESSAGE;
        }
        return null;
    }

    public static void main(String[] args) {
        DODSGenerator generator = new DODSGenerator();
        if (args.length == 0) {
            generator.runWizard();
            return;
        }
        try {
            String message = generator.parse(args);
            if (message != null) {
                System.out.println(message);
                DODSGenerator.help();
                return;
            }
            int exit = generator.generateAll();
            System.exit(exit);
        }
        catch (DODSGenerateException e) {
            String message = e.getLocalizedMessage();
            if (message != null) {
                System.out.println(message);
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConfigDir(String conDir) {
        this.configDir = conDir;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    static {
        parameters.put("-?", new Integer(0));
        parameters.put("-help", new Integer(0));
        parameters.put("-a", new Integer(10));
        parameters.put("-t", new Integer(20));
        parameters.put("-f", new Integer(30));
        parameters.put("-force", new Integer(30));
        parameters.put("-b", new Integer(40));
        parameters.put("-databse", new Integer(40));
        parameters.put("-c", new Integer(50));
        parameters.put("-h", new Integer(100));
        parameters.put("-html", new Integer(100));
        parameters.put("-p", new Integer(110));
        parameters.put("-pdf", new Integer(110));
        parameters.put("-x", new Integer(120));
        parameters.put("-xmi", new Integer(120));
        parameters.put("-r", new Integer(130));
        parameters.put("-ptl", new Integer(130));
        actions = new HashSet();
        actions.add("dods:sql");
        actions.add("dods:java");
        actions.add("dods:javaNoCompile");
        actions.add("dods:noCompile");
        actions.add("dods:build_all_split");
        actions.add("dods:sqlsplit");
        actions.add("dods:noCompileSplit");
        actions.add("dods:build_all");
    }
}

