/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.ant.taskdefs;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class SQLSplitterTask
extends Javac {
    protected File dir = null;
    protected File resultsql = null;
    protected boolean forceBuild = false;
    protected boolean splitsqlprimary = true;

    public void execute() throws BuildException {
        if (this.dir == null) {
            throw new BuildException("dir attribute must be set!");
        }
        if (this.resultsql == null) {
            throw new BuildException("resultsql attribute must be set!");
        }
        int dirpos = -1;
        dirpos = System.getProperty("os.name").toLowerCase().startsWith("win") ? this.resultsql.getAbsolutePath().lastIndexOf("\\") : this.resultsql.getAbsolutePath().lastIndexOf("/");
        String resultsqldir = null;
        String beginfilename = null;
        if (dirpos != -1) {
            resultsqldir = this.resultsql.getAbsolutePath().substring(0, dirpos);
            String sqlfilename = this.resultsql.getAbsolutePath().substring(dirpos + 1);
            int pointpos = sqlfilename.indexOf(".sql");
            beginfilename = pointpos != -1 ? sqlfilename.substring(0, pointpos) : sqlfilename;
        } else {
            resultsqldir = ".";
            int pointpos = this.resultsql.getAbsolutePath().indexOf(".sql");
            beginfilename = pointpos != -1 ? this.resultsql.getAbsolutePath().substring(0, pointpos) : this.resultsql.getAbsolutePath();
        }
        String[] files = new File(resultsqldir).list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].startsWith(beginfilename) || !files[i].endsWith(".sql")) continue;
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                new File(resultsqldir + "\\" + files[i]).delete();
                continue;
            }
            new File(resultsqldir + "/" + files[i]).delete();
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(this.dir.getAbsolutePath());
        argsList.add(this.resultsql.getAbsolutePath());
        if (!this.splitsqlprimary) {
            argsList.add("false");
        }
        try {
            String splitterClassName = "org.webdocwf.util.sql.SQLSplitter";
            Method m = null;
            Class<?> c = null;
            try {
                c = Class.forName(splitterClassName);
                m = c.getMethod("main", String[].class);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
            String[] args = (String[])argsList.toArray((Object[])new String[argsList.size()]);
            if (m != null) {
                m.invoke(null, new Object[]{args});
            }
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            throw new BuildException((Throwable)ite);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    public void setDir(File sqlDir) {
        this.dir = sqlDir;
    }

    public void setResultsql(File sqlBase) {
        this.resultsql = sqlBase;
    }

    public void setSplitsqlprimary(String splitPrimary) {
        this.splitsqlprimary = new Boolean(splitPrimary);
    }

    public void setForce(String force) {
        this.forceBuild = new Boolean(force);
    }

    public static class BooleanAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"yes", "no", "true", "false"};
        }
    }
}

