/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.ant.taskdefs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.enhydra.dods.xml.XmlUtil;
import org.enhydra.dods.xml.XmlUtilException;

public class DomlValidateTask
extends Task {
    private String doml;
    private String projRoot;
    private String template;
    private String force;

    public void setDoml(String doml) {
        this.doml = doml;
    }

    public void setProjRoot(String projRoot) {
        this.projRoot = projRoot;
    }

    public void setTemplate(String temp) {
        this.template = temp;
    }

    public void setForce(String force) {
        this.force = force;
    }

    public void execute() throws BuildException {
        try {
            if (this.doml == null) {
                this.doml = DomlValidateTask.getDomlFile();
            }
            if (this.projRoot == null) {
                this.projRoot = DomlValidateTask.getProjectRoot();
            }
            if (this.template == null) {
                this.template = "standard";
            }
            this.copyDoml();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyDoml() throws FileNotFoundException, IOException {
        File domlFile = new File(this.doml);
        if (!domlFile.exists()) {
            throw new FileNotFoundException(this.doml + " file not found");
        }
        File projFile = new File(this.projRoot);
        if (!projFile.exists()) {
            throw new FileNotFoundException(this.projRoot + " not found");
        }
        try {
            if (!this.force.equals("true")) {
                int dotIndex = this.doml.indexOf(".");
                String update = this.projRoot + this.doml.substring(this.doml.lastIndexOf(File.separator), this.doml.lastIndexOf(".")) + ".uptodate";
                File updateFile = new File(update);
                if (domlFile.lastModified() < updateFile.lastModified()) {
                    return;
                }
            }
        }
        catch (StringIndexOutOfBoundsException dotIndex) {
            // empty catch block
        }
        Properties prop = new Properties();
        prop.setProperty("doctype-system", "file:///" + System.getProperty("DODS_HOME") + File.separator + "build" + File.separator + "dtd" + File.separator + "doml.dtd");
        prop.setProperty("version", "1.0");
        prop.setProperty("encoding", "UTF-8");
        prop.setProperty("standalone", "no");
        try {
            XmlUtil xmlUtil = new XmlUtil(this.doml);
            xmlUtil.setSingleAttribute("/doml/database@templateset", null, this.template);
            xmlUtil.store(this.projRoot + File.separator + domlFile.getName(), prop);
        }
        catch (XmlUtilException e) {
            e.printStackTrace();
        }
    }

    public static String getProjectRoot() {
        String projectRoot = null;
        projectRoot = System.getProperty("PROJECT_ROOT");
        if (projectRoot == null) {
            projectRoot = ".";
        }
        return projectRoot;
    }

    public static String getDomlFile() {
        String strDoml = null;
        strDoml = System.getProperty("DOML_FILE");
        String domlFile = null;
        if (strDoml == null) {
            File current = new File(".");
            String[] files = current.list();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].toLowerCase().endsWith(".doml")) {
                    domlFile = files[i];
                    break;
                }
                domlFile = null;
            }
            strDoml = domlFile;
        }
        return strDoml;
    }

    public static void main(String[] args) {
        DomlValidateTask validate = new DomlValidateTask();
        try {
            validate.copyDoml();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

