
/***********************************************
 SQLSplitter.java
 Date: 29.10.2002.
 @version 1.4.
 @author Sinisa Milosevic
 *********************************************** *
 * formatted with JxBeauty (c) johann.langhofer@nextra.at
 */
package  org.webdocwf.util.sql;

import java.io.File ;
import java.io.RandomAccessFile ;
import java.util.StringTokenizer ;
import java.util.Vector ;
import org.enhydra.dods.xslt.XSLTUtil;

/**
 * Class SQLSplitter copies all SQL commands from all SQL files which are situated
 * in the working directory and all its subdirectories into new SQL files.
 * Original SQL files are created by DODS - Enhydra. 
 * All SQL commands are copied into first sql file except sql commands which reference to foreign and primary key columns.
 * In the second sql file class puts ALTER TABLE sql commands with adding foreign key references.
 * In the third sql file class puts ALTER TABLE sql commands with adding primary keys.
 * In the forth sql file class puts DROP TABLE sql commands for all tables which were created by create table SQL statements in the first file.
 * In the fifth sql file class puts CREATE INDEX sql commands for all tables which were created by create table SQL statements in the first file.
 * In the sixth sql file class puts DROP foreign key sql commands for all tables which were created by create table SQL statements in the first file.
 * In the seventh sql file class puts DROP primary sql commands for all tables which created by create table SQL statements in the first file.
 * All others Sql commands class puts into separate file.
 *
 */
public class SQLSplitter {
    Vector  vecTableName = new Vector ();
    Vector  vecForeignTable = new Vector ();
    Vector  vecForeignKey = new Vector ();
    Vector  vecPrimaryKey = new Vector ();
    Vector  vecReference = new Vector ();
    Vector  vecConstraintName = new Vector ();
    Vector  vecPrimaryKeyTableName = new Vector ();
    Vector  vecPrimaryKeyColumn = new Vector ();
    Vector  vecDropTableTableName = new Vector ();
    Vector  vecDropForeignKeys = new Vector ();
    Vector  vecCreateIndex = new Vector ();
    Vector  vecConstraintPrimary = new Vector ();
    Vector  vecFKRest = new Vector ();
    boolean splitSQLPrimary = true;

    /**
     * Constructor SQLSplitter without parameters.
     */
    public SQLSplitter() {}

    /**
     * Main method controls parameters, if they are OK, starts separateSqlCommands method, but if 
     * they aren't, makes alert.
     *
     * param argv[0] The URL of the 'target' directory.
     * param argv[1] Basic name of output file.
     * 
     */
    public static void main(String  argv[]) {
        if ((argv.length != 2)&&(argv.length != 3)) {
            System.out.println("Usage: SQLSplitter url outputFile\n splitPrimarySql");
            System.out.println(" where url is the URL of working directory \n");
            System.out.println(" outputFile is the path and name of SQL file which will be created \n");
            System.out.println(" and splitPrimarySql force SQLSpliter split PRIMARY part from CREATE to separate file  \n");
            System.out.println(" values are true/false (default value is true).  \n");
            System.exit(1);
        }
        SQLSplitter SQLCommandsChange = new SQLSplitter();
        SQLCommandsChange.setSplitSQLPrimary(true);
        if ((argv.length == 3)){
            try{
                SQLCommandsChange.setSplitSQLPrimary(new Boolean (argv[2]).booleanValue());
            }catch(Exception  e){
                System.out.println("Usage: SQLSplitter url outputFile\n splitPrimarySql");
                System.out.println(" where url is the URL of working directory \n");
                System.out.println(" outputFile is the path and name of SQL file which will be created \n");
                System.out.println(" and splitPrimarySql force SQLSpliter split PRIMARY part from CREATE to separate file  \n");
                System.out.println(" values are true/false (default value is true).  \n");
                System.exit(1);
            }
            
        }
        SQLCommandsChange.separateSqlCommands(argv[0], argv[1]);
    }

    

    /**
     * Method separateSqlCommands analyses all SQL files in a working directory and
     * all its subdirecories and puts all create table SQL statements without Foreign references and Primary keys into separate file.
     * File will be saved in the root of the strDirectory with adding "Create" at the end of output file name - strOutputFile.
     * SQL statements which define foreign keys of tables this method puts into file strOutputFile+"Integrity". 
     * SQL statements which define primary keys of tables this method puts into file strOutputFile+"Primary". 
     * SQL statements which define indexes of tables this method puts into file strOutputFile+"Index". 
     * SQL statements which delete tables will be written into strOutputFile+"DropTable".
     * SQL statements which delete foreign keys will be written into strOutputFile+"DropIntegrity".
     * SQL statements which delete primary keys will be written into strOutputFile+"DropPrimary".
     * Other SQL statements will be written into strOutputFile+"OtherSql".
     *
     * @param strDirectory The URL of the working directory.
     * @param strOutputFile The Url and basic name of the output SQL files(example: c:\tmp\new_SQL.sql).
     */
    public void separateSqlCommands(String  strDirectory, String  strOutputFile) {
        Vector  vPathSQLFiles = new Vector ();
        int iStart = 0;
        String  strOutputFileBegin = "";
        String  strOutputFileEnd = "";

        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            if (!strDirectory.endsWith("\\")) {
                strDirectory += "\\";
            }
        } else {
            if (!strDirectory.endsWith("/")) {
                strDirectory += "/";
            }
        }
            
        if ((iStart = strOutputFile.toLowerCase().indexOf(".sql")) != -1) {
            strOutputFileBegin = strOutputFile.substring(0, iStart);
            strOutputFileEnd = strOutputFile.substring(iStart);
        } else {
            strOutputFileBegin = strOutputFile;
            strOutputFileEnd = ".sql";
        }
        File  fWorkingDirectory = new File (strDirectory);
        File  fOutputCreateTable = new File (strOutputFileBegin + "Create"
                + strOutputFileEnd);
        File  fOutputAlterTable = new File (strOutputFileBegin + "Integrity"
                + strOutputFileEnd);
        File  fOutputDropTable = new File (strOutputFileBegin + "DropTable"
                + strOutputFileEnd);
        File  fOutputDropIntegrity = new File (strOutputFileBegin
                + "DropIntegrity" + strOutputFileEnd);
        File  fOutputDropPrimary = new File (strOutputFileBegin + "DropPrimary"
                + strOutputFileEnd);
        File  fOutputAlterTablePrimaryKey = new File (strOutputFileBegin
                + "Primary" + strOutputFileEnd);
        File  fOutputAlterTableIndex = new File (strOutputFileBegin + "Index"
                + strOutputFileEnd);
          File  fOutputDropTableIndex = new File (strOutputFileBegin + "DropIndex"
                       + strOutputFileEnd);
        File  fOutputOtherSql = new File (strOutputFileBegin + "OtherSql"
                + strOutputFileEnd);

        if (fOutputCreateTable.exists() || fOutputAlterTable.exists()
                || fOutputAlterTablePrimaryKey.exists()
                || fOutputDropTable.exists() || fOutputAlterTableIndex.exists()
                || fOutputDropIntegrity.exists() || fOutputDropPrimary.exists()
                || fOutputOtherSql.exists() || fOutputDropTableIndex.exists()) {
            System.out.println("Output SQL file exists. Please choose different name!");
            System.exit(1);
        }
        vPathSQLFiles = this.findSQLFiles(fWorkingDirectory);
        for (int i = 0; i < vPathSQLFiles.size(); i++) {
            System.out.println("File : " + vPathSQLFiles.get(i).toString()
                    + " is analysing.");
            this.createSQLFile(new File (vPathSQLFiles.get(i).toString()),
                    fOutputCreateTable, fOutputOtherSql);
        }
        if (fOutputCreateTable.length() == 0) {
            fOutputCreateTable.delete();
        }
        if (fOutputOtherSql.length() == 0) {
            fOutputOtherSql.delete();
        }
        this.writeAlterTableForeignKey(fOutputAlterTable);
        if (fOutputAlterTable.length() == 0) {
            fOutputAlterTable.delete();
        }
        this.writeAlterTablePrimaryKey(fOutputAlterTablePrimaryKey);
        if (fOutputAlterTablePrimaryKey.length() == 0) {
            fOutputAlterTablePrimaryKey.delete();
        }
        this.writeDropTable(fOutputDropTable);
        if (fOutputDropTable.length() == 0) {
            fOutputDropTable.delete();
        }
        this.writeAlterTableIndex(fOutputAlterTableIndex);
        if (fOutputAlterTableIndex.length() == 0) {
            fOutputAlterTableIndex.delete();
        }
        this.writeDropIntegrity(fOutputDropIntegrity);
        if (fOutputDropIntegrity.length() == 0) {
            fOutputDropIntegrity.delete();
        }
          this.writeDropTableIndex(fOutputDropTableIndex);
          if (fOutputDropTableIndex.length() == 0) {
               fOutputDropTableIndex.delete();
          }
        
        this.writeDropPrimary(fOutputDropPrimary);
        if (fOutputDropPrimary.length() == 0) {
            fOutputDropPrimary.delete();
        }
        if (vPathSQLFiles.size() == 0) {
            System.out.println("\n No SQL files in target directory");
        }
    }

    /**
     * Method findSQLFiles finds all SQL files (all files which contain ".sql" in their name) in a working directory and
     * all its subdirecories and puts their URL's into Vector.
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fDirectory The URL of the working directory.
     *
     * @return Vector The URLs of all output SQL files in working directory and in all its subdirectories.
     */
    public Vector  findSQLFiles(File  fDirectory) {
        Vector  vPathDirectory = new Vector ();
        File [] arrFileSql;

        try {
            if ((arrFileSql = fDirectory.listFiles()) != null) {
                int i = 0;

                while (i < arrFileSql.length) {
                    if (arrFileSql[i].isDirectory()) {
                        Vector  vTemp = findSQLFiles(arrFileSql[i]);

                        for (int j = 0; j < vTemp.size(); j++) {
                            vPathDirectory.addElement(vTemp.get(j));
                        }
                    } else if (arrFileSql[i].toString().toUpperCase().indexOf(".SQL")
                            != -1) {
                        vPathDirectory.addElement(arrFileSql[i]);
                    }
                    i++;
                }
            } else {
                System.out.println("Directory " + fDirectory.toString()
                        + " doesn't exist");
                System.exit(1);
            }
        } catch (Exception  se) {
            System.out.println("error " + se.getMessage());
            System.exit(1);
        }
        return  vPathDirectory;
    }

    /**
     * Method createSQLFile prepares SQL statements for all output files and creates SQL file (fOutputSQLFile) with CREATE TABLE statements.  
     * Method ignores all comments, foreign keys references and primary keys SQL commands.
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fInputSQLFile The URL of the input SQL file.
     * @param fCreateTable The URL of the output SQL file where we copy CREATE TABLE sql statements.
     * @param fOther The URL of the output SQL file where we copy all other sql statements.
     *
     * @throws Exception.
     */
    public void createSQLFile(File  fInputSQLFile, File  fCreateTable, File  fOther) {
        String  strInLine = "";
        String  strTableName = "";
        String  strRef = "";
        String  strForeignTable = "";
        String  strForeignKey = "";
        String  strPrimaryKey = "";
        String  strPrimaryColumn = "";
        String  strIndex = "";
        boolean bNextIndexLine = false;
        boolean bNextCreateTableLine = false;
        int iStartPointer = 0;
        int iEndPointer = 0;

        try {
            RandomAccessFile  fWriteSQL = new RandomAccessFile (fCreateTable, "rw");
            RandomAccessFile  fWriteOtherSql = new RandomAccessFile (fOther, "rw");
            long lWriteSql = fWriteSQL.length();
            long lWriteOtherSql = fWriteOtherSql.length();

            fWriteSQL.seek(lWriteSql);
            fWriteOtherSql.seek(lWriteOtherSql);
            String  strWriteSQL = "";
            String  strWriteOtherSQL = "";
            RandomAccessFile  fReadSQL = new RandomAccessFile (fInputSQLFile, "r");

            while ((strInLine = fReadSQL.readLine()) != null) {
                int brojac = 0;

                if ((((iStartPointer = strInLine.toUpperCase().indexOf("/*"))
                                        != -1)
                                || (((iStartPointer = strInLine.toUpperCase().indexOf("--"))
                                        != -1)))
                        && !bNextIndexLine) {
                    if (iStartPointer > 0) {
                        strInLine = strInLine.substring(0, iStartPointer).trim();
                    } else {
                        strInLine = "";
                    }
                }
                if (((iStartPointer = strInLine.toUpperCase().indexOf("CREATE TABLE"))
                                != -1)
                        && !bNextIndexLine) {
                    bNextCreateTableLine = true;
                    if ((iEndPointer = strInLine.indexOf("(")) != -1) {
                        strTableName = strInLine.substring(iStartPointer + 12, iEndPointer).trim();
                    } else {
                        strTableName = strInLine.substring(iStartPointer + 12).trim();
                    }
                    this.addTableName(strTableName);
                }
                int iStartConstraint = 0;

                if ((((iStartPointer = strInLine.toUpperCase().indexOf("REFERENCES"))
                                        != -1)
                                && (strInLine.toUpperCase().indexOf("FOREIGN KEY")
                                        == -1))
                        && !bNextIndexLine) {
                    if ((iStartConstraint = strInLine.toUpperCase().indexOf("CONSTRAINT"))
                            != -1) {
                        strForeignKey = strInLine.trim().substring(0,
                                strInLine.trim().indexOf(" "));
                        String  strTemp = strInLine.substring(iStartPointer + 10).trim();
                        String  strConstraint = strInLine.substring(iStartConstraint + 10).trim();

                        strInLine = strInLine.substring(0, iStartConstraint - 1)
                                + ",";
                        if ((iEndPointer = strTemp.indexOf(" (")) != -1) {
                            strForeignTable = strTemp.substring(0, iEndPointer).trim();
                        } else if ((iEndPointer = strTemp.indexOf("(")) != -1) {
                            strForeignTable = strTemp.substring(0, iEndPointer).trim();
                        }
                        if ((iStartPointer = strTemp.indexOf("(")) != -1) {
                            if ((iEndPointer = strTemp.indexOf(")")) != -1) {
                                strPrimaryKey = strTemp.substring(iStartPointer + 1, iEndPointer).trim();
                            }
                        }  
                        if ((iStartPointer = strTemp.indexOf(")")) != -1) {
                            if ((iEndPointer = strTemp.indexOf(",")) != -1) {
                                strRef = strTemp.substring(iStartPointer + 1, iEndPointer).trim();
                            } else {
                                strRef = strTemp.substring(iStartPointer + 1).trim();
                            }
                        }
                        strConstraint = strConstraint.trim().substring(0,
                                strConstraint.trim().indexOf(" "));
                        String  rest = "";

                        this.addForeignKeyValues(strTableName, strForeignTable,
                                strForeignKey, strPrimaryKey, strRef,
                                strConstraint, rest);
                    } else {
                        strForeignKey = strInLine.trim().substring(0,
                                strInLine.trim().indexOf(" "));
                        String  strTemp = strInLine.substring(iStartPointer + 10).trim();

                        strInLine = strInLine.substring(0, iStartPointer - 1)
                                + ",";
                        if ((iEndPointer = strTemp.indexOf(" (")) != -1) {
                            strForeignTable = strTemp.substring(0, iEndPointer).trim();
                        } else if ((iEndPointer = strTemp.indexOf("(")) != -1) {
                            strForeignTable = strTemp.substring(0, iEndPointer).trim();
                        }
                        if ((iStartPointer = strTemp.indexOf("(")) != -1) {
                            if ((iEndPointer = strTemp.indexOf(")")) != -1) {
                                strPrimaryKey = strTemp.substring(iStartPointer + 1, iEndPointer).trim();
                            }
                        }  
                        if ((iStartPointer = strTemp.indexOf(")")) != -1) {
                            if ((iEndPointer = strTemp.indexOf(",")) != -1) {
                                strRef = strTemp.substring(iStartPointer + 1, iEndPointer).trim();
                            } else {
                                strRef = strTemp.substring(iStartPointer + 1).trim();
                            }
                        }
                        String  strConstraint = strTableName + "_"
                                + strForeignKey;
                        String  rest = "";

                        this.addForeignKeyValues(strTableName, strForeignTable,
                                strForeignKey, strPrimaryKey, strRef,
                                strConstraint, rest);
                    }
                }
                iStartConstraint = 0;
                if (((iStartPointer = strInLine.toUpperCase().indexOf("PRIMARY KEY"))
                                != -1)
                        && (!strInLine.toUpperCase().trim().startsWith("CONSTRAINT "))
                        && !bNextIndexLine) {
                    if ((iStartConstraint = strInLine.toUpperCase().indexOf("CONSTRAINT"))
                            != -1) {
                        strPrimaryColumn = strInLine.trim().substring(0,
                                strInLine.trim().indexOf(" "));
                        String  strConstraintPrimary = strInLine.substring(iStartConstraint + 10).trim();

                        strConstraintPrimary = strConstraintPrimary.trim().substring(0,
                                strConstraintPrimary.trim().indexOf(" "));
                        if(isSplitSQLPrimary()){
                            strInLine = strInLine.substring(0, iStartConstraint - 1)+ ",";
                        }
                        
                        this.addPrimaryKeyValues(strTableName, strPrimaryColumn,
                                strConstraintPrimary);
                    } else {
                        strPrimaryColumn = strInLine.trim().substring(0,
                                strInLine.trim().indexOf(" "));
                        if(isSplitSQLPrimary()){                                
                            strInLine = strInLine.substring(0, iStartPointer - 1)+ ",";
                        }
                        String  strConstraintPrimary = XSLTUtil.returnFixedConstraintName(strTableName,strPrimaryColumn,"CREATE","Spliter_PK",strTableName,strPrimaryColumn,"");
                        
                        this.addPrimaryKeyValues(strTableName, strPrimaryColumn,
                                strConstraintPrimary);
                    }
                }
              
                if ((((iStartPointer = strInLine.toUpperCase().indexOf("CREATE "))
                                        != -1)
                                && ((strInLine.toUpperCase().indexOf(" INDEX "))
                                        != -1))
                        || bNextIndexLine) {
                    if ((iEndPointer = strInLine.trim().indexOf(";")) == -1) {
                        bNextIndexLine = true;
                        iEndPointer = strInLine.trim().length() - 1;
                    } else {
                        bNextIndexLine = false;
                    }
                    strIndex = strInLine.trim().substring(0, iEndPointer + 1);
                    if (iStartPointer > 1) {
                        strInLine = strInLine.substring(0, iStartPointer - 1);
                    } else {
                        if (iStartPointer != -1) {
                            strInLine = "";
                        }
                    }
                    this.addIndexValues(strIndex);
                }
                if ((((iStartPointer = strInLine.toUpperCase().indexOf("CONSTRAINT "))
                                != -1)
                        && ((strInLine.toUpperCase().indexOf(" FOREIGN KEY"))
                                != -1))) {
                    int iForeignKey = strInLine.toUpperCase().indexOf(" FOREIGN KEY"); 
                    String  strConstraint = strInLine.substring(iStartPointer + 10, iForeignKey).trim();
                    int iReference = strInLine.toUpperCase().indexOf(" REFERENCES "); 
                    String  strFK = strInLine.substring(iForeignKey + 12, iReference).trim();

                    strFK = strFK.substring(1, strFK.length() - 1);
                    String  endLine = strInLine.substring(iReference);
                    int iStartBracket = endLine.indexOf("("); 
                    int iEndBracket = endLine.indexOf(")"); 
                    String  strFT = endLine.substring(12, iStartBracket).trim();
                    String  strPK = endLine.substring(iStartBracket + 1, iEndBracket).trim();
                    String  rest = endLine.substring(iEndBracket + 1).trim();

                    rest = rest.replaceAll(",", " ");
                    strInLine = "";
                    this.addForeignKeyValues(strTableName, strFT, strFK, strPK,
                            strRef, strConstraint, rest);
                }
                if ((((iStartPointer = strInLine.toUpperCase().indexOf("CONSTRAINT "))
                                != -1)
                        && ((strInLine.toUpperCase().indexOf(" PRIMARY KEY"))
                                != -1))) {
                    int iPrimaryKey = strInLine.toUpperCase().indexOf(" PRIMARY KEY"); 
                    String  strConstraint = strInLine.substring(iStartPointer + 10, iPrimaryKey).trim();
                    int iStartBracket = strInLine.indexOf("("); 
                    int iEndBracket = strInLine.indexOf(")"); 
                    String  strPK = strInLine.substring(iStartBracket + 1, iEndBracket).trim();
                    if(isSplitSQLPrimary()){
                        strInLine = "";
                    }
                    this.addPrimaryKeyValues(strTableName, strPK, strConstraint);
                }
                if ((strInLine != null) && !strInLine.trim().equals("")
                        && bNextCreateTableLine) {
                    strWriteSQL = strWriteSQL.concat(strInLine + "\n");
                } else if (!strInLine.equals("")) {
                    strWriteOtherSQL = strWriteOtherSQL.concat(strInLine + "\n");
                }
                if (strInLine.indexOf(";") != -1 && bNextCreateTableLine) {
                    bNextCreateTableLine = false;
                }    
            }
            
            if (!strWriteSQL.equals("")) {
                StringTokenizer  tokenizerCreate = new StringTokenizer (strWriteSQL,
                        ";");
            
                while (tokenizerCreate.hasMoreTokens()) {
                
                    String  strToken = tokenizerCreate.nextToken().trim();

                    if (!strToken.equals("")) {
                            
                        boolean isOK = true;
                        int endComPos = 0;
                        int endPos = strToken.lastIndexOf(")");

                        if (endPos != -1) {
                            endComPos = strToken.substring(0, endPos).lastIndexOf(",");
                            if (endComPos != -1) {
                                String  checkString = strToken.substring(endComPos
                                        + 1,
                                        endPos);

                                OK:
                                for (int i = 0; i < checkString.length(); i++) {
                                    if (checkString.charAt(i) != ' '
                                            && checkString.charAt(i) != '\n') {
                                        isOK = true;
                                        break OK;
                                    } else {
                                        isOK = false;
                                    }   
                                }       
                            }   
                        }
                        if (!isOK) {
                            strToken = strToken.substring(0, endComPos)
                                    + strToken.substring(endComPos + 1);
                        }
                        fWriteSQL.writeBytes(strToken + ";\n\n"); 
                    }            
                                            
                }
                if (!strWriteOtherSQL.equals("")) {
                    fWriteSQL.writeBytes(strWriteOtherSQL + "\n\n"); 
                }       
                    
            }
            fReadSQL.close();
            fWriteSQL.close();
            fWriteOtherSql.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    /**
     * Method addForeignKeyValues adds values to global variables - vectors.
     * These variables are used for creating ALTER TABLE sql commands - foreign key references.  
     *
     * @param strTableName Name of table where the foreign key SQL statement was found.
     * @param strForeignTable 'Foreign table'.
     * @param strForeignKey Column in the table 'strTablename' which is referenced by foreign key.
     * @param strPrimaryKey Column in the table 'strForeignTable' - primary key.
     * @param strReference Sql commands after foreign key columns (such as ON DELETE CASCADE).
     * @param strConstraint Name of Foreign Key constraint.
     * @param strRest ON DELETE ...
     */
    public void addForeignKeyValues(String  strTableName, String  strForeignTable, 
            String  strForeignKey, String  strPrimaryKey, String  strReference, 
            String  strConstraint, String  strRest) {
        this.vecTableName.addElement(strTableName);
        this.vecForeignTable.addElement(strForeignTable);
        this.vecForeignKey.addElement(strForeignKey);
        this.vecPrimaryKey.addElement(strPrimaryKey);
        this.vecReference.addElement(strReference);
        this.vecConstraintName.addElement(strConstraint);
        this.vecFKRest.addElement(strRest);
    }

    /**
     * Method addPrimaryKeyValues adds values to global variables - vectors.
     * These variables are used for creating ALTER TABLE sql commands - primary key.  
     *
     * @param strTableName Name of table where the primary key SQL statement was found.
     * @param strPrimaryColumn Name of column which is primary key.
     * @param strConstraintPrimary Name of Primary key constraint.
     */
    public void addPrimaryKeyValues(String  strTableName, String  strPrimaryColumn, 
            String  strConstraintPrimary) {
        this.vecPrimaryKeyTableName.addElement(strTableName);
        this.vecPrimaryKeyColumn.addElement(strPrimaryColumn);
        this.vecConstraintPrimary.addElement(strConstraintPrimary);
    }

    /**
     * Method addTableName adds values to global variables - vectors.
     * These variables are used for creating DROP TABLE sql commands.
     *  
     * @param strTableName Name of table which it will be deleted.
     */
    public void addTableName(String  strTableName) {
        boolean bEqual = false;

        for (int i = 0; i < this.vecDropTableTableName.size(); i++) {
            if (this.vecDropTableTableName.get(i).toString().equalsIgnoreCase(strTableName)) {
                bEqual = true;
            }
        }
        if (!bEqual) {
            this.vecDropTableTableName.addElement(strTableName);
        }
    }

    /**
     * Method addIndexValues adds values to global variables - vectors.
     * These variables are used for creating CREATE INDEX sql commands.  
     *
     * @param strIndex All create index SQL statements.
     */
    public void addIndexValues(String  strIndex) {
        this.vecCreateIndex.addElement(strIndex);
    }

    /**
     * Method writeAlterTableForeignKey creates SQL file with ALTER TABLE SQL commands (foreign key references).  
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fOutputAlterTable The URL of the output SQL file.
     *
     * @throws Exception.
     */
    public void writeAlterTableForeignKey(File  fOutputAlterTable) {
        try {
            RandomAccessFile  fWriteAlterTable = new RandomAccessFile (fOutputAlterTable,
                    "rw");

            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecTableName.size(); i++) {
                fWriteAlterTable.writeBytes("\nALTER TABLE "
                        + this.vecTableName.get(i).toString()
                        + " ADD CONSTRAINT "
                        + this.vecConstraintName.get(i).toString()
                        + " FOREIGN KEY ("
                        + this.vecForeignKey.get(i).toString() + ") REFERENCES "
                        + this.vecForeignTable.get(i).toString() + " ("
                        + this.vecPrimaryKey.get(i).toString() + ") "
                        + this.vecReference.get(i).toString() + " "
                        + this.vecFKRest.get(i).toString() + " ;\n");
            }
            fWriteAlterTable.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    /**
     * Method writeDropIntegrity creates SQL file with ALTER TABLE SQL commands (drop foreign key references).  
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fOutputDropIntegrity The URL of the output SQL file.
     *
     * @throws Exception.
     */
    public void writeDropIntegrity(File  fOutputDropIntegrity) {
        try {
            RandomAccessFile  fWriteAlterTable = new RandomAccessFile (fOutputDropIntegrity,
                    "rw");

            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecTableName.size(); i++) {
                fWriteAlterTable.writeBytes("\nALTER TABLE "
                        + this.vecTableName.get(i).toString()
                        + " DROP CONSTRAINT "
                        + this.vecConstraintName.get(i).toString() + " ;\n");
            }
            fWriteAlterTable.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    /**
     * Method writeDropPrimary creates SQL file with ALTER TABLE SQL commands (drop primary keys).  
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fOutputDropPrimary The URL of the output SQL file.
     *
     * @throws Exception.
     */
    public void writeDropPrimary(File  fOutputDropPrimary) {
        try {
            RandomAccessFile  fWriteAlterTable = new RandomAccessFile (fOutputDropPrimary,
                    "rw");

            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecPrimaryKeyTableName.size(); i++) {
                fWriteAlterTable.writeBytes("\nALTER TABLE "
                        + this.vecPrimaryKeyTableName.get(i).toString()
                        + " DROP CONSTRAINT "
                        + this.vecConstraintPrimary.get(i).toString() + " ;\n");
            }
            fWriteAlterTable.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    /**
     * Method writeAlterTablePrimaryKey createss SQL file with ALTER TABLE SQL commands (primary keys for all tables).  
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fOutputAlterTable The URL of the output SQL file.
     *
     * @throws Exception.
     */
    public void writeAlterTablePrimaryKey(File  fOutputAlterTable) {
        try {
            RandomAccessFile  fWriteAlterTable = new RandomAccessFile (fOutputAlterTable,
                    "rw");

            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecPrimaryKeyTableName.size(); i++) {
                fWriteAlterTable.writeBytes("\nALTER TABLE "
                        + this.vecPrimaryKeyTableName.get(i).toString()
                        + " ADD CONSTRAINT "
                        + this.vecConstraintPrimary.get(i).toString()
                        + " PRIMARY KEY ("
                        + this.vecPrimaryKeyColumn.get(i).toString() + ") ;\n");
            }
            fWriteAlterTable.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    /**
     * Method writeDropTable creates SQL file with DROP TABLE SQL commands. All tables will be deleted.  
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fOutputDropTable The URL of the output SQL file.
     *
     * @throws Exception.
     */
    public void writeDropTable(File  fOutputDropTable) {
        try {
            RandomAccessFile  fWriteDropTable = new RandomAccessFile (fOutputDropTable,
                    "rw");

            fWriteDropTable.seek(fWriteDropTable.length());
            for (int i = 0; i < this.vecDropTableTableName.size(); i++) {
                fWriteDropTable.writeBytes("\nDROP TABLE "
                        + this.vecDropTableTableName.get(i).toString() + " ;\n");
            }
            fWriteDropTable.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    /**
     * Method writeAlterTableIndex creates SQL file with CREATE INDEX SQL commands.  
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fOutputAlterTableIndex The URL of the output SQL file.
     *
     * @throws Exception.
     */
    public void writeAlterTableIndex(File  fOutputAlterTableIndex) {
        try {
            RandomAccessFile  fWriteIndex = new RandomAccessFile (fOutputAlterTableIndex,
                    "rw");

            fWriteIndex.seek(fWriteIndex.length());
            for (int i = 0; i < this.vecCreateIndex.size(); i++) {
                fWriteIndex.writeBytes("\n"
                        + this.vecCreateIndex.get(i).toString() + "\n");
            }
            fWriteIndex.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Method writeDropTableIndex creates SQL file with DROP INDEX SQL commands.  
     * If there is an error Exception "Exception" is thrown.
     *
     * @param fOutputDropTableIndex The URL of the output SQL file.
     *
     * @throws Exception.
     */
    public void writeDropTableIndex(File  fOutputDropTableIndex) {
        try {
            RandomAccessFile  fWriteIndex = new RandomAccessFile (fOutputDropTableIndex,
                    "rw");

            fWriteIndex.seek(fWriteIndex.length());
            for (int i = 0; i < this.vecCreateIndex.size(); i++) {
                String  temp = this.vecCreateIndex.get(i).toString();

                fWriteIndex.writeBytes("\n DROP "
                        + temp.substring(temp.indexOf("INDEX"),temp.indexOf("ON")) + ";\n");
            }
            fWriteIndex.close();
        } catch (Exception  e) {
            e.printStackTrace();
        }

    }
    
    /**
     * @return value of splitSQLPrimary.
     */
    public boolean isSplitSQLPrimary() {
        return splitSQLPrimary;
    }
    
    /**
     * @param b new value for setSplitSQLPrimary
     */
    public void setSplitSQLPrimary(boolean b) {
        splitSQLPrimary = b;
    }

    
}
