
/*
 * Enhydra Java Application Server Project 
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: XSLTUtil.java,v 1.1 2004/09/03 13:43:14 sinisa Exp $
 */

/*
 *   XSLTUtil.java
 *
 * @author    Dragan Radeka
 * @since     LBS1.8
 * @version   $Revision: 1.1 $
 *
 */
package org.enhydra.dods.xslt;

import java.io.File ;
import java.io.FileReader ;
import java.io.FileWriter ;
import java.text.ParseException ;
import java.text.SimpleDateFormat ;
import java.util.HashMap ;
import java.util.Vector ;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.objects.XString;
import org.ejen.util.XSLUtil;
import org.enhydra.dods.Common;

/**
 *
 *   Utility class that xsl template files use during the DODS generation of sql and java files.
 *
 */
public class XSLTUtil {
    
    public String  strVectorValues_1 = new String ();
    public String  strVectorValues_2 = new String ();
    public String  strVectorValues_3 = new String ();
    public String  strVectorValues_4 = new String ();
    public static String  strAttribut_0 = new String ();
    public static String  strAttribut_1 = new String ();
    public String  strAttribut_11 = new String ();
    public static String  strAttribut_2 = new String ();
    public static String  strAttribut_3 = new String ();
    public static String  strAttribut_4 = new String ();
    public static String  strAttribut_5 = new String ();
    
    public static Vector  vecDropPrimaryKey = new Vector ();
    public static Vector  vecDropUnique = new Vector ();
    public static Vector  vecDropIndex = new Vector ();
    public static Vector  vecDropTable = new Vector ();
    
    public static Vector  vecXSLUtil_01 = new Vector ();
    public static Vector  vecXSLUtilDrop_01 = new Vector ();
    public static Vector  vecXSLUtilDrop_11 = new Vector ();
    public static Vector  vecFKcreate_01 = new Vector ();
    public static Vector  vecFKdrop_01 = new Vector ();
    public static Vector  vecXSLUtil_02 = new Vector ();
    public static Vector  vecXSLUtilDrop_02 = new Vector ();
    public static Vector  vecXSLUtilDrop_12 = new Vector ();
    public static Vector  vecFKcreate_02 = new Vector ();
    public static Vector  vecFKdrop_02 = new Vector ();
    public static Vector  vecXSLUtil_11 = new Vector ();
    public static Vector  vecXSLUtil_12 = new Vector ();
    public static Vector  vecXSLUtil_2 = new Vector ();
    public static Vector  vecXSLUtil_3 = new Vector ();
    public static Vector  vecXSLUtil_41 = new Vector ();
    public static Vector  vecXSLUtil_42 = new Vector ();
    public static Vector  vecXSLUtil_5 = new Vector ();
    public static String  strPathProjectRoot = new String ();
    public static String  strPathDomlFile = new String ();
    public static String  strPathDodsConf = new String ();
    public static String  strPathTypesConf = new String ();
    
    public static String  strDatabase = new String ();
    

    private static final int minKeyLength = 4;
    private static final int maxCounterLength = 3;
    private static HashMap  counterMap = new HashMap ();
    private static HashMap  nameMap = new HashMap ();
    public static String  dbVendorName="Standard";
    
    protected XSLTUtil() {}

    /**
     * Conversion of string to java.util.Date.
     *
     * @param s String which will be converted into Date.
     *
     * @return Date in which the string is transformed to.
     */
    public static java.util.Date  str2date(String  s) {
        String [] formats = {
            "yyyy-MM-dd H:mm:ss a", "yyyy MM dd H:mm:ss a", "yyyy-MM-dd H:mm:ss",
            "yyyy MM dd H:mm:ss", "yyyy-MM-dd H:mm a", "yyyy MM dd H:mm a",
            "yyyy-MM-dd H:mm", "yyyy MM dd H:mm", "yyyy-MM-dd", "yyyy MM dd",
            "MMM dd yyyy h:mm:ss a", "MMM dd, yyyy h:mm:ss a",
            "MMM dd yyyy h:mm:ss", "MMM dd, yyyy h:mm:ss", "MMM dd yyyy h:mm a",
            "MMM dd, yyyy h:mm a", "MMM dd yyyy h:mm", "MMM dd, yyyy h:mm" };
        java.util.Date  ret = null;

        for (int i = 0; i < formats.length; i++) {
            SimpleDateFormat  df = new SimpleDateFormat (formats[ i ]);

            try {
                ret = df.parse(s);
                break;
            } catch (ParseException  e) {}
        }
        return ret;
    }

    /**
     * Fix default values for java types. If default value isn't correct,
     * appropriate value for specified java type will be taken.
     *
     * @param type Java type.
     * @param value Default value.
     *
     * @return Corrected default value for specified java type.
     */
    public static String  fixDefault(String  type, String  value) {
        // FIX handle arrays
 if (null == value) {
            value = "";
        }
        String  fixedValue = value;
        String  defaultValue = null;

        if (type.endsWith("DO")) {
            fixedValue = "null";
        }    // default value not allowed for DO refs
 else if (type.equals("String")) {
            if (fixedValue.length() == 0) {
                fixedValue = "null";
            } else {
                fixedValue = "\"" + value + "\"";
            }
        } else if (type.equals("java.math.BigDecimal")) {
            if (value.length() == 0) {
                fixedValue = "null";
            } else {
                try {
                    java.math.BigDecimal  test = new java.math.BigDecimal (fixedValue);

                    fixedValue = "new " + type + "(" + fixedValue + ")";
                } catch (RuntimeException  e) {
                    defaultValue = "null";
                }
            }
        } else if (type.equals("java.sql.Date")) {
            if (value.length() == 0) {
                fixedValue = "null";
            } else {
                try {
                    java.util.Date  d = str2date(fixedValue);
                    java.sql.Date  test = new java.sql.Date (d.getTime());

                    fixedValue = "new " + type + "(" + fixedValue + ")";
                } catch (RuntimeException  e) {
                    defaultValue = "null";
                }
            }
        } else if (type.equals("java.sql.Time")) {
            if (value.length() == 0) {
                fixedValue = "null";
            } else {
                try {
                    java.util.Date  d = str2date(fixedValue);
                    java.sql.Time  test = new java.sql.Time (d.getTime());

                    fixedValue = "new " + type + "(" + fixedValue + ")";
                } catch (RuntimeException  e) {
                    defaultValue = "null";
                }
            }
        } else if (type.equals("java.sql.Timestamp")) {
            if (value.length() == 0) {
                fixedValue = "null";
            } else {
                try {
                    java.util.Date  d = str2date(fixedValue);
                    java.sql.Timestamp  test = new java.sql.Timestamp (d.getTime());

                    fixedValue = "new " + type + "(" + fixedValue + ")";
                } catch (RuntimeException  e) {
                    defaultValue = "null";
                }
            }
        } else if (type.equals("int")) {
            if (value.length() == 0) {
                fixedValue = "0";
            } else {
                try {
                    int i = Integer.parseInt(value);
                } catch (Exception  e) {
                    defaultValue = "0";
                }
            }
        } else if (type.equals("boolean")) {
            if (value.length() == 0) {
                fixedValue = "false";
            } else {
                try {
                    if (Boolean.valueOf(value).booleanValue()) {
                        fixedValue = "true";
                    } else {
                        fixedValue = "false";
                    }
                } catch (Exception  e) {
                    defaultValue = "false";
                }
            }
        } else if (type.equals("float")) {
            if (value.length() == 0) {
                fixedValue = "0f";
            } else {
                try {
                    Float.valueOf(value);
                    if (!value.endsWith("f")) {
                        fixedValue = value + "f";
                    }
                } catch (Exception  e) {
                    defaultValue = "0f";
                }
            }
        } else if (type.equals("byte")) {
            if (value.length() == 0) {
                fixedValue = "0";
            } else {
                try {
                    Byte.parseByte(value);
                } catch (Exception  e) {
                    defaultValue = "0";
                }
            }
        } else if (type.equals("short")) {
            if (value.length() == 0) {
                fixedValue = "0";
            } else {
                try {
                    Short.parseShort(value);
                } catch (Exception  e) {
                    defaultValue = "0";
                }
            }
        } else if (type.equals("long")) {
            if (value.length() == 0) {
                fixedValue = "0L";
            } else {
                try {
                    Long.parseLong(value);
                    if (!value.endsWith("L")) {
                        fixedValue = value + "L";
                    }
                } catch (Exception  e) {
                    defaultValue = "0L";
                }
            }
        } else if (type.equals("double")) {
            if (value.length() == 0) {
                fixedValue = "0d";
            } else {
                try {
                    Double.valueOf(value);
                    if (!value.endsWith("d")) {
                        fixedValue = value + "d";
                    }
                } catch (Exception  e) {
                    defaultValue = "0d";
                }
            }
        } else if (type.equals("byte[]")) {
            try {
                // FIX
                defaultValue = "{0}";
            } catch (RuntimeException  e) {}
        } else {
            defaultValue = "null";
        }
        if (null != defaultValue) {
            fixedValue = defaultValue;
        }
        return fixedValue;
    }

    /**
     * Adjust java type, cut "root." if String type begins with it.
     *
     * @param type Java type.
     *
     * @return Adjusted java type.
     */
    static public String  adjustJavaType(String  type) {
        if (type.startsWith("root.")) {
            return type.substring(5);
        }
        return type;
    }

    /**
     * Get package name with leading "root." stripped off.
     *
     * @param pckg Package name.
     *
     * @return The packageName with leading "root." stripped off.
     */
    static public String  getAdjustedPackageName(String  pckg) {
        if (pckg.startsWith("root.")) {
            return pckg.substring(5);
        }
        return pckg;
    }

    /**
     * Determine approperate clone method for specified member and java type.
     *
     * @param name Class member name (column table name).
     * @param javaType Class member java type (column table java type).
     * @param isObjectRef True if member is ObjectReference, otherwise false.
     *
     * @return Approperate clone method for specified member and java type.
     */
    static public String  cloneValue(String  name, String  javaType, String  isObjectRef) throws Exception  {
        // set the CLONE_VALUE tag
 // boolean, byte, short, int, long, float, double
 // String
 // java.sql.Date, java.sql.Time, java.sql.Timestamp
 // byte[]
 // java.math.BigDecimal
 //
 String  type = adjustJavaType(javaType);
        String  retClone = null;
        String  primitiveTypes = ":boolean:char:byte:short:int:long:float:double:";
        String  timeTypes = ":java.sql.Date:java.sql.Time:java.sql.Timestamp:";

        if (-1 != primitiveTypes.indexOf(":" + type + ":")) {
            retClone = name;
        } else if (-1 != timeTypes.indexOf(":" + type + ":")) {
            String  shortType = type.substring(type.lastIndexOf('.') + 1);

            retClone = "GenericDO.copy" + shortType + "(" + name + ")";
        } else if (type.equals("String")) {
            retClone = "GenericDO.copyString(" + name + ")";
        } else if (type.equals("byte[]")) {
            retClone = "GenericDO.copyByteArray(" + name + ")";
        } else if (type.equals("java.math.BigDecimal")) {
            retClone = "GenericDO.copyBigDecimal(" + name + ")";
        } else {
            if (isObjectRef.equals("true")) {
                retClone = type + ".createCopy( " + name + " )";
            } else {   // assume data type is of a cloneable class
                retClone = "(" + type + ") " + name + ".clone()";
            }
        }
        return retClone;
    }

    /**
     * Transform java basic Objects in capital letters.
     *
     * @param type Class member java type (column table java_type).
     *
     * @return Capitalized java type.
     */
    static public String  capitalizeJavaBasicObject(String  type) throws Exception  {
        String  javaType = type;
        String  primitiveTypes = ":boolean:char:byte:short:int:long:float:double:";

        if (-1 != primitiveTypes.indexOf(":" + type + ":")) {
            javaType = Common.capitalizeName(type);
        }
        return javaType;
    }

    /**
     * Make java type from java type replacing '.' with '_'.
     *
     * @param type Class member java type (column table java_type).
     *
     * @return Java type.
     */
    static public String  javaType(String  type) {
        String  jt = type.replace('.', '_');

        return convertArrayType(jt);
    }

    /**
     * Make Jdbc type from java type.
     *
     * @param javaType Class member java type (column table java_type).
     *
     * @return jdbc java type.
     */
    static public String  jdbcType(String  javaType) {
        String  type = javaType;
        int dot = type.lastIndexOf('.');

        if (-1 != dot) {
            type = type.substring(dot + 1);
        }
        String  firstChar = type.substring(0, 1).toUpperCase();

        return convertArrayType(firstChar + type.substring(1));
    }

    /**
     * Convert java type into array type.
     *
     * @param type Class member java type (column table java_type).
     *
     * @return Converted array type.
     */
    static public String  convertArrayType(String  type) {
        String  at = type;
        int i = type.indexOf("[]");

        if (-1 != i) {
            at = type.substring(0, i) + "s";
        }
        return at;
    }

    /**
     * Construct an empty vector.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void createVector(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        vecDropPrimaryKey.clear(); // vector with strings for droping Primary Keys
        vecDropUnique.clear(); // vector with strings for droping Unique Constraints
        vecDropIndex.clear();  // vector with strings for droping Indexes
        vecDropTable.clear();  // vector with strings for droping Tables
        vecFKcreate_01.clear();// Foreign key constraint names in SQLcreate.sql when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecFKcreate_02.clear();// Foreign key constraint names in SQLcreate.sql when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecFKdrop_01.clear();  // Foreign key constraint names in SQLdrop.sql when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecFKdrop_02.clear();  // Foreign key constraint in SQLdrop.sql names when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtil_01.clear(); // TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecXSLUtil_02.clear(); // TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtilDrop_01.clear(); // TABLE_NAME in XML file (for SQLdrop.sql) when
        vecXSLUtilDrop_11.clear(); // COLUMN_NAME in XML file (for SQLdrop.sql) when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecXSLUtilDrop_02.clear(); // TABLE_NAME in XML file (for SQLdrop.sql) when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtilDrop_12.clear(); // COLUMN_NAME in XML file (for SQLdrop.sql) when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtil_11.clear(); // COLUMN/@name for each column (in XML file where
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist) which refernces
 // on the appropriate table in the vector vecXSLUtil_2.
 // Values for COLUMN/@name are separated by ", ".
        vecXSLUtil_12.clear(); // COLUMN/@name for each column (in XML file where
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist) which refernces
 // on the appropriate table in the vector vecXSLUtil_3.
 // Values for COLUMN/@name are separated by ", ".
        vecXSLUtil_2.clear(); // REFERENCE_OBJECT/TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecXSLUtil_3.clear(); // REFERENCE_OBJECT/TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtil_41.clear();  // REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME for each column
 // (in XML file where REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist)
 // which is referenced in to, and contains in table REFERENCE_OBJECT/TABLE_NAME
 // in the vector vecXSLUtil_2. Values for REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME
 // are separated by ", ".
        vecXSLUtil_42.clear();  // REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME for each column
 // (in XML file where REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist)
 // which is referenced in to, and contains in table REFERENCE_OBJECT/TABLE_NAME
 // in the vector vecXSLUtil_3. Values for REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME
 // are separated by ", ".
        vecXSLUtil_5.clear(); // REFERENCE_OBJECT/FOREIGN_KEY_GROUP: every Object (String) in the vector
 // is diferent REFERENCE_OBJECT/FOREIGN_KEY_GROUP name.
    }

    /**
     * Construct an empty vector.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void resetCreateVectors(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        vecFKcreate_01.clear();// Foreign key constraint names in SQLcreate.sql when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecFKcreate_02.clear();// Foreign key constraint names in SQLcreate.sql when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtil_01.clear(); // TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecXSLUtil_02.clear(); // TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtil_11.clear(); // COLUMN/@name for each column (in XML file where
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist) which refernces
 // on the appropriate table in the vector vecXSLUtil_2.
 // Values for COLUMN/@name are separated by ", ".
        vecXSLUtil_12.clear(); // COLUMN/@name for each column (in XML file where
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist) which refernces
 // on the appropriate table in the vector vecXSLUtil_3.
 // Values for COLUMN/@name are separated by ", ".
        vecXSLUtil_2.clear(); // REFERENCE_OBJECT/TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist.
        vecXSLUtil_3.clear(); // REFERENCE_OBJECT/TABLE_NAME in XML file when
 // REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist.
        vecXSLUtil_41.clear();  // REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME for each column
 // (in XML file where REFERENCE_OBJECT/FOREIGN_KEY_GROUP does not exist)
 // which is referenced in to, and contains in table REFERENCE_OBJECT/TABLE_NAME
 // in the vector vecXSLUtil_2. Values for REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME
 // are separated by ", ".
        vecXSLUtil_42.clear();  // REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME for each column
 // (in XML file where REFERENCE_OBJECT/FOREIGN_KEY_GROUP exist)
 // which is referenced in to, and contains in table REFERENCE_OBJECT/TABLE_NAME
 // in the vector vecXSLUtil_3. Values for REFERENCE_OBJECT/FOREIGN_KEY_COLUMN_NAME
 // are separated by ", ".
        vecXSLUtil_5.clear(); // REFERENCE_OBJECT/FOREIGN_KEY_GROUP: every Object (String) in the vector
 // is diferent REFERENCE_OBJECT/FOREIGN_KEY_GROUP name.
    }

    /**
     * Fill vector with the given attribute only if the given attribute
     * isn't already in the vector.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void fillVector(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        Object  obj0 = null;
        Object  obj1 = null;
        Object  obj2 = null;
        Object  obj3 = null;
        Object  obj4 = null;
        Object  obj5 = null;
        String  s0 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "attribut0", false);
        String  s1 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "attribut1", false);
        String  s2 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "attribut2", false);
        String  s3 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "attribut3", false);
        String  s4 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "attribut4", false);
        String  s5 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "attribut5", false);
        int i = 0;
        String  strTemp = new String ();

        obj5 = new XString("");
        if (s5 != null) {
            obj5 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s5);
            if (obj5 != null) {
                String  s51 = XSLUtil.getAttribute(xslprocessorcontext,
                        elemextensioncall, "attribute5", false);

                if (s51 != null) {
                    obj5 = new XString(s51);
                }
            }
        }
        
        if (s0 != null) {
            obj0 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s0);
            if (obj0 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        } else {
            String  s01 = XSLUtil.getAttribute(xslprocessorcontext,
                    elemextensioncall, "attribute0", false);

            if (s01 != null) {
                obj0 = new XString(s01);
            }
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        }
            
        if (s1 != null) {
            obj1 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s1);
            if (obj1 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        } else {
            String  s11 = XSLUtil.getAttribute(xslprocessorcontext,
                    elemextensioncall, "attribute1", false);

            if (s11 != null) {
                obj1 = new XString(s11);
            }
        }
        if (obj1 == null) {
            obj1 = new XString("(no value)");
        }
        if (s2 != null) {
            obj2 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s2);
            if (obj2 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        } else {
            String  s21 = XSLUtil.getAttribute(xslprocessorcontext,
                    elemextensioncall, "attribute2", false);

            if (s21 != null) {
                obj2 = new XString(s21);
            }
        }
        if (obj2 == null) {
            obj2 = new XString("(no value)");
        }
        if (s3 != null) {
            obj3 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s3);
            if (obj3 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        } else {
            String  s31 = XSLUtil.getAttribute(xslprocessorcontext,
                    elemextensioncall, "attribute3", false);

            if (s31 != null) {
                obj3 = new XString(s31);
            }
        }
        if (obj3 == null) {
            obj3 = new XString("(no value)");
        }
        if (s4 != null) {
            obj4 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s4);
            if (obj4 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        } else {
            String  s41 = XSLUtil.getAttribute(xslprocessorcontext,
                    elemextensioncall, "attribute4", false);

            if (s41 != null) {
                obj4 = new XString(s41);
            }
        }
        if (obj4 == null) {
            obj4 = new XString("(no value)");
        } else {
            strAttribut_0 = obj0.toString(); //tabela
            strAttribut_1 = obj1.toString(); //kolona 
            strAttribut_2 = obj2.toString(); //referisana tabela
            strAttribut_3 = obj3.toString(); //referisana kolona 
            strAttribut_4 = obj4.toString(); //referisana grupa
            strAttribut_5 = obj5.toString(); //vendor
 
            if (strAttribut_3.length() == 0) {
                if (strAttribut_5.equalsIgnoreCase("")) {
                    strAttribut_3 = getDodsProperty("OidDbColumnName");
                } else {
                    strAttribut_3 = getDodsProperty("OidDbColumnName",
                            strAttribut_5);
                }
            }
            if (strAttribut_2.length() != 0 && strAttribut_4.length() == 0) {
                vecXSLUtil_01.addElement(strAttribut_0);
                vecXSLUtil_11.addElement(strAttribut_1);
                vecXSLUtilDrop_01.addElement(strAttribut_0);
                vecXSLUtilDrop_11.addElement(strAttribut_1);
                vecXSLUtil_2.addElement(strAttribut_2);
                vecXSLUtil_41.addElement(strAttribut_3);
            }
            if (strAttribut_2.length() != 0 && strAttribut_4.length() != 0) {
                if (!vecXSLUtil_5.contains(strAttribut_4)) {
                    vecXSLUtil_02.addElement(strAttribut_0);
                    vecXSLUtilDrop_02.addElement(strAttribut_0);
                    vecXSLUtilDrop_12.addElement(strAttribut_1);
                    vecXSLUtil_12.addElement(strAttribut_1);
                    vecXSLUtil_3.addElement(strAttribut_2);
                    vecXSLUtil_42.addElement(strAttribut_3);
                    vecXSLUtil_5.addElement(strAttribut_4);
                } else {
                    i = vecXSLUtil_5.indexOf(strAttribut_4);
                    strTemp = vecXSLUtil_12.elementAt(i).toString();
                    strTemp = strTemp + ", " + strAttribut_1;
                    vecXSLUtil_12.setElementAt(strTemp, i);
                    strTemp = vecXSLUtil_42.elementAt(i).toString();
                    strTemp = strTemp + ", " + strAttribut_3;
                    vecXSLUtil_42.setElementAt(strTemp, i);
                }
            }
        }
    }

    /**
     * Fill vector with the string made from the given attribute.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void fillVecDropPrimaryKey(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        
        Object  obj0 = null;
        Object  obj1 = null;
        Object  obj2 = null;
        
        String  s0 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "tableName", false);
        String  s1 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "vendorName", false);                
                
        String  s2 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "columnName", false);                

        if (s2 != null) {
            obj2 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s2);
            if (obj2 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad database vendor attribute ?!"));
            }
        }
        if (obj2 == null) {
            obj2 = new XString("(no value)");
        }



        if (s1 != null) {
            obj1 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s1);
            if (obj1 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad database vendor attribute ?!"));
            }
        }
        if (obj1 == null) {
            obj1 = new XString("Standard");
        }



        if (s0 != null) {
            obj0 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s0);
            if (obj0 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        } else {
            String  strTableName = obj0.toString();
            String  strVendorName= obj1.toString();
            String  strColumnName= obj2.toString();
            String  strTmp = "ALTER TABLE " + strTableName
                    + " DROP CONSTRAINT " + returnFixedConstraintName(strTableName, strColumnName , "DROP", "PK", strTableName,strColumnName ,strVendorName)+ " ;";
            vecDropPrimaryKey.addElement(strTmp);
        }
    }

    /**
     * Fill vector with the string made from the given attribute.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void fillVecDropUnique(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        Object  obj0 = null;
        Object  obj1 = null;
        Object  obj2 = null;

        String  s2 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "columnName", false);                


        String  s0 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "tableName", false);

        String  s1 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "vendorName", false);                

        if (s2 != null) {
            obj2 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s2);
            if (obj2 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad database vendor attribute ?!"));
            }
        }
        if (obj2 == null) {
            obj2 = new XString("(no value)");
        }

        if (s1 != null) {
            obj1 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s1);
            if (obj1 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad database vendor attribute ?!"));
            }
        }
        if (obj1 == null) {
            obj1 = new XString("Standard");
        }

        if (s0 != null) {
            obj0 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s0);
            if (obj0 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        } else {
            String  strTableName = obj0.toString();
            String  strVendorName = obj1.toString();
            String  strColumnName = obj2.toString();
            String  strTmp = "ALTER TABLE " + strTableName
                    + " DROP CONSTRAINT " + returnFixedConstraintName(strTableName , strColumnName, "DROP", "U", strTableName , strColumnName, strVendorName)+ " ;";
            vecDropUnique.addElement(strTmp);
        }
    }

    /**
     * Fill vector with the string made from the given attribute.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void fillVecDropIndex(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        Object  obj0 = null;
        Object  obj1 = null;
        Object  obj2 = null;
        
        String  s0 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "tableName", false);
        String  s1 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "indexName", false);
        String  s2 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "vendorName", false);                

        if (s2 != null) {
            obj2 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s2);
            if (obj2 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad database vendor attribute ?!"));
            }
        }
        if (obj2 == null) {
            obj2 = new XString("Standard");
        }
        
        if (s0 != null) {
            obj0 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s0);
            if (obj0 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        }
        
        if (s1 != null) {
            obj1 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s1);
            if (obj1 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        }
        if (obj1 == null) {
            obj1 = new XString("(no value)");
        } else {
            String  strTableName  = obj0.toString();
            String  strIndexName  = obj1.toString();
            String  strVendorName = obj2.toString();           
            String  strTmp = "DROP INDEX " + returnFixedConstraintName(strTableName, strIndexName ,"DROP", "I", strTableName, strIndexName , strVendorName)+ " ;";

            vecDropIndex.addElement(strTmp);
        }
    }

    /**
     * Fill vector with the string made from the given attribute.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void fillVecDropTable(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        Object  obj0 = null;
        String  s0 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "tableName", false);

        if (s0 != null) {
            obj0 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s0);
            if (obj0 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        }
        if (obj0 == null) {
            obj0 = new XString("(no value)");
        } else {
            String  strTmp = "DROP TABLE " + obj0.toString() + " ;";

            vecDropTable.addElement(strTmp);
        }
    }

    /**
     * Get all constraints defined in this table.
     *
     * @return All constraints defined in this table.
     *
     * @throws Exception
     */
    static public String  returnForeignKeyConstraints(String  dbVendor) throws Exception  {
        String  strTemp11 = new String ();
        String  strTemp41 = new String ();
        String  strTemp = "";
        boolean delCascade = Common.getDodsConfProperty("DeleteCascade", dbVendor).equalsIgnoreCase("true");
        String  keyLengthStr = Common.getDodsConfProperty("ConstraintNameLength", dbVendor);
        String  tempName = null;
        int keyLength = -1;
        if (keyLengthStr!=null){
             keyLength  = new Integer (keyLengthStr).intValue();
        }
        int i = 0;
        int j = 0;

        // make unique name for Foreign Key constraint when FOREIGN_KEY_GROUP does not exist:
 // "FK_" + TABLE_NAME + "_" + n     ; where is int n > 0.
 if (vecXSLUtil_01.size() > 0) {
            i = 0;
//            tempName =  vecXSLUtil_01.elementAt(i).toString() + "_"
//                    + vecXSLUtil_11.elementAt(i).toString();
            tempName = returnFixedConstraintName(vecXSLUtil_01.elementAt(i).toString(),vecXSLUtil_11.elementAt(i).toString(),"CREATE","FK",vecXSLUtil_01.elementAt(i).toString(),vecXSLUtil_11.elementAt(i).toString(),dbVendor);                     
//          if ((tempName.length()>keyLength)&&(keyLength>=minKeyLength)){
//              tempName=tempName.substring(0,keyLength-maxCounterLength)+"_1";
//          }
            strTemp = "    CONSTRAINT "  + tempName
                    + " FOREIGN KEY (" + vecXSLUtil_11.elementAt(i).toString()
                    + ") REFERENCES " + vecXSLUtil_2.get(i).toString() + " ("
                    + vecXSLUtil_41.get(i).toString() + ")";
            if (delCascade) {
                strTemp = strTemp + " ON DELETE CASCADE ,\n";
            } else {
                strTemp = strTemp + " ,\n";
            }
            vecFKcreate_01.addElement(strTemp);
            i = 1;
            j = 2;
            while (i < vecXSLUtil_01.size()) {
                strTemp = vecXSLUtil_01.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtil_01.elementAt(i).toString())) {
//                  tempName =  vecXSLUtil_01.elementAt(i).toString() + "_"
//                            + vecXSLUtil_11.elementAt(i).toString();
                    tempName = returnFixedConstraintName(vecXSLUtil_01.elementAt(i).toString(),vecXSLUtil_11.elementAt(i).toString(),"CREATE","FK",vecXSLUtil_01.elementAt(i).toString(),vecXSLUtil_11.elementAt(i).toString(),dbVendor);                     
                              
//              if ((tempName.length()>keyLength)&&(keyLength>=minKeyLength)){
//                      tempName=tempName.substring(0,keyLength-maxCounterLength)+"_"+j;
//                  }
                    strTemp = "    CONSTRAINT " + tempName
                            + " FOREIGN KEY ("
                            + vecXSLUtil_11.elementAt(i).toString()
                            + ") REFERENCES " + vecXSLUtil_2.get(i).toString()
                            + " (" + vecXSLUtil_41.get(i).toString() + ")";
                    if (delCascade) {
                        strTemp = strTemp + " ON DELETE CASCADE ,\n";
                    } else {
                        strTemp = strTemp + " ,\n";
                    }
                    vecFKcreate_01.addElement(strTemp);
                } else {
                    j = 1;
                    tempName = returnFixedConstraintName(vecXSLUtil_01.elementAt(i).toString(),vecXSLUtil_11.elementAt(i).toString(),"CREATE","FK",vecXSLUtil_01.elementAt(i).toString(),vecXSLUtil_11.elementAt(i).toString(),dbVendor);                     

                    strTemp = "    CONSTRAINT "  +  tempName                  
                              + " FOREIGN KEY ("
                              + vecXSLUtil_11.elementAt(i).toString()
                              + ") REFERENCES " + vecXSLUtil_2.get(i).toString()
                              + " (" + vecXSLUtil_41.get(i).toString() + ")";
                    if (delCascade) {
                        strTemp = strTemp + " ON DELETE CASCADE ,\n";
                    } else {
                        strTemp = strTemp + " ,\n";
                    }
                    vecFKcreate_01.addElement(strTemp);
                }
                j++;
                i++;
            } // end while
        } // end if
 // make unique name for Foreign Key constraint when FOREIGN_KEY_GROUP exist:
 // "FKG_" + TABLE_NAME + "_" + n     ; where is int n > 0.
 // //"FKG_" + TABLE_NAME + "_" + REFERENCE_OBJECT/FOREIGN_KEY_GROUP
 if (vecXSLUtil_02.size() > 0) {
            i = 0;
//          tempName =  vecXSLUtil_02.elementAt(i).toString();
//          if ((tempName.length()>keyLength)&&(keyLength>=minKeyLength)){
//              tempName=tempName.substring(0,keyLength-maxCounterLength);
//          }
            tempName = returnFixedConstraintName("FKG", vecXSLUtil_02.elementAt(i).toString(),"CREATE","FKG","FKG", vecXSLUtil_02.elementAt(i).toString(),dbVendor);                      

            strTemp = "    CONSTRAINT "
                    + tempName
                    + " FOREIGN KEY (" + vecXSLUtil_12.elementAt(i).toString()
                    + ") REFERENCES " + vecXSLUtil_3.get(i).toString() + " ("
                    + vecXSLUtil_42.get(i).toString() + ")";
            if (delCascade) {
                strTemp = strTemp + " ON DELETE CASCADE ,\n";
            } else {
                strTemp = strTemp + " ,\n";
            }
            vecFKcreate_02.addElement(strTemp);
            i = 1;
            j = 2;
            while (i < vecXSLUtil_02.size()) {
                strTemp = vecXSLUtil_02.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtil_02.elementAt(i).toString())) {
//                  tempName =  vecXSLUtil_02.elementAt(i).toString();
//                  if ((tempName.length()>keyLength)&&(keyLength>=minKeyLength)){
//                      tempName=tempName.substring(0,keyLength-maxCounterLength);
//                  }
                    tempName = returnFixedConstraintName("FKG", vecXSLUtil_02.elementAt(i).toString(),"CREATE","FKG","FKG", vecXSLUtil_02.elementAt(i).toString(),dbVendor);                      

                    strTemp = "    CONSTRAINT "
                            + tempName
                            + " FOREIGN KEY ("
                            + vecXSLUtil_12.elementAt(i).toString()
                            + ") REFERENCES " + vecXSLUtil_3.get(i).toString()
                            + " (" + vecXSLUtil_42.get(i).toString() + ")";
                    if (delCascade) {
                        strTemp = strTemp + " ON DELETE CASCADE ,\n";
                    } else {
                        strTemp = strTemp + " ,\n";
                    }
                    vecFKcreate_02.addElement(strTemp);
                } else {
                    j = 1;
//                  tempName =  vecXSLUtil_02.elementAt(i).toString();
//                  if ((tempName.length()>keyLength)&&(keyLength>=minKeyLength)){
//                      tempName=tempName.substring(0,keyLength-maxCounterLength);
//                  }
                    tempName = returnFixedConstraintName("FKG", vecXSLUtil_02.elementAt(i).toString(),"CREATE","FKG","FKG", vecXSLUtil_02.elementAt(i).toString(),dbVendor);                      

                    strTemp = "    CONSTRAINT "
                            + tempName + "_" + j
                            + " FOREIGN KEY ("
                            + vecXSLUtil_12.elementAt(i).toString()
                            + ") REFERENCES " + vecXSLUtil_3.get(i).toString()
                            + " (" + vecXSLUtil_42.get(i).toString() + ")";
                    if (delCascade) {
                        strTemp = strTemp + " ON DELETE CASCADE ,\n";
                    } else {
                        strTemp = strTemp + " ,\n";
                    }
                    vecFKcreate_02.addElement(strTemp);
                }
                j++;
                i++;
            } // end while
        } // end if
 int i_fk = vecFKcreate_01.size();
        int i_fkg = vecFKcreate_02.size();

        strTemp = "";
        if (i_fk != 0) {
            i = 0;
            while (i < i_fk) {
                strTemp = strTemp + vecFKcreate_01.elementAt(i).toString();
                i++;
            }
        }
        
        if (i_fkg != 0) {
            i = 0;
            while (i < i_fkg) {
                strTemp = strTemp + vecFKcreate_02.elementAt(i).toString();
                i++;
            }
        }
        
        if (strTemp.length() != 0) {
            strTemp = strTemp.substring(0, strTemp.length() - 3);
        }
        return strTemp;
    }
    
//    /**
//     * Get all constraints defined in this table.
//     *
//     * @return All constraints defined in this table.
//     *
//     * @throws Exception
//     */
//    static public String returnForeignKeyConstraints() throws Exception {
//        String strTemp11 = new String();
//        String strTemp41 = new String();
//        String strTemp = "";
//        
//        int i = 0;
//        int j = 0;
//
//        // make unique name for Foreign Key constraint when FOREIGN_KEY_GROUP does not exist:
//        // "FK_" + TABLE_NAME + "_" + n     ; where is int n > 0.
//        if (vecXSLUtil_01.size() > 0) {
//            i = 0;
//            strTemp = "    CONSTRAINT "
//                     + vecXSLUtil_01.elementAt(i).toString() + "_"
//                      + vecXSLUtil_11.elementAt(i).toString()
//                    + " FOREIGN KEY (" + vecXSLUtil_11.elementAt(i).toString()
//                    + ") REFERENCES " + vecXSLUtil_2.get(i).toString() + " ("
//                    + vecXSLUtil_41.get(i).toString() + ")";
//            strTemp = strTemp + " ,\n";
//            vecFKcreate_01.addElement(strTemp);
//            i = 1;
//            j = 2;
//            while (i < vecXSLUtil_01.size()) {
//                strTemp = vecXSLUtil_01.elementAt(i - 1).toString();
//                if (strTemp.equals(vecXSLUtil_01.elementAt(i).toString())) {
//                    strTemp = "    CONSTRAINT "
//                               + vecXSLUtil_01.elementAt(i).toString() + "_"
//                                + vecXSLUtil_11.elementAt(i).toString()
//                            + " FOREIGN KEY ("
//                            + vecXSLUtil_11.elementAt(i).toString()
//                            + ") REFERENCES " + vecXSLUtil_2.get(i).toString()
//                            + " (" + vecXSLUtil_41.get(i).toString() + ")";
//                    strTemp = strTemp + " ,\n";
//                    vecFKcreate_01.addElement(strTemp);
//                } else {
//                    j = 1;
//                    strTemp = "    CONSTRAINT "
//                               + vecXSLUtil_01.elementAt(i).toString() + "_"
//                                + vecXSLUtil_11.elementAt(i).toString()
//                            + " FOREIGN KEY ("
//                            + vecXSLUtil_11.elementAt(i).toString()
//                            + ") REFERENCES " + vecXSLUtil_2.get(i).toString()
//                            + " (" + vecXSLUtil_41.get(i).toString() + ")";
//                    strTemp = strTemp + " ,\n";
//                    vecFKcreate_01.addElement(strTemp);
//                }
//                j++;
//                i++;
//            } // end while
//        } // end if
//        // make unique name for Foreign Key constraint when FOREIGN_KEY_GROUP exist:
//        // "FKG_" + TABLE_NAME + "_" + n     ; where is int n > 0.
//        // //"FKG_" + TABLE_NAME + "_" + REFERENCE_OBJECT/FOREIGN_KEY_GROUP
//        if (vecXSLUtil_02.size() > 0) {
//            i = 0;
//            strTemp = "    CONSTRAINT FKG_"
//                    + vecXSLUtil_02.elementAt(i).toString() + "_1"
//                    + " FOREIGN KEY (" + vecXSLUtil_12.elementAt(i).toString()
//                    + ") REFERENCES " + vecXSLUtil_3.get(i).toString() + " ("
//                    + vecXSLUtil_42.get(i).toString() + ")";
//            strTemp = strTemp + " ,\n";
//            vecFKcreate_02.addElement(strTemp);
//            i = 1;
//            j = 2;
//            while (i < vecXSLUtil_02.size()) {
//                strTemp = vecXSLUtil_02.elementAt(i - 1).toString();
//                if (strTemp.equals(vecXSLUtil_02.elementAt(i).toString())) {
//                    strTemp = "    CONSTRAINT FKG_"
//                            + vecXSLUtil_02.elementAt(i).toString() + "_" + j
//                            + " FOREIGN KEY ("
//                            + vecXSLUtil_12.elementAt(i).toString()
//                            + ") REFERENCES " + vecXSLUtil_3.get(i).toString()
//                            + " (" + vecXSLUtil_42.get(i).toString() + ")";
//                    strTemp = strTemp + " ,\n";
//                    vecFKcreate_02.addElement(strTemp);
//                } else {
//                    j = 1;
//                    strTemp = "    CONSTRAINT FKG_"
//                            + vecXSLUtil_02.elementAt(i).toString() + "_" + j
//                            + " FOREIGN KEY ("
//                            + vecXSLUtil_12.elementAt(i).toString()
//                            + ") REFERENCES " + vecXSLUtil_3.get(i).toString()
//                            + " (" + vecXSLUtil_42.get(i).toString() + ")";
//                    strTemp = strTemp + " ,\n";
//                    vecFKcreate_02.addElement(strTemp);
//                }
//                j++;
//                i++;
//            } // end while
//        } // end if
//        int i_fk = vecFKcreate_01.size();
//        int i_fkg = vecFKcreate_02.size();
//
//        strTemp = "";
//        if (i_fk != 0) {
//            i = 0;
//            while (i < i_fk) {
//                strTemp = strTemp + vecFKcreate_01.elementAt(i).toString();
//                i++;
//            }
//        }
//        
//        if (i_fkg != 0) {
//            i = 0;
//            while (i < i_fkg) {
//                strTemp = strTemp + vecFKcreate_02.elementAt(i).toString();
//                i++;
//            }
//        }
//        
//        if (strTemp.length() != 0) {
//            strTemp = strTemp.substring(0, strTemp.length() - 3);
//        }
//        return strTemp;
//    }
 
    /**
     * Create SQLdrop.sql file in which are all SQL DROP statements.
     * There is one SQLdrop.sql file for entire database.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    static public void createSQLdrop(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        String  strTmp = new String ();
        String  strTemp = new String ();
        String  strProjectRoot = Common.getProjectRoot();
        String  strFileSep = System.getProperty("file.separator");
        String  strSqlDrop = new String ();

        strSqlDrop = strProjectRoot + strFileSep + "SQLdrop.sql";
        File  fileSqlDrop = new File (strSqlDrop);

        if (fileSqlDrop.exists()) {
            fileSqlDrop.delete();
        }
        fileSqlDrop.createNewFile();
        FileReader  fileRead;
        FileWriter  fileWrite = new FileWriter (fileSqlDrop);
        int i = 0;
        int j = 0;

        // make unique name for Foreign Key constraint when FOREIGN_KEY_GROUP does not exist:
 // "FK_" + TABLE_NAME + "_" + n     ; where is int n > 0.
 if (vecXSLUtilDrop_01.size() > 0) {
            i = 0;
            strTemp = vecXSLUtilDrop_01.elementAt(i).toString();
            strTemp = returnFixedConstraintName(vecXSLUtilDrop_01.elementAt(i).toString(),vecXSLUtilDrop_11.elementAt(i).toString(),"DROP","FK",vecXSLUtilDrop_01.elementAt(i).toString(),vecXSLUtilDrop_11.elementAt(i).toString(),dbVendorName);                    

            vecFKdrop_01.addElement(strTemp);
            i = 1;
            j = 2;
            while (i < vecXSLUtilDrop_01.size()) {
                strTemp = vecXSLUtilDrop_01.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtilDrop_01.elementAt(i).toString())) {
                    strTemp = vecXSLUtilDrop_01.elementAt(i).toString();
                    strTemp = returnFixedConstraintName(strTemp,vecXSLUtilDrop_11.elementAt(i).toString(),"DROP","FK",strTemp,vecXSLUtilDrop_11.elementAt(i).toString(),dbVendorName);        
                    vecFKdrop_01.addElement(strTemp);
                } else {
                    j = 1;
                    strTemp = vecXSLUtilDrop_01.elementAt(i).toString();
                    strTemp = returnFixedConstraintName(strTemp,vecXSLUtilDrop_11.elementAt(i).toString(),"DROP","FK",strTemp,vecXSLUtilDrop_11.elementAt(i).toString(),dbVendorName);         
                    vecFKdrop_01.addElement(strTemp);
                }
                j++;
                i++;
            } // end while
        } // end if
 // make unique name for Foreign Key constraint when FOREIGN_KEY_GROUP exist:
 // "FK_" + TABLE_NAME + "_" + n     ; where is int n > 0.
 // //"FK_" + TABLE_NAME + "_" + REFERENCE_OBJECT/FOREIGN_KEY_GROUP
 if (vecXSLUtilDrop_02.size() > 0) {
            i = 0;
            strTemp = vecXSLUtilDrop_02.elementAt(i).toString() + "_1";
            vecFKdrop_02.addElement(strTemp);
            i = 1;
            j = 2;
            while (i < vecXSLUtilDrop_02.size()) {
                strTemp = vecXSLUtilDrop_02.elementAt(i - 1).toString();
                if (strTemp.equals(vecXSLUtilDrop_02.elementAt(i).toString())) {
                    strTemp = vecXSLUtilDrop_02.elementAt(i).toString();
                    strTemp = returnFixedConstraintName(strTemp,vecXSLUtilDrop_12.elementAt(i).toString(),"DROP","FKG",strTemp,vecXSLUtilDrop_12.elementAt(i).toString(),dbVendorName);         
                    vecFKdrop_02.addElement(strTemp);
                } else {
                    j = 1;
                    strTemp = vecXSLUtilDrop_02.elementAt(i).toString();
                    strTemp = returnFixedConstraintName(strTemp,vecXSLUtilDrop_12.elementAt(i).toString(),"DROP","FKG",strTemp,vecXSLUtilDrop_12.elementAt(i).toString(),dbVendorName);         
                    vecFKdrop_02.addElement(strTemp);
                }
                j++;
                i++;
            } // end while
        } // end if
 // DROP CONSTRAINT Foreign Key when FOREIGN_KEY_GROUP does not exist
        i = 0;
        if (vecXSLUtilDrop_01.size() != 0) {
            while (i < vecXSLUtilDrop_01.size()) {
                StringBuffer  buf = new StringBuffer ();

                buf.append("ALTER TABLE ");
                buf.append(vecXSLUtilDrop_01.elementAt(i).toString());
                buf.append(" DROP CONSTRAINT ");
                buf.append(vecFKdrop_01.get(i).toString());
                buf.append(" ;");
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);  // new line
                i++;
            }
            fileWrite.write(13);
            fileWrite.write(10);  // new line
        }
        // DROP CONSTRAINT Foreign Key when FOREIGN_KEY_GROUP exist
        i = 0;
        if (vecXSLUtilDrop_02.size() != 0) {
            while (i < vecXSLUtilDrop_02.size()) {
                StringBuffer  buf = new StringBuffer ();

                buf.append("ALTER TABLE ");
                buf.append(vecXSLUtilDrop_02.elementAt(i).toString());
                buf.append(" DROP CONSTRAINT ");
                buf.append(vecFKdrop_02.get(i).toString());
                buf.append(" ;");
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);  // new line
                i++;
            }
            fileWrite.write(13);
            fileWrite.write(10);  // new line
        }
        // DROP Unique Constraints
        i = 0;
        if (vecDropUnique.size() != 0) {
            while (i < vecDropUnique.size()) {
                StringBuffer  buf = new StringBuffer ();

                buf.append(vecDropUnique.elementAt(i).toString());
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);  // new line
                i++;
            }
            fileWrite.write(13);
            fileWrite.write(10);  // new line
        }
        // DROP INDEX
        i = 0;
        if (vecDropIndex.size() != 0) {
            while (i < vecDropIndex.size()) {
                StringBuffer  buf = new StringBuffer ();

                buf.append(vecDropIndex.elementAt(i).toString());
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);  // new line
                i++;
            }
            fileWrite.write(13);
            fileWrite.write(10);  // new line
        }
        // DROP TABLE
        i = 0;
        if (vecDropTable.size() != 0) {
            while (i < vecDropTable.size()) {
                StringBuffer  buf = new StringBuffer ();

                buf.append(vecDropTable.elementAt(i).toString());
                fileWrite.write(buf.toString());
                fileWrite.write(13);
                fileWrite.write(10);  // new line
                i++;
            }
            fileWrite.write(13);
            fileWrite.write(10);  // new line
            fileWrite.write("DROP TABLE objectid ;");
            fileWrite.write(13);
            fileWrite.write(10);  // new line
        }
        fileWrite.close();
    }

    /**
     * Load doml file in memory structure.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    public static void fillHashtables(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        Object  obj1 = null;
        String  s1 = XSLUtil.getAttribute(xslprocessorcontext, elemextensioncall,
                "database", false);

        if (s1 != null) {
            obj1 = XSLUtil.evaluate(xslprocessorcontext, elemextensioncall, s1);
            if (obj1 == null) {
                throw new WrappedRuntimeException(new IllegalArgumentException ("bad \"select\" attribute ?!"));
            }
        }
        strDatabase = obj1.toString();
    }

    /**
     *
     *
     * @param strUsedDatabase
     * @param s2
     *
     * @throws Exception
     */
    public static void fillHashtables(String  strUsedDatabase, String  s2) throws Exception  {
        strDatabase = strUsedDatabase;
        
    }

    /**
     *
     *
     * @param strKey
     *
     * @param dbVendor
     *
     * @throws Exception
     */
    public static String  getDodsProperty(String  strKey, String  dbVendor) throws Exception  {
        String  strTemp;

        if (dbVendor != null) {
            strTemp = Common.getDodsConfProperty(strKey, dbVendor);
        } else {
            strTemp = Common.getDodsConfProperty(strKey, strDatabase);
        }
        return strTemp;
    }
    
    /**
     *
     *
     * @param strKey
     *
     * @throws Exception
     */
    public static String  getDodsProperty(String  strKey) throws Exception  {
        String  strTemp = Common.getDodsConfProperty(strKey, strDatabase);

        return strTemp;
    }

    /**
     *
     *
     * @param strKey
     *
     * @throws Exception
     */
    public static String  getDataType(String  strKey) throws Exception  {
        String  strDataType = "JDBCtype/" + strKey;

        strDataType = getDodsProperty(strDataType);
        return strDataType;
    }
    
    /**
     *
     *
     * @param strKey
     * @param dbVendor
     * @throws Exception
     */
    public static String  getDataType(String  strKey, String  dbVendor) throws Exception  {
        String  strDataType = "JDBCtype/" + strKey;

        strDataType = getDodsProperty(strDataType, dbVendor);
        return strDataType;
    }
    
    /**
     * Create SQLcreate.sql file where are all SQL CREATE statements.
     * This one SQLcreate.sql file is for entire database.
     *
     * @param xslprocessorcontext
     * @param elemextensioncall
     *
     * @throws Exception
     */
    public static void createSQLcomplete(XSLProcessorContext xslprocessorcontext, ElemExtensionCall elemextensioncall) throws Exception  {
        String  strProjectRoot = Common.getProjectRoot();
        Vector  vecUrlOfSqlFiles = new Vector ();

        vecUrlOfSqlFiles = findSQLFiles(new File (strProjectRoot));
        String  strUrlOfSqlFile;
        String  strFileSep = System.getProperty("file.separator");
        String  strSqlDrop = new String ();

        strSqlDrop = strProjectRoot + strFileSep + "SQLdrop.sql";
        strSqlDrop = strSqlDrop.replace('/', '\\');
        strSqlDrop = strSqlDrop.replace('\\', '/');
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            if (strFileSep != "/") {
                strSqlDrop = strSqlDrop.replace('/', '\\');
            }
        }
        String  strSqlComplete = new String ();

        strSqlComplete = strProjectRoot + strFileSep + "SQLcreate.sql";
        strSqlComplete = strSqlComplete.replace('/', '\\');
        strSqlComplete = strSqlComplete.replace('\\', '/');
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            if (strFileSep != "/") {
                strSqlComplete = strSqlComplete.replace('/', '\\');
            }
        }
        File  fileSqlComplete = new File (strSqlComplete);

        if (fileSqlComplete.exists()) {
            fileSqlComplete.delete();
        }
        fileSqlComplete.createNewFile();
        FileReader  fileRead;
        FileWriter  fileWrite = new FileWriter (fileSqlComplete);
        int i = 0;
        int ii;

        while (i < vecUrlOfSqlFiles.size()) {
            strUrlOfSqlFile = vecUrlOfSqlFiles.get(i).toString();
            if (!strUrlOfSqlFile.equalsIgnoreCase(strSqlDrop)
                    && !strUrlOfSqlFile.equalsIgnoreCase(strSqlComplete)) {
                fileRead = new FileReader (strUrlOfSqlFile);
                ii = fileRead.read();
                while (ii != -1) {
                    fileWrite.write(ii);
                    ii = fileRead.read();
                }
                fileRead.close();
            }
            i++;
        }
        fileWrite.write(13);
        fileWrite.write(10);  // new line
        fileWrite.write(13);
        fileWrite.write(10);  // new line
        fileWrite.write(13);
        fileWrite.write(10);  // new line
        fileWrite.write("create table objectid");
        fileWrite.write(13);
        fileWrite.write(10);  // new line
        fileWrite.write("(");
        fileWrite.write(13);
        fileWrite.write(10);  // new line
        fileWrite.write("    next " + getDodsProperty("OidDbType")
                + " NOT NULL PRIMARY KEY");
        fileWrite.write(13);
        fileWrite.write(10);  // new line
        fileWrite.write(");");
        fileWrite.write(13);
        fileWrite.write(10);  // new line
        fileWrite.close();
    }

    /**
     * Method findSQLFiles finds all SQL files (all files which contain ".sql" in their name) in a working directory and
     * all its subdirecories and puts their URL's into Vector.
     * If there is an error Exception "Ecxeption" is thrown.
     *
     * @param fDirectory The URL of the working directory.
     *
     * @return Vector The URLs of all output SQL files in working directory and in all its subdirectories.
     *
     * @throws Exception
     */
    public static Vector  findSQLFiles(File  fDirectory) {
        Vector  vPathDirectory = new Vector ();
        File [] arrFileSql;

        try {
            if ((arrFileSql = fDirectory.listFiles()) != null) {
                int i = 0;

                while (i < arrFileSql.length) {
                    if (arrFileSql[i].isDirectory()) {
                        Vector  vTemp = findSQLFiles(arrFileSql[i]);

                        for (int j = 0; j < vTemp.size(); j++) {
                            vPathDirectory.addElement(vTemp.get(j));
                        }
                    } else if (arrFileSql[i].toString().toUpperCase().indexOf(".SQL")
                            != -1) {
                        vPathDirectory.addElement(arrFileSql[i]);
                    }
                    i++;
                }
            } else {
                System.out.println("Directory " + fDirectory.toString()
                        + " doesn't exist");
            }
        } catch (Exception  se) {
            System.out.println("error " + se.getMessage());
        }
        return  vPathDirectory;
    }
    
    /**
     * Fix default values for SQL data types. If default value isn't correct,
     * appropriate value for specified SQL type will be taken.
     *
     * @param type Java type.
     * @param value Default value.
     *
     * @return Corrected default value for specified SQL type.
     */
    public static String  fixDefaultSQL(String  type, String  value) {
        if (null == value) {
            value = "";
        }
        String  fixedValue = value;
        String  defaultValue = "";

        if (type.equals("DECIMAL") || type.equals("NUMERIC")) {
            if (value.length() == 0) {
                fixedValue = "0.0";
            } else {
                try {
                    java.math.BigDecimal  test = new java.math.BigDecimal (fixedValue);
                } catch (RuntimeException  e) {
                    defaultValue = "0.0";
                }
            }
        } else if (type.equals("INTEGER") || type.equals("tinyint")
                || type.equals("TINYINT") || type.equals("smallint")
                || type.equals("SMALLINT") || type.equals("INT4")
                || type.equals("INT8") || type.equals("MEDIUMINT")) {
            if (value.length() == 0) {
                fixedValue = "0";
            } else {
                try {
                    Integer.parseInt(value);
                } catch (Exception  e) {
                    defaultValue = "0";
                }
            }
        } else if (type.equals("REAL") || type.equals("FLOAT")) {
            if (value.length() == 0) {
                fixedValue = "0.0";
            } else {
                try {
                    Float.valueOf(value);
                } catch (Exception  e) {
                    defaultValue = "0.0";
                }
            }
        } else if (type.equals("BIGINT")) {
            if (value.length() == 0) {
                fixedValue = "0";
            } else {
                try {
                    Long.parseLong(value);
                } catch (Exception  e) {
                    defaultValue = "0";
                }
            }
        } else if (type.equals("DOUBLE")) {
            if (value.length() == 0) {
                fixedValue = "0.0";
            } else {
                try {
                    Double.valueOf(value);
                } catch (Exception  e) {
                    defaultValue = "0.0";
                }
            }
        } else {
            defaultValue = "0";
        }
        
        if ("" != defaultValue) {
            fixedValue = defaultValue;
        }
        
        return fixedValue;
    }
    
    static public String  returnFixedConstraintName(String  namePrefix, String  nameSufix ,String  operation ,String  counterType, String  counterKeyPrefix , String  counterKey,  String  dbVendor ){
//      private static HashMap counterMap = new HashMap();
//      private static HashMap nameMap = new HashMap();
 
        if(dbVendor!="" && (!dbVendorName.equalsIgnoreCase(dbVendor))){
            dbVendorName=dbVendor;
        }
        Integer  keyLength=null;
        String  result="";
        if(namePrefix.equalsIgnoreCase("")||nameSufix.equalsIgnoreCase("")){
            result=namePrefix+nameSufix;
        }else{
            result=namePrefix+"_"+nameSufix;
        }
        
        String  keyLengthStr = Common.getDodsConfProperty("ConstraintNameLength", dbVendorName);
        if (keyLengthStr!=null){
            try {
                keyLength  = new Integer (keyLengthStr);
            } catch (NumberFormatException  e) {}
        }
        String  counterMapKey;
        if (counterType.equalsIgnoreCase("PK") || counterType.equalsIgnoreCase("PKG")){
            counterMapKey=counterType+":://"; // +counterKeyPrefix+counterKey;
        }else if(counterType.equalsIgnoreCase("I")){
            counterMapKey=counterType+":://";
        }else{
            counterMapKey=counterType+":://";//+counterKeyPrefix;
        }
        String  nameMapKey=counterType+counterKeyPrefix+counterKey;
        int counter = 0;
        if (operation.equalsIgnoreCase("CREATE")){
            boolean cuted=false;
            if (keyLength!=null && keyLength.intValue()>=minKeyLength && result.length()>keyLength.intValue()){
                result=result.substring(0,keyLength.intValue()-maxCounterLength-1);
                counterMapKey=counterMapKey+":///"+result;
                if (!counterMap.containsKey(counterMapKey)){
                    counter = 1;
                }else{
                    counter = ((Integer )counterMap.get(counterMapKey)).intValue()+1;
                }
                counterMap.put(counterMapKey,new Integer (counter));

                cuted=true; 
            }
            if( cuted || counterType.equalsIgnoreCase("FKG")){
                result=result+"_"+counter;
            }
            nameMap.put(nameMapKey,result);
        }else if (operation.equalsIgnoreCase("DROP")){
            result=(String )nameMap.get(nameMapKey);
            if (result==null){
            }
        }
        return result;
    }   
}
