
package org.enhydra.dods.wizard;

import java.awt.Button ;
import java.awt.Dialog ;
import java.awt.Dimension ;
import java.awt.Font ;
import java.awt.Frame ;
import java.awt.GridBagLayout ;
import java.awt.Panel ;
import java.awt.SystemColor ;
import java.awt.TextArea ;
import java.awt.event.ActionEvent ;
import java.awt.event.ActionListener ;
import java.awt.event.KeyAdapter ;
import java.awt.event.KeyEvent ;
import java.awt.event.WindowEvent ;

/**
 * This trace dialog is used for showing output of ExecThread class.
 *
 * @author Nenad Vico
 * @version 1.0
 */
public class TraceDialog extends Dialog  {
    Panel  mainPanel;
    GridBagLayout  gridBagLayout;
    XYLayout xyLayout;
    Button  bOK;
    TextArea  taTrace;
    Process  process;

    /**
     * Consrtuctor(Frame, String)
     *
     * @param frame Frame from which the Trace Dialog has been invited.
     * @param title Title of the Trace Dialog.
     */
    public TraceDialog(Frame  frame, String  title) {
        super(frame, title, false);
        mainPanel = new Panel ();
        xyLayout = new XYLayout();
        bOK = new Button ();
        taTrace = new TextArea ();
        enableEvents(64L);
        try {
            jbInit();
            add(mainPanel);
            pack();
        } catch (Exception  exception) {
            exception.printStackTrace();
        }
        this.setResizable(false);
        this.setSize(new Dimension (790, 560));
    }

    private void jbInit()
        throws Exception  {
        mainPanel.setLayout(xyLayout);
        mainPanel.setBackground(SystemColor.control);
        mainPanel.setSize(new Dimension (790, 560));
        taTrace.setColumns(122);
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            taTrace.setRows(34);
        } else {
            taTrace.setRows(39);
        }
        taTrace.setBackground(SystemColor.control);
        taTrace.setEditable(false);
        taTrace.setFont(new Font ("Dialog", 0, 10));
        taTrace.setSize(new Dimension (750, 560));
        bOK.setLabel("Cancel");
        bOK.addActionListener(new ActionListener () {
            public void actionPerformed(ActionEvent  actionevent) {
                bOK_actionPerformed(actionevent);
            }
        });
        bOK.addKeyListener(new KeyAdapter () {
            public void keyPressed(KeyEvent  keyevent) {
                bOKKeyPressed(keyevent);
            }
        });
        mainPanel.add(taTrace, new XYConstraints(12, 10, 758, 490));
        mainPanel.add(bOK, new XYConstraints(330, 508, 80, 20));
    }

    /**
     * Set default focus on buttom.
     */
    public void setDefaultFocus() {
        bOK.requestFocus();
    }

    /**
     * Appends new line Trace Dialog.
     * 
     * @param s Line that will be appended to Trace Dialog.
     */
    public void appendLine(String  s) {
        taTrace.append(s);
    }

    /**
     * Set name to the button.
     * 
     * @param s Name of the button.
     */
    public void setButtonName(String  s) {
        bOK.setLabel(s);
    }

    protected void processWindowEvent(WindowEvent  windowevent) {
        if (windowevent.getID() == 201) {
            cancel();
        }
        super.processWindowEvent(windowevent);
    }

    void cancel() {
        dispose();
    }

    void bOK_actionPerformed(ActionEvent  actionevent) {
        cancel();
    }

    void bOKKeyPressed(KeyEvent  keyevent) {
        int i = keyevent.getKeyCode();

        if (i == 27 || i == 10) {
            cancel();
        }
    }
}
