
package org.enhydra.dods.wizard;

import java.awt.Button ;
import java.awt.Dialog ;
import java.awt.Dimension ;
import java.awt.Font ;
import java.awt.Frame ;
import java.awt.GridBagConstraints ;
import java.awt.GridBagLayout ;
import java.awt.Insets ;
import java.awt.Label ;
import java.awt.Panel ;
import java.awt.SystemColor ;
import java.awt.event.ActionEvent ;
import java.awt.event.ActionListener ;
import java.awt.event.KeyAdapter ;
import java.awt.event.KeyEvent ;
import java.awt.event.WindowEvent ;

/**
 * This class is used for showing different dialog messages.
 * 
 * @author Nenad Vico
 * @version 1.0
 */
public class MessageDialog extends Dialog  {
    Panel  mainPanel;
    GridBagLayout  gridBagLayout;
    Label  lMessage;
    Button  bOK;
    Label  lEmpty2;
    Label  lEmpty3;
    Label  lEmpty4;

    /**
     * Constructor (String, Frame, String, boolean).
     * 
     * @param message Message that will be shown in the dialog.
     * @param frame Frame that calls dialog with the massage.
     * @param title Title of the dialog.
     * @param modal True if Dialog needs to be modal, otherwise false.
     */
    public MessageDialog(String  message, Frame  frame, String  title, boolean modal) {
        super(frame, title, modal);
        mainPanel = new Panel ();
        gridBagLayout = new GridBagLayout ();
        lMessage = new Label ();
        bOK = new Button ();
        lEmpty2 = new Label ();
        lEmpty3 = new Label ();
        lEmpty4 = new Label ();
        enableEvents(64L);
        try {
            jbInit();
            lMessage.setText(message);
            add(mainPanel);
            pack();
        } catch (Exception  exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Constructor (String, Frame).
     * Created Dialog is modal.
     * 
     * @param message Message that will be shown in the dialog.
     * @param frame Frame that calls dialog with the massage.
     */
    public MessageDialog(String  message, Frame  frame) {
        this(message, frame, "", true);
    }

    /**
     * Constructor (String, Frame, boolean).
     * 
     * @param message Message that will be shown in the dialog.
     * @param frame Frame that calls dialog with the massage.
     * @param modal True if Dialog needs to be modal, otherwise false.
     */ 
    public MessageDialog(String  message, Frame  frame, boolean modal) {
        this(message, frame, "", modal);
    }

    /**
     * Constructor (String, Frame, String).
     * Created dialog is modal.
     * 
     * @param message Message that will be shown in the dialog.
     * @param frame Frame that calls dialog with the massage.
     * @param title Title of the dialog.
     */
    public MessageDialog(String  message, Frame  frame, String  title) {
        this(message, frame, title, true);
    }

    private void jbInit() throws Exception  {
        mainPanel.setLayout(gridBagLayout);
        mainPanel.setBackground(SystemColor.control);
        mainPanel.setSize(new Dimension (500, 400));
        lMessage.setFont(new Font ("Dialog", 1, 12));
        lMessage.setAlignment(1);
        lMessage.setText("Message");
        bOK.setLabel("OK");
        lEmpty4.setAlignment(1);
        bOK.addActionListener(new ActionListener () {
            public void actionPerformed(ActionEvent  actionevent) {
                bOK_actionPerformed(actionevent);
            }
        });
        bOK.addKeyListener(new KeyAdapter () {
            public void keyPressed(KeyEvent  keyevent) {
                bOKKeyPressed(keyevent);
            }
        });
        mainPanel.add(lMessage,
                new GridBagConstraints (0, 0, 3, 1, 0.0D, 0.0D, 10, 1,
                new Insets (0, 0, 0, 4), 10, 30));
        mainPanel.add(bOK,
                new GridBagConstraints (0, 2, 3, 1, 0.0D, 0.0D, 10, 3,
                new Insets (0, 0, 0, 1), 29, 0));
        mainPanel.add(lEmpty2,
                new GridBagConstraints (0, 0, 1, 3, 0.0D, 0.0D, 10, 1,
                new Insets (0, 0, 0, 18), 0, 0));
        mainPanel.add(lEmpty3,
                new GridBagConstraints (2, 0, 1, 3, 0.0D, 0.0D, 10, 1,
                new Insets (0, 0, 0, 22), 0, 0));
        mainPanel.add(lEmpty4,
                new GridBagConstraints (0, 3, 3, 1, 0.0D, 0.0D, 10, 1,
                new Insets (0, 0, 0, 0), 0, 0));
    }

    protected void processWindowEvent(WindowEvent  windowevent) {
        if (windowevent.getID() == 201) {
            cancel();
        }
        super.processWindowEvent(windowevent);
    }

    void cancel() {
        dispose();
    }

    void bOK_actionPerformed(ActionEvent  actionevent) {
        cancel();
    }

    void bOKKeyPressed(KeyEvent  keyevent) {
        int i = keyevent.getKeyCode();

        if (i == 27 || i == 10) {
            cancel();
        }
    }
}
