
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 */

/*
 *
 * @author    Nenad Vico
 * @version   1.0.0
 *
 */
package org.enhydra.dods.wizard;

import java.awt.Dimension ;
import java.awt.Toolkit ;
import javax.swing.UIManager ;
import org.enhydra.dods.generator.DODSGenerator;
import org.enhydra.dods.generator.DODSWizard;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 * @author Nenad Vico
 * @version 1.0
 */

/**
 * DODS Generator Wizard's main class.
 */
public class DefaultDODSWizard extends DODSWizard {
    public static WizardFrame1 frame = null;
    boolean packFrame = false;
    public DefaultDODSWizard(DODSGenerator generator) {
        super(generator);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    public void startup() {
        frame = new WizardFrame1();
        if (packFrame) {
            frame.pack();
        } else {
            frame.validate();
        }
        // Center the window
 Dimension  screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension  frameSize = frame.getSize();

        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2,
                (screenSize.height - frameSize.height) / 2);
        frame.setVisible(true);
        frame.setDefaultFocus();
    }
    
}
