
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: DefaultTagValues.java,v 1.1 2004/09/03 13:43:13 sinisa Exp $
 */

/*
 *
 * @author    Nenad Vico
 * @since     LBS1.8
 * @version   $Revision: 1.1 $
 *
 */
package org.enhydra.dods.trans;

import org.enhydra.dods.Common;

/**
 * This class contains default values for Table, Column and Referrer class attributes.
 */
public class DefaultTagValues {
    
    // Default values for table 
 public static final String  TABLE_AUTHOR = "NN"; 
    public static final String  TABLE_PROJECT_NAME = "DODS Project"; 
    public static final String  TABLE_TEMPLATE_SET = "standard"; 
    public static String  TABLE_EXTENDS_VALUE = "com.lutris.dods.builder.generator.dataobject.GenericDO"; 
    public static String  TABLE_DB_VENDOR = "Standard"; 
    public static String  TABLE_STRING_MATCH = "LIKE"; 
    public static String  TABLE_STRING_WILDCARD = "%"; 
    public static boolean TABLE_DELETE_CASCADE = false;
    public static boolean MASS_UPDATES = false;
    public static boolean MASS_DELETES = false;
    
    public static final boolean DO_IS_OID_BASED = true;
    public static final boolean DO_SECURITY = false;
    public static final boolean DO_NON_SECURITY = true;    
    public static final boolean DO_MULTIDB = false;
    public static final boolean IS_ANY_COLUMN_SECURE = false;    
    public static final boolean DATABASE_SECURITY = false;
    public static final boolean DATABASE_NON_SECURITY = true;    
    public static final boolean DATABASE_MASS_UPDATE = false;
    public static final boolean DATABASE_MASS_DELETE = false;    
    
    // Default values for column 
 public static final boolean COLUMN_IS_REFERENCE = false; 
    public static final boolean COLUMN_REF_CONSTARINT = false; 
    public static final boolean COLUMN_REF_IS_ABSTARCT = false; 
    public static final boolean COLUMN_REF_IS_FOREIGN_KEY = false; 
    public static final String   COLUMN_REF_FOREIGN_KEY_COLUMN_NAME = null; 
    public static final boolean COLUMN_IS_CONSTANT = false; 
    public static final String   COLUMN_DB_TYPE = "VARCHAR"; 
    public static final String   COLUMN_JAVA_TYPE = "String"; 
    public static final boolean COLUMN_USED_FOR_QUERY = true; 
    public static final boolean COLUMN_CAN_BE_NULL = false; 
    public static final boolean COLUMN_IS_PRIMARY_KEY = false; 
    public static final boolean COLUMN_IS_ARRAY = false; 
    public static final boolean COLUMN_IS_INDEX = false; 
    public static final boolean COLUMN_IS_UNIQUE = false; 
    public static final boolean COLUMN_SECURITY = false;
    public static final boolean COLUMN_NON_SECURITY = true;    

    

    /**
     * Load default values which depend on database.
     *
     * @param database Database which is used in doml file.
     */
    public static void loadDatabaseValues(String  database) {
        TABLE_DB_VENDOR = database;
        TABLE_DELETE_CASCADE = Common.getDodsConfProperty("DeleteCascade", database).equals("true");
    }

    /**
     * Get default size of column.
     * 
     * @param dbType Database type.
     * @param javaType Java type.
     *
     * @return Default size of column.
     */
    public static String  getDefaultSize(String  dbType, String  javaType) {
        if (dbType.equalsIgnoreCase("VARCHAR")) { 
            return "32";
        }    
        if (dbType.equalsIgnoreCase("VARCHAR2")) { 
            return "32";
        }    
        if (dbType.equalsIgnoreCase("NVARCHAR2")) { 
            return "32";
        }    
        if (dbType.equalsIgnoreCase("RAW")) { 
            return "32";
        }    
        if (dbType.equalsIgnoreCase("CHAR")) { 
            return "32";
        }    
        if (dbType.equalsIgnoreCase("NCHAR")) { 
            return "32";
        }    
        if (dbType.equalsIgnoreCase("NUMBER")) { 
            return "19,0";
        }  
        if (dbType.equalsIgnoreCase("NUMERIC")) { 
            return "19,0";
        }  
        if (dbType.equalsIgnoreCase("BINARY")) { 
            return "8";
        }
        if (javaType.equalsIgnoreCase("BigDecimal")) { 
            return "19,0";
        }  
        if (javaType.equalsIgnoreCase("java.math.BigDecimal")) { 
            return "19,0";
        }  
        return null;  // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! not finished
    }
}
