
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 */

/*
 *
 * @author    Nenad Vico
 * @version   1.0.0  2003/02/26
 *
 */
package org.enhydra.dods.generator;

import java.io.BufferedReader ;
import java.io.IOException ;

/**
 * This thread is used for reading error messages occured while executing process. 
 */
public class ErrorReader extends Thread  {
    BufferedReader  er;
    boolean trace = false;

    /**
     * Constructor.
     *
     * @param bufferedReader buffer reading that reads error messages.
     */
    public ErrorReader(BufferedReader  bufferedReader) {
        er = bufferedReader;
    }

    /**
     * Constructor.
     *
     * @param bufferedReader buffer reading that reads error messages.
     * @param trace dialog that shows error messages.
     */
    public ErrorReader(BufferedReader  bufferedReader, boolean trace) {
        er = bufferedReader;
        this.trace = trace;
    }

    public void run() {
        try {
            for (; !er.ready(); Thread.sleep(100L)) {}
            String  s;

            while ((s = er.readLine()) != null) {
                if (trace) {
                    System.out.println(s + "\n");
                }
            }
        } catch (IOException  e) {} catch (InterruptedException  e) {}
    }
}
