
/*
 * Title:        DODS Ant task
 * Description:  DODS
 */
package  org.enhydra.ant.taskdefs;

import java.io.File ;
import java.util.ArrayList ;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Touch;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.enhydra.dods.Common;

/**
 * @author Sinisa Milosevic
 * Invoke DODS to generate a set of java classes from a doml file<BR>
 * The files will only be regenerated/compiled if the date on the doml file is
 * newer than at least one of the generated files<BR>
 * This taskdef extends Ant's <javac> task; refer to that documentation for
 * parameters that affect compilation.<BR>
 * Typically made visible to an Ant build file with the following declaration:<PRE>
 *  &lt;taskdef name="dods" classname="org.enhydra.ant.taskdefs.Dods"/&gt;</PRE>
 *
 * <B>Parameters</B><PRE>
 *
 * doml       - The doml input file describing data object mapping. Required = Yes
 * outdir     - Target for generated classes, expressed as a directory path. Required = Yes
 * tablesonly - If this attribute is set to true dods tast generate only tables.xml. Required = No
 * force      - Force DODS to always be regenerated source files. Required = No</PRE>
 *<BR>
 * Examples<PRE>
 * &lt;dods doml="${basedir}/discRack.doml"
 *        outdir="${basedir}/src"/&gt;</PRE>
 *
 */
public class DODS_XMLBuilder extends org.apache.tools.ant.taskdefs.Javac {
    protected File  domlFile = null;
    protected File  sourceoutDir = null;
    protected String  database = null;
    protected boolean forceBuild = false;
    protected boolean tablesOnly = false;
    protected String   configDir = null;
    public static class BooleanAttribute extends EnumeratedAttribute {

        /**
         *  Set value for Boolean parameters
         */
        public String [] getValues() {
            return (new String [] {"yes", "no", "true", "false" });
        }

        public BooleanAttribute() {}
    }
    public DODS_XMLBuilder() {
        domlFile = null;
        sourceoutDir = null;
        tablesOnly = false;
    }

    /**
     * Simply invoke DODS Generator, and then compile the generated files
     * @exception org.apache.tools.ant.BuildException
     */
    public void execute() throws org.apache.tools.ant.BuildException {
        
        try {
            if (configDir != null) {
                Common.setConfigDir(configDir);
            }
            
        } catch (Error  e) {
            throw new BuildException("path to dodsConf.xml must be valid");
        }   
        if (domlFile == null) {
            throw new BuildException("doml attribute must be set!");
        }
        if (sourceoutDir == null) {
            throw new BuildException("outdir attribute must be set!");
        }
        if (!sourceoutDir.isDirectory()) {
            throw new BuildException("outdir must be a valid directory!");
        }
        File  domlTmp = null;

        if (domlTmp == null) {
            String  s = domlFile.getAbsolutePath().toLowerCase();
            int i = s.indexOf(".doml");

            if (i > -1) {
                domlTmp = new File (domlFile.getAbsolutePath().substring(0, i)
                        + ".uptodate");
            } else {
                domlTmp = new File (domlFile.getAbsolutePath() + ".uptodate");
            }
        }
        boolean regen = !sourceoutDir.exists() || !domlTmp.exists()
                || domlTmp.lastModified() < domlFile.lastModified();

        if (regen) {
            (this).project.log("Regenerating DODS files from " + domlFile
                    + "... ");
        } else {
            (this).project.log(String.valueOf(((java.lang.Object ) (domlFile)))
                    + " up to date.",
                    2);
        }
        if (regen || forceBuild) {
 
            java.util.ArrayList  argsList = new ArrayList ();

            argsList.add((new Boolean (tablesOnly)).toString());
            if (database != null) {
                argsList.add(database);
            }
            try {
                String  dodsClassName = "org.enhydra.dods.trans.TransientXMLBuilderFactory";
                java.lang.reflect.Method  m = null;
                java.lang.Class  c = null;

                try {
                    c = java.lang.Class.forName(dodsClassName);
                    m = c.getMethod("main", new java.lang.Class [] {
                        String [].class
                    });
                } catch (java.lang.Exception  e) {
                    ((java.lang.Throwable ) (e)).printStackTrace();
                    throw new BuildException(((java.lang.Throwable ) (e)));
                }
                String  args[] = (String []) argsList.toArray(((java.lang.Object []) (
                        new String [argsList.size()])));

                if (m != null) {
                    m.invoke(((java.lang.Object ) (null)),
                            new java.lang.Object [] {
                        args
                    });
                }
            } catch (java.lang.reflect.InvocationTargetException  ite) {
                ite.printStackTrace();
                throw new BuildException(((java.lang.Throwable ) (ite)));
            } catch (java.lang.Exception  e) {
                ((java.lang.Throwable ) (e)).printStackTrace();
                throw new BuildException(((java.lang.Throwable ) (e)));
            }
            if (!tablesOnly) {
                org.apache.tools.ant.taskdefs.Touch touch = new Touch();

                ((org.apache.tools.ant.ProjectComponent) (touch)).setProject((this).project);
                touch.setFile(domlTmp);
                touch.execute();
            }
        }
    }

    /**
     * Sets the doml descriptor file.
     * @param domlFile - The doml input file describing data object mapping
     */
    public void setDoml(File  domlFile) {
        this.domlFile = domlFile;
    }

    /**
     * The destination directory into which the generated sources are written
     * @param sourceout - Target for generated classes, expressed as a directory
     * path
     */
    public void setOutdir(File  sourceout) {
        sourceoutDir = sourceout;
    }

    /**
     * Set the database vendor for creating sql
     *
     * @param database database vendor for creating sql
     */
    public void setDatabase(String  database) {
        this.database = database;
    }

    /**
     * Sets tablesOnly property.
     * @param isTablesOnly - new tablesOnly value.
     */
    public void setTablesonly(boolean isTablesOnly) {
        tablesOnly = isTablesOnly;
    }

    /**
     * Force DODS to always be regenerated source files
     * @param force - Set to "true" or "false"
     */
    public void setForce(String  force) {
        forceBuild = (new Boolean (force)).booleanValue();
    }

    /**
     * Returns curent configurationDir (folder with dodsConf.xml file).
     * @return Curent configurationDir.
     */
    public String  getConfigDir() {
        return configDir;
    }

    /**
     * @param string
     */
    public void setConfigDir(String  string) {
        configDir = string;
    }
}
