
/*
 * Title:        DODS Ant task
 * Description:  DODS
 */
package  org.enhydra.ant.taskdefs;

import java.io.File ;
import java.util.ArrayList ;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;

/**
 * @author Sinisa Milosevic
 * Invoke DODS to generate a list of java classes from a doml file<BR>
 * This taskdef extends Ant's <Task> task;<BR>
 * Typically made visible to an Ant build file with the following declaration:<PRE>
 *  &lt;taskdef name="dods" classname="org.enhydra.ant.taskdefs.ODS_DOClassFinder"/&gt;</PRE>
 *
 * <B>Parameters</B><PRE>
 *
 * doml       - The doml input file describing data object mapping. Required = Yes
 * outdir     - Target for generated classes, expressed as a directory path. Required = Yes
 *<BR>
 * Examples<PRE>
 * &lt;dods doml="${basedir}/discRack.doml"
 *        outdir="${basedir}/src"/&gt;</PRE>
 *
 */
public class DODS_DOClassFinder extends org.apache.tools.ant.Task {
    protected File  domlFile = null;
    public static class BooleanAttribute extends EnumeratedAttribute {

        /**
         *  Set value for Boolean parameters
         */
        public String [] getValues() {
            return (new String [] {"yes", "no", "true", "false" });
        }

        public BooleanAttribute() {}
    }
    public DODS_DOClassFinder() {
        domlFile = null;
    }

    /**
     * Simply invoke DODS Generator, and then compile the generated files
     * @exception org.apache.tools.ant.BuildException
     */
    public void execute() throws org.apache.tools.ant.BuildException {
        
        if (domlFile == null) {
            throw new BuildException("doml attribute must be set!");
        }
       boolean regen = true;
        if (regen) {
            (this).project.log("Regenerating ClassList files from " + domlFile
                    + "... ");
        } else {
            (this).project.log(String.valueOf(((java.lang.Object ) (domlFile)))
                    + " up to date.",
                    2);
        }
        if (regen) {
 
            java.util.ArrayList  argsList = new ArrayList ();

            argsList.add("ClassList");
            try {
                String  dodsClassName = "org.enhydra.dods.trans.TransientXMLBuilderFactory";
                java.lang.reflect.Method  m = null;
                java.lang.Class  c = null;

                try {
                    c = java.lang.Class.forName(dodsClassName);
                    m = c.getMethod("main", new java.lang.Class [] {
                        String [].class
                    });
                } catch (java.lang.Exception  e) {
                    ((java.lang.Throwable ) (e)).printStackTrace();
                    throw new BuildException(((java.lang.Throwable ) (e)));
                }
                String  args[] = (String []) argsList.toArray(((java.lang.Object []) (
                        new String [argsList.size()])));

                if (m != null) {
                    m.invoke(((java.lang.Object ) (null)),
                            new java.lang.Object [] {
                        args
                    });
                }
            } catch (java.lang.reflect.InvocationTargetException  ite) {
                ite.printStackTrace();
                throw new BuildException(((java.lang.Throwable ) (ite)));
            } catch (java.lang.Exception  e) {
                ((java.lang.Throwable ) (e)).printStackTrace();
                throw new BuildException(((java.lang.Throwable ) (e)));
            }
        }
    }

    /**
     * Sets the doml descriptor file.
     * @param domlFile - The doml input file describing data object mapping
     */
    public void setDoml(File  domlFile) {
        this.domlFile = domlFile;
    }
    



}
