/*
 * Decompiled with CFR 0.152.
 */
package org.webdocwf.util.sql;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.Vector;
import org.enhydra.dods.xslt.XSLTUtil;

public class SQLSplitter {
    Vector vecTableName = new Vector();
    Vector vecForeignTable = new Vector();
    Vector vecForeignKey = new Vector();
    Vector vecPrimaryKey = new Vector();
    Vector vecReference = new Vector();
    Vector vecConstraintName = new Vector();
    Vector vecPrimaryKeyTableName = new Vector();
    Vector vecPrimaryKeyColumn = new Vector();
    Vector vecDropTableTableName = new Vector();
    Vector vecDropForeignKeys = new Vector();
    Vector vecCreateIndex = new Vector();
    Vector vecConstraintPrimary = new Vector();
    Vector vecFKRest = new Vector();
    boolean splitSQLPrimary = true;

    public static void main(String[] argv) {
        if (argv.length != 2 && argv.length != 3) {
            System.out.println("Usage: SQLSplitter url outputFile\n splitPrimarySql");
            System.out.println(" where url is the URL of working directory \n");
            System.out.println(" outputFile is the path and name of SQL file which will be created \n");
            System.out.println(" and splitPrimarySql force SQLSpliter split PRIMARY part from CREATE to separate file  \n");
            System.out.println(" values are true/false (default value is true).  \n");
            System.exit(1);
        }
        SQLSplitter SQLCommandsChange = new SQLSplitter();
        SQLCommandsChange.setSplitSQLPrimary(true);
        if (argv.length == 3) {
            try {
                SQLCommandsChange.setSplitSQLPrimary(new Boolean(argv[2]));
            }
            catch (Exception e) {
                System.out.println("Usage: SQLSplitter url outputFile\n splitPrimarySql");
                System.out.println(" where url is the URL of working directory \n");
                System.out.println(" outputFile is the path and name of SQL file which will be created \n");
                System.out.println(" and splitPrimarySql force SQLSpliter split PRIMARY part from CREATE to separate file  \n");
                System.out.println(" values are true/false (default value is true).  \n");
                System.exit(1);
            }
        }
        SQLCommandsChange.separateSqlCommands(argv[0], argv[1]);
    }

    public void separateSqlCommands(String strDirectory, String strOutputFile) {
        Vector vPathSQLFiles = new Vector();
        int iStart = 0;
        String strOutputFileBegin = "";
        String strOutputFileEnd = "";
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            if (!strDirectory.endsWith("\\")) {
                strDirectory = strDirectory + "\\";
            }
        } else if (!strDirectory.endsWith("/")) {
            strDirectory = strDirectory + "/";
        }
        if ((iStart = strOutputFile.toLowerCase().indexOf(".sql")) != -1) {
            strOutputFileBegin = strOutputFile.substring(0, iStart);
            strOutputFileEnd = strOutputFile.substring(iStart);
        } else {
            strOutputFileBegin = strOutputFile;
            strOutputFileEnd = ".sql";
        }
        File fWorkingDirectory = new File(strDirectory);
        File fOutputCreateTable = new File(strOutputFileBegin + "Create" + strOutputFileEnd);
        File fOutputAlterTable = new File(strOutputFileBegin + "Integrity" + strOutputFileEnd);
        File fOutputDropTable = new File(strOutputFileBegin + "DropTable" + strOutputFileEnd);
        File fOutputDropIntegrity = new File(strOutputFileBegin + "DropIntegrity" + strOutputFileEnd);
        File fOutputDropPrimary = new File(strOutputFileBegin + "DropPrimary" + strOutputFileEnd);
        File fOutputAlterTablePrimaryKey = new File(strOutputFileBegin + "Primary" + strOutputFileEnd);
        File fOutputAlterTableIndex = new File(strOutputFileBegin + "Index" + strOutputFileEnd);
        File fOutputDropTableIndex = new File(strOutputFileBegin + "DropIndex" + strOutputFileEnd);
        File fOutputOtherSql = new File(strOutputFileBegin + "OtherSql" + strOutputFileEnd);
        if (fOutputCreateTable.exists() || fOutputAlterTable.exists() || fOutputAlterTablePrimaryKey.exists() || fOutputDropTable.exists() || fOutputAlterTableIndex.exists() || fOutputDropIntegrity.exists() || fOutputDropPrimary.exists() || fOutputOtherSql.exists() || fOutputDropTableIndex.exists()) {
            System.out.println("Output SQL file exists. Please choose different name!");
            System.exit(1);
        }
        vPathSQLFiles = this.findSQLFiles(fWorkingDirectory);
        for (int i = 0; i < vPathSQLFiles.size(); ++i) {
            System.out.println("File : " + vPathSQLFiles.get(i).toString() + " is analysing.");
            this.createSQLFile(new File(vPathSQLFiles.get(i).toString()), fOutputCreateTable, fOutputOtherSql);
        }
        if (fOutputCreateTable.length() == 0L) {
            fOutputCreateTable.delete();
        }
        if (fOutputOtherSql.length() == 0L) {
            fOutputOtherSql.delete();
        }
        this.writeAlterTableForeignKey(fOutputAlterTable);
        if (fOutputAlterTable.length() == 0L) {
            fOutputAlterTable.delete();
        }
        this.writeAlterTablePrimaryKey(fOutputAlterTablePrimaryKey);
        if (fOutputAlterTablePrimaryKey.length() == 0L) {
            fOutputAlterTablePrimaryKey.delete();
        }
        this.writeDropTable(fOutputDropTable);
        if (fOutputDropTable.length() == 0L) {
            fOutputDropTable.delete();
        }
        this.writeAlterTableIndex(fOutputAlterTableIndex);
        if (fOutputAlterTableIndex.length() == 0L) {
            fOutputAlterTableIndex.delete();
        }
        this.writeDropIntegrity(fOutputDropIntegrity);
        if (fOutputDropIntegrity.length() == 0L) {
            fOutputDropIntegrity.delete();
        }
        this.writeDropTableIndex(fOutputDropTableIndex);
        if (fOutputDropTableIndex.length() == 0L) {
            fOutputDropTableIndex.delete();
        }
        this.writeDropPrimary(fOutputDropPrimary);
        if (fOutputDropPrimary.length() == 0L) {
            fOutputDropPrimary.delete();
        }
        if (vPathSQLFiles.size() == 0) {
            System.out.println("\n No SQL files in target directory");
        }
    }

    public Vector findSQLFiles(File fDirectory) {
        Vector vPathDirectory;
        block6: {
            vPathDirectory = new Vector();
            try {
                File[] arrFileSql = fDirectory.listFiles();
                if (arrFileSql != null) {
                    for (int i = 0; i < arrFileSql.length; ++i) {
                        if (arrFileSql[i].isDirectory()) {
                            Vector vTemp = this.findSQLFiles(arrFileSql[i]);
                            for (int j = 0; j < vTemp.size(); ++j) {
                                vPathDirectory.addElement(vTemp.get(j));
                            }
                            continue;
                        }
                        if (arrFileSql[i].toString().toUpperCase().indexOf(".SQL") == -1) continue;
                        vPathDirectory.addElement(arrFileSql[i]);
                    }
                    break block6;
                }
                System.out.println("Directory " + fDirectory.toString() + " doesn't exist");
                System.exit(1);
            }
            catch (Exception se) {
                System.out.println("error " + se.getMessage());
                System.exit(1);
            }
        }
        return vPathDirectory;
    }

    public void createSQLFile(File fInputSQLFile, File fCreateTable, File fOther) {
        String strInLine = "";
        String strTableName = "";
        String strRef = "";
        String strForeignTable = "";
        String strForeignKey = "";
        String strPrimaryKey = "";
        String strPrimaryColumn = "";
        String strIndex = "";
        boolean bNextIndexLine = false;
        boolean bNextCreateTableLine = false;
        int iStartPointer = 0;
        int iEndPointer = 0;
        try {
            RandomAccessFile fWriteSQL = new RandomAccessFile(fCreateTable, "rw");
            RandomAccessFile fWriteOtherSql = new RandomAccessFile(fOther, "rw");
            long lWriteSql = fWriteSQL.length();
            long lWriteOtherSql = fWriteOtherSql.length();
            fWriteSQL.seek(lWriteSql);
            fWriteOtherSql.seek(lWriteOtherSql);
            String strWriteSQL = "";
            String strWriteOtherSQL = "";
            RandomAccessFile fReadSQL = new RandomAccessFile(fInputSQLFile, "r");
            while ((strInLine = fReadSQL.readLine()) != null) {
                String strConstraint;
                boolean brojac = false;
                iStartPointer = strInLine.toUpperCase().indexOf("/*");
                if (!(iStartPointer == -1 && (iStartPointer = strInLine.toUpperCase().indexOf("--")) == -1 || bNextIndexLine)) {
                    strInLine = iStartPointer > 0 ? strInLine.substring(0, iStartPointer).trim() : "";
                }
                if ((iStartPointer = strInLine.toUpperCase().indexOf("CREATE TABLE")) != -1 && !bNextIndexLine) {
                    bNextCreateTableLine = true;
                    iEndPointer = strInLine.indexOf("(");
                    strTableName = iEndPointer != -1 ? strInLine.substring(iStartPointer + 12, iEndPointer).trim() : strInLine.substring(iStartPointer + 12).trim();
                    this.addTableName(strTableName);
                }
                int iStartConstraint = 0;
                iStartPointer = strInLine.toUpperCase().indexOf("REFERENCES");
                if (iStartPointer != -1 && strInLine.toUpperCase().indexOf("FOREIGN KEY") == -1 && !bNextIndexLine) {
                    iStartConstraint = strInLine.toUpperCase().indexOf("CONSTRAINT");
                    if (iStartConstraint != -1) {
                        strForeignKey = strInLine.trim().substring(0, strInLine.trim().indexOf(" "));
                        String strTemp = strInLine.substring(iStartPointer + 10).trim();
                        strConstraint = strInLine.substring(iStartConstraint + 10).trim();
                        strInLine = strInLine.substring(0, iStartConstraint - 1) + ",";
                        iEndPointer = strTemp.indexOf(" (");
                        if (iEndPointer != -1) {
                            strForeignTable = strTemp.substring(0, iEndPointer).trim();
                        } else {
                            iEndPointer = strTemp.indexOf("(");
                            if (iEndPointer != -1) {
                                strForeignTable = strTemp.substring(0, iEndPointer).trim();
                            }
                        }
                        iStartPointer = strTemp.indexOf("(");
                        if (iStartPointer != -1 && (iEndPointer = strTemp.indexOf(")")) != -1) {
                            strPrimaryKey = strTemp.substring(iStartPointer + 1, iEndPointer).trim();
                        }
                        if ((iStartPointer = strTemp.indexOf(")")) != -1) {
                            iEndPointer = strTemp.indexOf(",");
                            strRef = iEndPointer != -1 ? strTemp.substring(iStartPointer + 1, iEndPointer).trim() : strTemp.substring(iStartPointer + 1).trim();
                        }
                        strConstraint = strConstraint.trim().substring(0, strConstraint.trim().indexOf(" "));
                        String rest = "";
                        this.addForeignKeyValues(strTableName, strForeignTable, strForeignKey, strPrimaryKey, strRef, strConstraint, rest);
                    } else {
                        strForeignKey = strInLine.trim().substring(0, strInLine.trim().indexOf(" "));
                        String strTemp = strInLine.substring(iStartPointer + 10).trim();
                        strInLine = strInLine.substring(0, iStartPointer - 1) + ",";
                        iEndPointer = strTemp.indexOf(" (");
                        if (iEndPointer != -1) {
                            strForeignTable = strTemp.substring(0, iEndPointer).trim();
                        } else {
                            iEndPointer = strTemp.indexOf("(");
                            if (iEndPointer != -1) {
                                strForeignTable = strTemp.substring(0, iEndPointer).trim();
                            }
                        }
                        iStartPointer = strTemp.indexOf("(");
                        if (iStartPointer != -1 && (iEndPointer = strTemp.indexOf(")")) != -1) {
                            strPrimaryKey = strTemp.substring(iStartPointer + 1, iEndPointer).trim();
                        }
                        if ((iStartPointer = strTemp.indexOf(")")) != -1) {
                            iEndPointer = strTemp.indexOf(",");
                            strRef = iEndPointer != -1 ? strTemp.substring(iStartPointer + 1, iEndPointer).trim() : strTemp.substring(iStartPointer + 1).trim();
                        }
                        strConstraint = strTableName + "_" + strForeignKey;
                        String rest = "";
                        this.addForeignKeyValues(strTableName, strForeignTable, strForeignKey, strPrimaryKey, strRef, strConstraint, rest);
                    }
                }
                iStartConstraint = 0;
                iStartPointer = strInLine.toUpperCase().indexOf("PRIMARY KEY");
                if (iStartPointer != -1 && !strInLine.toUpperCase().trim().startsWith("CONSTRAINT ") && !bNextIndexLine) {
                    String strConstraintPrimary;
                    iStartConstraint = strInLine.toUpperCase().indexOf("CONSTRAINT");
                    if (iStartConstraint != -1) {
                        strPrimaryColumn = strInLine.trim().substring(0, strInLine.trim().indexOf(" "));
                        strConstraintPrimary = strInLine.substring(iStartConstraint + 10).trim();
                        strConstraintPrimary = strConstraintPrimary.trim().substring(0, strConstraintPrimary.trim().indexOf(" "));
                        if (this.isSplitSQLPrimary()) {
                            strInLine = strInLine.substring(0, iStartConstraint - 1) + ",";
                        }
                        this.addPrimaryKeyValues(strTableName, strPrimaryColumn, strConstraintPrimary);
                    } else {
                        strPrimaryColumn = strInLine.trim().substring(0, strInLine.trim().indexOf(" "));
                        if (this.isSplitSQLPrimary()) {
                            strInLine = strInLine.substring(0, iStartPointer - 1) + ",";
                        }
                        strConstraintPrimary = XSLTUtil.returnFixedConstraintName(strTableName, strPrimaryColumn, "CREATE", "Spliter_PK", strTableName, strPrimaryColumn, "");
                        this.addPrimaryKeyValues(strTableName, strPrimaryColumn, strConstraintPrimary);
                    }
                }
                if ((iStartPointer = strInLine.toUpperCase().indexOf("CREATE ")) != -1 && strInLine.toUpperCase().indexOf(" INDEX ") != -1 || bNextIndexLine) {
                    iEndPointer = strInLine.trim().indexOf(";");
                    if (iEndPointer == -1) {
                        bNextIndexLine = true;
                        iEndPointer = strInLine.trim().length() - 1;
                    } else {
                        bNextIndexLine = false;
                    }
                    strIndex = strInLine.trim().substring(0, iEndPointer + 1);
                    if (iStartPointer > 1) {
                        strInLine = strInLine.substring(0, iStartPointer - 1);
                    } else if (iStartPointer != -1) {
                        strInLine = "";
                    }
                    this.addIndexValues(strIndex);
                }
                if ((iStartPointer = strInLine.toUpperCase().indexOf("CONSTRAINT ")) != -1 && strInLine.toUpperCase().indexOf(" FOREIGN KEY") != -1) {
                    int iForeignKey = strInLine.toUpperCase().indexOf(" FOREIGN KEY");
                    strConstraint = strInLine.substring(iStartPointer + 10, iForeignKey).trim();
                    int iReference = strInLine.toUpperCase().indexOf(" REFERENCES ");
                    String strFK = strInLine.substring(iForeignKey + 12, iReference).trim();
                    strFK = strFK.substring(1, strFK.length() - 1);
                    String endLine = strInLine.substring(iReference);
                    int iStartBracket = endLine.indexOf("(");
                    int iEndBracket = endLine.indexOf(")");
                    String strFT = endLine.substring(12, iStartBracket).trim();
                    String strPK = endLine.substring(iStartBracket + 1, iEndBracket).trim();
                    String rest = endLine.substring(iEndBracket + 1).trim();
                    rest = rest.replaceAll(",", " ");
                    strInLine = "";
                    this.addForeignKeyValues(strTableName, strFT, strFK, strPK, strRef, strConstraint, rest);
                }
                if ((iStartPointer = strInLine.toUpperCase().indexOf("CONSTRAINT ")) != -1 && strInLine.toUpperCase().indexOf(" PRIMARY KEY") != -1) {
                    int iPrimaryKey = strInLine.toUpperCase().indexOf(" PRIMARY KEY");
                    strConstraint = strInLine.substring(iStartPointer + 10, iPrimaryKey).trim();
                    int iStartBracket = strInLine.indexOf("(");
                    int iEndBracket = strInLine.indexOf(")");
                    String strPK = strInLine.substring(iStartBracket + 1, iEndBracket).trim();
                    if (this.isSplitSQLPrimary()) {
                        strInLine = "";
                    }
                    this.addPrimaryKeyValues(strTableName, strPK, strConstraint);
                }
                if (strInLine != null && !strInLine.trim().equals("") && bNextCreateTableLine) {
                    strWriteSQL = strWriteSQL.concat(strInLine + "\n");
                } else if (!strInLine.equals("")) {
                    strWriteOtherSQL = strWriteOtherSQL.concat(strInLine + "\n");
                }
                if (strInLine.indexOf(";") == -1 || !bNextCreateTableLine) continue;
                bNextCreateTableLine = false;
            }
            if (!strWriteSQL.equals("")) {
                StringTokenizer tokenizerCreate = new StringTokenizer(strWriteSQL, ";");
                while (tokenizerCreate.hasMoreTokens()) {
                    String strToken = tokenizerCreate.nextToken().trim();
                    if (strToken.equals("")) continue;
                    boolean isOK = true;
                    int endComPos = 0;
                    int endPos = strToken.lastIndexOf(")");
                    if (endPos != -1 && (endComPos = strToken.substring(0, endPos).lastIndexOf(",")) != -1) {
                        String checkString = strToken.substring(endComPos + 1, endPos);
                        for (int i = 0; i < checkString.length(); ++i) {
                            if (checkString.charAt(i) != ' ' && checkString.charAt(i) != '\n') {
                                isOK = true;
                                break;
                            }
                            isOK = false;
                        }
                    }
                    if (!isOK) {
                        strToken = strToken.substring(0, endComPos) + strToken.substring(endComPos + 1);
                    }
                    fWriteSQL.writeBytes(strToken + ";\n\n");
                }
                if (!strWriteOtherSQL.equals("")) {
                    fWriteSQL.writeBytes(strWriteOtherSQL + "\n\n");
                }
            }
            fReadSQL.close();
            fWriteSQL.close();
            fWriteOtherSql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addForeignKeyValues(String strTableName, String strForeignTable, String strForeignKey, String strPrimaryKey, String strReference, String strConstraint, String strRest) {
        this.vecTableName.addElement(strTableName);
        this.vecForeignTable.addElement(strForeignTable);
        this.vecForeignKey.addElement(strForeignKey);
        this.vecPrimaryKey.addElement(strPrimaryKey);
        this.vecReference.addElement(strReference);
        this.vecConstraintName.addElement(strConstraint);
        this.vecFKRest.addElement(strRest);
    }

    public void addPrimaryKeyValues(String strTableName, String strPrimaryColumn, String strConstraintPrimary) {
        this.vecPrimaryKeyTableName.addElement(strTableName);
        this.vecPrimaryKeyColumn.addElement(strPrimaryColumn);
        this.vecConstraintPrimary.addElement(strConstraintPrimary);
    }

    public void addTableName(String strTableName) {
        boolean bEqual = false;
        for (int i = 0; i < this.vecDropTableTableName.size(); ++i) {
            if (!this.vecDropTableTableName.get(i).toString().equalsIgnoreCase(strTableName)) continue;
            bEqual = true;
        }
        if (!bEqual) {
            this.vecDropTableTableName.addElement(strTableName);
        }
    }

    public void addIndexValues(String strIndex) {
        this.vecCreateIndex.addElement(strIndex);
    }

    public void writeAlterTableForeignKey(File fOutputAlterTable) {
        try {
            RandomAccessFile fWriteAlterTable = new RandomAccessFile(fOutputAlterTable, "rw");
            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecTableName.size(); ++i) {
                fWriteAlterTable.writeBytes("\nALTER TABLE " + this.vecTableName.get(i).toString() + " ADD CONSTRAINT " + this.vecConstraintName.get(i).toString() + " FOREIGN KEY (" + this.vecForeignKey.get(i).toString() + ") REFERENCES " + this.vecForeignTable.get(i).toString() + " (" + this.vecPrimaryKey.get(i).toString() + ") " + this.vecReference.get(i).toString() + " " + this.vecFKRest.get(i).toString() + " ;\n");
            }
            fWriteAlterTable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeDropIntegrity(File fOutputDropIntegrity) {
        try {
            RandomAccessFile fWriteAlterTable = new RandomAccessFile(fOutputDropIntegrity, "rw");
            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecTableName.size(); ++i) {
                fWriteAlterTable.writeBytes("\nALTER TABLE " + this.vecTableName.get(i).toString() + " DROP CONSTRAINT " + this.vecConstraintName.get(i).toString() + " ;\n");
            }
            fWriteAlterTable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeDropPrimary(File fOutputDropPrimary) {
        try {
            RandomAccessFile fWriteAlterTable = new RandomAccessFile(fOutputDropPrimary, "rw");
            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecPrimaryKeyTableName.size(); ++i) {
                fWriteAlterTable.writeBytes("\nALTER TABLE " + this.vecPrimaryKeyTableName.get(i).toString() + " DROP CONSTRAINT " + this.vecConstraintPrimary.get(i).toString() + " ;\n");
            }
            fWriteAlterTable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeAlterTablePrimaryKey(File fOutputAlterTable) {
        try {
            RandomAccessFile fWriteAlterTable = new RandomAccessFile(fOutputAlterTable, "rw");
            fWriteAlterTable.seek(fWriteAlterTable.length());
            for (int i = 0; i < this.vecPrimaryKeyTableName.size(); ++i) {
                fWriteAlterTable.writeBytes("\nALTER TABLE " + this.vecPrimaryKeyTableName.get(i).toString() + " ADD CONSTRAINT " + this.vecConstraintPrimary.get(i).toString() + " PRIMARY KEY (" + this.vecPrimaryKeyColumn.get(i).toString() + ") ;\n");
            }
            fWriteAlterTable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeDropTable(File fOutputDropTable) {
        try {
            RandomAccessFile fWriteDropTable = new RandomAccessFile(fOutputDropTable, "rw");
            fWriteDropTable.seek(fWriteDropTable.length());
            for (int i = 0; i < this.vecDropTableTableName.size(); ++i) {
                fWriteDropTable.writeBytes("\nDROP TABLE " + this.vecDropTableTableName.get(i).toString() + " ;\n");
            }
            fWriteDropTable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeAlterTableIndex(File fOutputAlterTableIndex) {
        try {
            RandomAccessFile fWriteIndex = new RandomAccessFile(fOutputAlterTableIndex, "rw");
            fWriteIndex.seek(fWriteIndex.length());
            for (int i = 0; i < this.vecCreateIndex.size(); ++i) {
                fWriteIndex.writeBytes("\n" + this.vecCreateIndex.get(i).toString() + "\n");
            }
            fWriteIndex.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeDropTableIndex(File fOutputDropTableIndex) {
        try {
            RandomAccessFile fWriteIndex = new RandomAccessFile(fOutputDropTableIndex, "rw");
            fWriteIndex.seek(fWriteIndex.length());
            for (int i = 0; i < this.vecCreateIndex.size(); ++i) {
                String temp = this.vecCreateIndex.get(i).toString();
                fWriteIndex.writeBytes("\n DROP " + temp.substring(temp.indexOf("INDEX"), temp.indexOf("ON")) + ";\n");
            }
            fWriteIndex.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSplitSQLPrimary() {
        return this.splitSQLPrimary;
    }

    public void setSplitSQLPrimary(boolean b) {
        this.splitSQLPrimary = b;
    }
}

